<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_categorylevel('create')?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.categorylevel')?>
    <div class="container-fluid">
        <div id="ui-view">
            <div>
                <div class="animated fadeIn">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" action="<?=route_admin('categorylevel3s.create')?>" enctype="multipart/form-data" id="form">
                                <div class="card">
                                    <div class="card-header">
                                        <i class="fa fa-edit"></i> <?=lang_categorylevel('create')?>
                                        <div class="card-header-actions float-right">
                                            <a class="btn btn-block btn-secondary" href="<?=route_admin('categorylevel3.index')?>">
                                                <?=lang_common('back')?>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="input-group-prepend ">
                                                    <span class="input-group-text width-100"><?=lang_common('categorylevel1_name')?></span>
                                                </div>
                                                <select name="categorylevel1" id="categorylevel1" class="form-control input-lg">
                                                    <option value="">Select Categorylevel1</option>
                                                    <?php
                                                    
                                                    foreach($categorylevel1 as $row)
                                                    {
                                                        echo '<option value="'.$row["categorylevel1_code"].'">'.$row["categorylevel1_name"].'</option>';
                                                    }
                                                    
                                                    ?>
                                                </select>

                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="input-group-prepend ">
                                                    <span class="input-group-text width-100"><?=lang_common('categorylevel2_name')?></span>
                                                </div>
                                                <?php
                                                // var_dump($categorylevel2).'</br>';               
                                                ?>
                                                <select name="categorylevel2_code" id="categorylevel2" class="form-control input-lg">
                                                    <option value="">Select Categorylevel2</option>
                                                </select>
                                            </div>
                                        </div>
                                        <input type="hidden" name="categorylevel3_code" value="<?=$countcategorylevel3?>">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="input-group-prepend ">
                                                    <span class="input-group-text width-100"><?=lang_common('name')?></span>
                                                </div>
                                                <input class="form-control" id="categorylevel3_name" type="text" name="categorylevel3_name" value="<?=$item->categorylevel3_name?>">
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text width-100">
                                                    <?=lang_categorylevel('name_eng')?>
                                                    </span>
                                                </div>
                                                <input class="form-control" id="categorylevel3_name_eng" type="text" name="categorylevel3_name_eng" value="<?=$item->categorylevel3_name_eng?>">  검색과 연결되 수정할 수 없습니다.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer text-center">
                                        <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('create')?></button>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<!---------------------------->
<script>
$(document).ready(function(){
    $('#categorylevel1').change(function(){
        var categorylevel1_code = $('#categorylevel1').val();
        var action = 'get_categorylevel2';
        if(categorylevel1_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/CategorylevelSelect/action'); ?>",
                method:"POST",
                data:{categorylevel1_code:categorylevel1_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel2</option>';
                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].categorylevel2_code+'">'+data[count].categorylevel2_name+'</option>';
                    }
                    $('#categorylevel2').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel2').val('');
        }
        $('#categorylevel3').val('');
    });

    $('#categorylevel2').change(function(){
        var categorylevel2_code = $('#categorylevel2').val();
        var action = 'get_categorylevel3';
        if(categorylevel2_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/CategorylevelSelect/action'); ?>",
                method:"POST",
                data:{categorylevel2_code:categorylevel2_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel3</option>';
                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].categorylevel3_code+'">'+data[count].categorylevel3_name+'</option>';
                    }

                    $('#categorylevel3').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel3').val('');
        }
    });
});

</script>
<!-------------------------------->

<?= $this->endSection() ?>
