<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_categorylevel('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('sale-quote.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.categorylevel')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_categorylevel('category03')?>

                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('categorylevel.categorylevel1create')?>">
                              카테고리1 <?=lang_common('create')?>
                            </a>
                        </div>
                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('categorylevel.categorylevel1list')?>">
                              카테고리1 목록(수정)
                            </a>
                        </div>
                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('categorylevel.categorylevel2create')?>">
                              카테고리2 <?=lang_common('create')?>
                            </a>
                        </div>
                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('categorylevel.categorylevel2list')?>">
                              카테고리2 목록(수정)
                            </a>
                        </div>
                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('categorylevel.show_create')?>">
                              카테고리3 <?=lang_common('create')?>
                            </a>
                        </div>
                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('categorylevel.index')?>">
                              카테고리3 목록(수정)
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? 'show' : ''?>" id="collapseSearch">
                                    <form action="<?=route_admin('categorylevel.index')?>" method="get">
                                        <div class="card card-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group row pl-2">
                                                        <label class="col-form-label pl-3" for="categorylevel_name">
                                                            <?=lang_common('name')?> :
                                                        </label>
                                                        <div class="pl-2 col-md-4">
                                                            <input class="form-control" value="<?=$categorylevel_name?>" type="text" name="categorylevel_name">
                                                        </div>
                                                        <div class="pl-3">
                                                            <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                                <i class="fa fa-search" aria-hidden="true"></i>
                                                                <?=lang_common('search')?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="text-center checkbox">
                                                <input type="checkbox" name="check_all">
                                            </th>
                                            <th class="sorting_asc">
                                                <?=lang_common('no')?>
                                            </th>
                                            <!--th class="sorting">
                                                <?=lang_categorylevel('code')?>
                                            </th-->
                                            <th class="sorting app-col-name" >
                                                <?=lang_categorylevel('name')?>
                                            </th>
                                            <th class="sorting app-col-price" >
                                                <?=lang_categorylevel('name_eng')?>
                                            </th>
                                            <th class="sorting app-col-type" >
                                                <?=lang_common('insert_date')?>
                                            </th>
                                            <th class="update_date" >
                                                <?=lang_common('update_date')?>
                                            </th>
                                            <th class="sorting app-col-action">
                                                <?=lang_common('action')?>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $item): ?>
                                            <? #var_dump($lists); ?>
                                            <? #var_dump($key); ?>
                                            <? #var_dump($item); ?>
                                            <tr role="row" class="odd">
                                                <td class="text-center">
                                                    <input type="checkbox" name="check_box" value="<?=$item->categorylevel3_id?>">
                                                </td>
                                                <td class="text-right">
                                                    <?=show_no_row($key+1, $perPage, $currentPage)?>
                                                </td>
                                                <!--td>
                                                <?=$item->categorylevel3_code?>
                                                </td-->
                                                <td >
                                                    <?=$item->categorylevel3_name?>
                                                </td>
                                                <td class="">
                                                    <?=$item->categorylevel3_name_eng?>
                                                </td>
                                                <td class="">
                                                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at)?>
                                                </td>
                                                <td class="">
                                                    <?php if(\App\Helpers\DateHelper::toTimeString($item->created_at) != App\Helpers\DateHelper::toTimeString($item->updated_at)):?>
                                                        <?=\App\Helpers\DateHelper::toTimeString($item->updated_at)?>
                                                    <?php endif;?>
                                                </td>
                                                </td>
                                                <td class="text-center">
                                                    <a class="btn btn-info" title="<?=lang_common('detail')?>" href="<?=route_admin('categorylevel.show_update',$item->categorylevel3_id)?>">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                            <tr>
                                                <td colspan="8">
                                                    <?=lang_common('no_data')?>
                                                </td>
                                            </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-3">
                                            <a data-toggle="modal" class="btn btn-danger anchorClick delete"
                                               data-url="<?=route_admin('categorylevel.delete','')?>"
                                               data-url-origin="<?=route_admin('categorylevel.delete','')?>"
                                               data-name="<?=lang_categorylevel('title')?>" href="#deleteModal">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                <?=lang_common('delete')?>
                                            </a>
                                        </div>
                                        <div class="col-md-9">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
