<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_digikeyapiproductinfo('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
<style>
    th{text-align: center}
    .checkbox{width: 5%}
    th.no{width: 5%}
    th.category{width: 10%}
    th.title{width: 30%}
    th.id{width: 20%}
    th.date{width: 15%}
    th.hit{width: 5%}
    th.action{width: 10%}
    input[type=checkbox]{
        transform: scale(1.5);
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
<script src="<?=asset_admin_js('sale-quote.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.digikeyapiproductinfo')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_digikeyapiproductinfo('list_title')?>
                        <!--div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('digikeyapiproductinfo.standardinfo')?>">
                                <?=lang_common('standardinfo')?>
                            </a>
                        </div>
                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('digikeyapiproductinfo.to_products')?>">
                                <?=lang_common('to_products')?>
                            </a>
                        </div-->
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? '' : 'show'?>" id="collapseSearch">
                                    <form action="<?=route_admin('digikeyapiproductinfo.index')?>" method="get">
                                        <div class="card card-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group row pl-2">
                                                        <label class="col-form-label pl-3" for="date-input">
                                                        Manufacturer Partnumber :
                                                        </label>
                                                        <div class="pl-2 col-md-4">
                                                            <input class="form-control" value="<?="$manufacturer_pn"?>" type="text" name="manufacturer_pn">
                                                        </div>
                                                        <div class="pl-3">
                                                            <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                                <i class="fa fa-search" aria-hidden="true"></i>
                                                                <?=lang_common('search')?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="no">
                                                <?=lang_common('no')?>
                                            </th>
                                            <th class="code">
                                                <?=lang_common('code')?>
                                            </th>
                                            <th class="image">
                                                <?=lang_product('list_image')?>
                                            </th>
                                            <th class="code" >
                                                Manufacturer Partnumber
                                            </th>
                                            <th class="code" >
                                                Digikey Partnumber
                                            </th>
                                            <th class="code" >
                                                Packing
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Stock
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Price 1
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 1
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Price 2
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 2
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Price 3
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 3
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Price 4
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 4
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Price 5
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 5
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Price 6
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 6
                                            </th>
                                            <th class="date" >
                                                <?=lang_common('date')?>
                                            </th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $item): ?>

                                        <tr role="row" class="odd">
                                            <td class="text-right">
                                                <?=show_no_row($key+1, $perPage, $currentPage)?>
                                            </td>
                                            <td >
                                                <?=$item->api_code?>
                                            </td>
                                            <td class="text-center">
                                                <img src="<?=$item->image_dir?>" width="50"/>
                                            </td>
                                            <td class="">
                                                <?=$item->manufacturer_pn?>
                                            </td>
                                            <td class="">
                                                <?=$item->dk_pn?>
                                            </td>
                                            <td class="">
                                                <?=$item->packing_code?>
                                            </td>
                                            <td class="">
                                                <?=$item->qty?>
                                            </td>
                                            <td class="">
                                                <?=$item->price1?>
                                            </td>
                                            <td >
                                                <?=$item->mini_qty1?>
                                            </td>
                                            <td class="">
                                                <?=$item->price2?>
                                            </td>
                                            <td >
                                                <?=$item->mini_qty2?>
                                            </td>
                                            <td class="">
                                                <?=$item->price3?>
                                            </td>
                                            <td >
                                                <?=$item->mini_qty3?>
                                            </td>
                                            <td class="">
                                                <?=$item->price4?>
                                            </td>
                                            <td >
                                                <?=$item->mini_qty4?>
                                            </td>
                                            <td class="">
                                                <?=$item->price5?>
                                            </td>
                                            <td >
                                                <?=$item->mini_qty5?>
                                            </td>
                                            <td class="">
                                                <?=$item->price6?>
                                            </td>
                                            <td >
                                                <?=$item->mini_qty6?>
                                            </td>
                                            <td class="">
                                                <?=\App\Helpers\DateHelper::toTimeString($item->created_at)?>
                                            </td>

                                        </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                            <tr>
                                                <td colspan="19">
                                                    <?=lang_common('no_data')?>
                                                </td>
                                            </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
