<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_displayinfo('create_displayinfo')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">

<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.displayinfo.create')?>

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link href="<?=asset_css('select2.min.css')?>" rel="stylesheet" />
    <script src="<?=asset_js('select2.min.js')?>"></script>
    <script src="<?=asset_js('select2_i18n/ko.js')?>"></script>


    <div class="container-fluid">
        <div id="ui-view">
            <div>
                <div class="animated fadeIn">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" action="<?=route_admin('displayinfo.create')?>" enctype="multipart/form-data" id="form">
                                <div class="card">
                                    <div class="card-header">
                                        <i class="fa fa-edit"></i> <?=lang_displayinfo('create_displayinfo')?>
                                        <div class="card-header-actions float-right">
                                            <a class="btn btn-block btn-secondary" href="<?=route_admin('displayinfo.index')?>">
                                                <?=lang_common('back')?>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('code')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input class="form-control" id="display_code" type="text" disabled value="<?=$displayinfo_code?>">
                                                <input type="hidden" name="display_code" value="<?=$displayinfo_code?>"/>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('ID')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_NEW?>" checked id="display_id_newproduct">
                                                        <label class="form-check-label" for="display_id_newproduct"><?=lang_displayinfo('ID_newproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_BEST?>" id="display_id_bestproduct">
                                                        <label class="form-check-label" for="display_id_bestproduct"><?=lang_displayinfo('ID_bestproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_BRAND?>" id="display_id_brandproduct">
                                                        <label class="form-check-label" for="display_id_brandproduct"><?=lang_displayinfo('ID_brandproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_RECOM?>" id="display_id_recomproduct">
                                                        <label class="form-check-label" for="display_id_recomproduct"><?=lang_displayinfo('ID_recomproduct')?></label>
                                                    </div>
                                                </div>
                                                <!--input class="form-control" id="text-input" type="text" name="display_id" placeholder="<?=lang_displayinfo('ID')?>"-->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('name')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                    <!--select class="search form-control" name="display_name"></select-->
                                                <input class="form-control" id="text-input" type="text" name="display_name" placeholder="<?=lang_common('name')?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('flg')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_flg" type="radio" value="<?=DISPLAY_STATUS_ON?>" checked id="display_status_on">
                                                        <label class="form-check-label" for="display_status_on"><?=lang_common('display_status_on')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_flg" type="radio" value="<?=DISPLAY_STATUS_OFF?>" id="display_status_off">
                                                        <label class="form-check-label" for="display_status_off"><?=lang_common('display_status_off')?></label>
                                                    </div>
                                                </div>
                                                <!--input class="form-control" id="text-input" type="text" name="display_flg" placeholder="<?=lang_displayinfo('flg')?>"-->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('type')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_type" type="radio" value="<?=DISPLAY_CATEGORY_GRID?>" checked id="display_type_grid">
                                                        <label class="form-check-label" for="display_type_grid"><?=lang_common('display_type_grid')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_type" type="radio" value="<?=DISPLAY_CATEGORY_LIST?>" id="display_type_list">
                                                        <label class="form-check-label" for="display_type_list"><?=lang_common('display_type_list')?></label>
                                                    </div>
                                                </div>
                                                <!--input class="form-control" id="text-input" type="text" name="display_type" placeholder="<?=lang_displayinfo('type')?>"-->
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="anufacturer_id">
                                                <?=lang_product('list_manufacturer')?>
                                            </label>
                                            <div class="col-md-10">
                                                <select class="form-control" id="maker_seq" name="maker_seq">
                                                    <?php foreach ($manufacturers as $manufacturer): ?>
                                                        <option value="<?=$manufacturer->maker_seq?>"><?=$manufacturer->name?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('number')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input class="form-control" id="text-input" type="text" name="display_number" placeholder="<?=lang_displayinfo('number')?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('file_dir')?>
                                            </label>
                                            <div class="col-md-10">
                                                <input type="file" class="custom-file-input" id="image_file" name="image_file" maxsizeMb="10" accept="image/*">
                                                <label class="custom-file-label" for="image_file"> Chose File</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer text-center">
                                        <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('create')?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
      $('.search').select2({
        placeholder: '<?=lang_common('name')?> 검색',
        language: "ko",
        ajax: {
          url: '<?php echo base_url('ManufacturerSearch/ajaxSearch');?>',
          dataType: 'json',
          delay: 250,
          processResults: function(data){
            return {
              results: data
            };
          },
          cache: true
        }
      });
    </script>

<?= $this->endSection() ?>
