<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_displayinfo('update_displayinfo')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.displayinfo.update')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('displayinfo.update',$item->id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                                <div class="card-header">
                                    <i class="fa fa-edit"></i> <?=lang_displayinfo('update_displayinfo')?>
                                    <div class="card-header-actions float-right">
                                        <a class="btn btn-block btn-secondary" href="<?=route_admin('displayinfo.index')?>">
                                            <?=lang_common('back')?>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">

                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('code')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10">
                                            <input class="form-control" value="<?=old_value('display_code',$item->display_code)?>" id="text-input" type="text" disabled placeholder="<?=lang_common('code')?>" required>
                                            <input type="hidden" name="display_code" value="<?=old_value('display_code',$item->display_code)?>"/>
                                        </div>
                                    </div>                                
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_displayinfo('ID')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_NEW?>" id="display_id_newproduct" <?php if($item->display_id == DISPLAY_PRODUCT_NEW) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_id_newproduct"><?=lang_displayinfo('ID_newproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_BEST?>" id="display_id_bestproduct" <?php if($item->display_id == DISPLAY_PRODUCT_BEST) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_id_bestproduct"><?=lang_displayinfo('ID_bestproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_BRAND?>" id="display_id_brandproduct" <?php if($item->display_id == DISPLAY_PRODUCT_BRAND) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_id_brandproduct"><?=lang_displayinfo('ID_brandproduct')?></label>
                                                    </div>

                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_id" type="radio" value="<?=DISPLAY_PRODUCT_RECOM?>" id="display_id_recomproduct" <?php if($item->display_id == DISPLAY_PRODUCT_RECOM) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_id_recomproduct"><?=lang_displayinfo('ID_recomproduct')?></label>
                                                    </div>
                                                </div>
                                            <!--input class="form-control" value="<?=old_value('display_id',$item->display_id)?>" id="text-input" type="text" name="display_id" placeholder="<?=lang_displayinfo('ID')?>" required-->
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('name')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10"><?=$item->display_name?>
                                            <input class="form-control" value="<?=old_value('display_name',$item->display_name)?>" id="text-input" type="text" name="display_name" placeholder="<?=lang_common('name')?>" required>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('flg')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                            <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_flg" type="radio" value="<?=DISPLAY_STATUS_ON?>" id="display_status_on" <?php if($item->display_flg == DISPLAY_STATUS_ON) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_status_on"><?=lang_common('display_status_on')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_flg" type="radio" value="<?=DISPLAY_STATUS_OFF?>" id="display_status_off" <?php if($item->display_flg == DISPLAY_STATUS_OFF) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_status_off"><?=lang_common('display_status_off')?></label>
                                                    </div>
                                                </div>
                                                <!--input class="form-control" value="<?=old_value('display_flg',$item->display_flg)?>" id="text-input" type="text" name="display_flg" placeholder="<?=lang_displayinfo('flg')?>"-->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('type')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_type" type="radio" value="<?=DISPLAY_CATEGORY_GRID?>" id="display_type_grid" <?php if($item->display_type == DISPLAY_CATEGORY_GRID) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_type_grid"><?=lang_common('display_type_grid')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_type" type="radio" value="<?=DISPLAY_CATEGORY_LIST?>" id="display_type_list" <?php if($item->display_type == DISPLAY_CATEGORY_LIST) echo 'checked' ?>>
                                                        <label class="form-check-label" for="display_type_list"><?=lang_common('display_type_list')?></label>
                                                    </div>
                                                </div>
                                                <!--input class="form-control" value="<?=old_value('display_type',$item->display_type)?>" id="text-input" type="text" name="display_type" placeholder="<?=lang_displayinfo('type')?>"-->
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('number')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input class="form-control" value="<?=old_value('display_number',$item->display_number)?>" id="text-input" type="text" name="display_number" placeholder="<?=lang_displayinfo('number')?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="anufacturer_id">
                                                <?=lang_product('list_manufacturer')?>
                                            </label>
                                            <div class="col-md-10">
                                                <select class="form-control" id="maker_seq" name="maker_seq">
                                                        <?php foreach ($manufacturers as $manufacturer): ?>
                                                            <option value="<?=$manufacturer->maker_seq?>" <?php if($manufacturer->maker_seq == $item->maker_seq) echo 'selected';?> ><?=$manufacturer->name?></option>
                                                        <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_displayinfo('file_dir')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input type="file" class="custom-file-input" id="image_file" name="image_file" maxsizeMb="10" accept="image/*">
                                                <label class="custom-file-label" for="image_file"> <?=show_text_dot($item->display_file_dir,50)?></label>
                                            </div>
                                        </div>

                                </div>
                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
