<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_eventinfo('create_eventinfo')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>

    <script src="<?=asset_admin_js('sale-quote.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
    <script src="<?=asset_admin_js('advanced-forms.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        .date{width: 10%}
        .quote_no{width: 10%}
        .amount{width: 10%}
        .name{width: 15%}
        .email{width: 15%}
        .action{width: 10%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
        a.disabled {
            pointer-events: none;
            cursor: default;
        }
    </style>
<?= $this->endSection() ?>


<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.eventinfo.create')?>
    <div class="container-fluid">
        <div id="ui-view">
            <div>
                <div class="animated fadeIn">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" action="<?=route_admin('eventinfo.create')?>" enctype="multipart/form-data" id="form">
                                <div class="card">
                                    <div class="card-header">
                                        <i class="fa fa-edit"></i> <?=lang_eventinfo('create_eventinfo')?>
                                        <div class="card-header-actions float-right">
                                            <a class="btn btn-block btn-secondary" href="<?=route_admin('eventinfo.index')?>">
                                                <?=lang_common('back')?>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('name')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input class="form-control" id="text-input" type="text" name="event_title" placeholder="<?=lang_common('name')?>">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('display_status')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_status" type="radio" value="<?=DISPLAY_STATUS_ON?>" checked id="display_status_on">
                                                        <label class="form-check-label" for="display_status_on"><?=lang_common('display_status_on')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_status" type="radio" value="<?=DISPLAY_STATUS_OFF?>" id="display_status_off">
                                                        <label class="form-check-label" for="display_status_off"><?=lang_common('display_status_off')?></label>
                                                    </div>
                                                </div>
                                                    <!-- input class="form-control" id="text-input" type="text" name="display_status" placeholder="<?=lang_common('display_status')?>"-->
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('start_date')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-4">
                                                <input class="form-control date-single" value="<?=$from_date?>" id="text-input" type="text" name="event_start_date" placeholder="<?=lang_common('start_date')?>">
  
                                            </div>

                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('end_date')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-4">
                                                <input class="form-control date-single" value="<?=$to_date?>" id="text-input" type="text" name="event_end_date" placeholder="<?=lang_common('end_date')?>">
                                            </div>
                                        </div>

                                        <!--div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('width_size')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-4">
                                                <input class="form-control" id="text-input" type="text" name="width_size" placeholder="<?=lang_common('width_size')?>">
  
                                            </div>

                                            <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('height_size')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-4">
                                                <input class="form-control" id="text-input" type="text" name="height_size" placeholder="<?=lang_common('height_size')?>">
                                            </div>
                                        </div-->

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('file_upload')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input type="file" class="custom-file-input" id="image_file" name="image_file" maxsizeMb="10" accept="image/*">
                                                <label class="custom-file-label" for="image_file"> Chose File</label>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('display_type')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_type" type="radio" value="<?=DISPLAY_CATEGORY_GRID?>" checked id="display_type_grid">
                                                        <label class="form-check-label" for="display_type_grid"><?=lang_common('display_type_grid')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                        <input class="form-check-input" name="display_type" type="radio" value="<?=DISPLAY_CATEGORY_LIST?>" id="display_type_list">
                                                        <label class="form-check-label" for="display_type_list"><?=lang_common('display_type_list')?></label>
                                                    </div>
                                                </div>
                                                    <!-- input class="form-control" id="text-input" type="text" name="display_type" placeholder="<?=lang_common('display_type')?>"-->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer text-center">
                                        <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('create')?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?= $this->endSection() ?>