<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_product('loop_upload_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/css/bootstrap.min.css" rel="stylesheet">
	<style>
	  .container {
		max-width: 500px;
	  }
	</style>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.product.loop_upload')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_product('loop_upload_title')?>
                    </div>
                    <div class="card-body">

                        <div class="card card-body">
                            <!--div class="row col-md-12 text-md-center">
                                <span style="color: blue;padding-top: 1px;" class="pr-1"><i class="fas fa-cloud-upload-alt"></i></span>
                                <h4><?=lang_product('loop_upload_process')?></h4>
                            </div>
                            <div class="row col-md-12">
                                1 . <?=lang_product('loop_upload_step_one')?>
                            </div>
                            <div class="row col-md-12">
                                2 . <?=lang_product('loop_upload_step_two')?>
                            </div>
                            <div class="row col-md-12">
                                3 . <?=lang_product('loop_upload_step_three')?>
                            </div>
                            <div class="row col-md-12">
                                4 . <?=lang_product('loop_upload_step_four')?>
                            </div>
                            <div class="row col-md-12">
                                5 . <?=lang_product('loop_upload_step_five')?>
                            </div-->
                            <div class="row col-md-12 pl-4">
                                <a href="<?=route_admin('product.loop_upload.download_template')?>">
                                    [ <i class="fas fa-download"></i> <?=lang_product('loop_upload_sample_file_download')?> ]
                                </a>
                            </div>
                        </div>

						<div class="container mt-5">
							<div class="card">
								<div class="card-header text-center">
									<strong>Upload CSV File</strong>
								</div>
								<div class="card-body">
								<div class="mt-2">
									<?php if (session()->has('message')){ ?>
										<div class="alert <?=session()->getFlashdata('alert-class') ?>">
											<?=session()->getFlashdata('message') ?>
										</div>
									<?php } ?>
									<?php $validation = \Config\Services::validation(); ?>
								</div>	
									<form action="<?=route_admin('product.loop.importCsvToDb')?>" method="post" enctype="multipart/form-data">
										<div class="d-grid">
											<input type="submit" name="submit" value="Upload" class="btn btn-dark" />
										</div>
									</form>
								</div>
							</div>
						</div>

					</div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>