<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_inquiry('update_inquiry')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">

    <style>
        .ck-editor__editable[role="textbox"] {
          min-height: 400px;
        }
      
        .ck-content .image {
          max-width: 80%;
          margin: 20px auto;
        }
    </style>

<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.inquiry.update')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('inquiry.update',$item->id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                                <div class="card-header">
                                    <i class="fa fa-edit"></i> <?=lang_inquiry('update_inquiry')?>
                                    <div class="card-header-actions float-right">
                                        <a class="btn btn-block btn-secondary" href="<?=route_admin('inquiry.index')?>">
                                            <?=lang_common('back')?>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">


<!---------------------------------------------------------------------------------------------------------------->
<div class="card card-secondary">
                                    <div class="card-header font-weight-bold">
                                        <?=lang_sale('quote_detail_item')?>
                                    </div>
                                    <div class="card-body" style="padding: 10px">

                                    <table class="table table-responsive-sm">
                    <thead>
                    <tr>
                        <th>제품사진</th>
                        <th>문의상품</th>
                        <th>MOQ / MPQ</th>
                        <th>재고위치 / 배송비</th>
                        <th>제품 수량/단가</th>
                </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>
                            <?php if(isset($productinfo->image_dir) && $productinfo->image_dir != ''): ?>
                            <?php if(isset($productinfo->api_flg) && $productinfo->api_flg == '1'): ?>
                                <img src="<?=$productinfo->image_dir?>" width="100"/>
                            <?php else : ?>
                                <img src="<?=asset_public($productinfo->image_dir)?>" width="100"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>" width="100"/>
                        <?php endif; ?>
                        </td>
                        <td>

                                    <p class="subWrap01ContsName02_sub01">
                        <?=$productinfo->name?>
                                    </p>
                                    <p class="subWrap01ContsName02_sub02">
                        <?=$productinfo->part_number?>
                        </p>
                                    <p class="subWrap01ContsName02_sub03">
                        <?=$productinfo->part_number_sequence?>
                        </p>
                        <!--p class="subWrap01ContsName02_sub04">
                            <?php
                            echo mb_strimwidth($productinfo->brief_description,'0',60,'...','utf-8');
                            ?>
                            <br>
                            관련 부품 : <?=$productinfo->product_related?>
                        </p-->
                        </td>
                        <td>
                                <div class="subWrap01ContsName03_sub">
                                    <table border="0">
                                    <tr>
                                    <td width="50%" align="left">MOQ :</td><td align="right"><?=\App\Helpers\NumberHelper::format($productinfo->moq, true)?></td>
                                    </tr>
                                    <tr>
                                    <td width="50%" align="left">MPQ :</td><td align="right"><?=\App\Helpers\NumberHelper::format($productinfo->mpq, true)?></td>
                                    </tr>
                                    </table>
                                </div>
                        </td>
                        <td>
                                    <div class="subWrap01subTag0<?=$productinfo->stock_location?>"><span><?=$productinfo->location_info?></span></div>
                                    <span><?=$productinfo->leadtime_info?></span>
                                    <?=$productinfo->delivery_info?> 배송비

                      </td>
                        <td>
                                <div class="subWrap01ContsName04_sub">
                                    <!--p class="subWrap01price">
                                        <?=\App\Helpers\NumberHelper::format($productinfo->selling_price1, true)?><?=lang_sale('price_unit')?>
                                    </p-->

                                    <table border="0">
                                    <tr><td>

                                            <?php 
                                                if($productinfo->unit_mini_quantity1 > 0) {
                                                echo '<p>수량단가1 : '.$productinfo->unit_mini_quantity1.' ~ ';
                                                if($productinfo->unit_mini_quantity2 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity2;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price1, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>    

                                            <?php 
                                                if($productinfo->unit_mini_quantity2 > 0) {
                                                echo '<p>수량단가2 : '.$productinfo->unit_mini_quantity2.' ~ ';
                                                if($productinfo->unit_mini_quantity3 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity3;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price2, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>   

                                            <?php 
                                                if($productinfo->unit_mini_quantity3 > 0) {
                                                echo '<p>수량단가3 : '.$productinfo->unit_mini_quantity3.' ~ ';
                                                if($productinfo->unit_mini_quantity4 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity4;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price3, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>

                                    </td><td>

                                            <?php 
                                                if($productinfo->unit_mini_quantity4 > 0) {
                                                echo '<p>수량단가4 : '.$productinfo->unit_mini_quantity4.' ~ ';
                                                if($productinfo->unit_mini_quantity5 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity5;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price4, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>    

                                            <?php 
                                                if($productinfo->unit_mini_quantity5 > 0) {
                                                echo '<p>수량단가5 : '.$productinfo->unit_mini_quantity5.' ~ ';
                                                if($productinfo->unit_mini_quantity6 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity3;} else {echo '&#8764;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price5, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>   

                                            <?php 
                                                if($productinfo->unit_mini_quantity6 > 0) {
                                                echo '<p>수량단가6 : '.$productinfo->unit_mini_quantity6.' ~ ';
                                                echo '&#8734;';
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price6, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>

                                        </td>
                                        </tr>
                                      </table>
                                    </div>
                                </div>

                                </td>
                    </tr>
                                </tbody>
                                        </table>
                                    </div>
                                </div>
 

  <!-------------------------------------------------------------------------------------------------------------------->

  <div class="card card-secondary">
                                    <div class="card-header font-weight-bold">
                                        문의내용
                                    </div>
                                    <div class="card-body" style="padding: 10px">

                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('user_name')?>
                                        </label>
                                        <div class="col-md-2">
                                          <input class="form-control" value="<?=old_value('user_name',$item->user_name)?>" id="text-input" type="text" name="user_name" placeholder="<?=lang_common('user_name')?>" required>
                                        </div>
                                        <label class="col-md-1 col-form-label" for="text-input">
                                            <?=lang_common('user_email')?>
                                        </label>
                                        <div class="col-md-2">
                                          <input class="form-control" value="<?=old_value('user_email',$item->user_email)?>" id="text-input" type="text" name="user_email" placeholder="<?=lang_common('user_email')?>" required>
                                        </div>
                                        <div class="col-md-1">
                                          <?=lang_common('reply_note')?>
                                        </div>
                                        <div class="col-md-1">
                                          <input class="form-check-input" name="replyemeil_chk" type="radio" value="<?=DISPLAY_PRODUCT_NEW?>" id="replyemeil_chk" <?php if($item->replyemeil_chk == DISPLAY_PRODUCT_NEW) echo 'checked' ?>> 
                                        </div>
                                        <label class="col-md-1 col-form-label" for="text-input">
                                            <?=lang_common('user_phone')?>
                                        </label>
                                        <div class="col-md-2">
                                          <input class="form-control" value="<?=old_value('user_phone',$item->user_phone)?>" id="text-input" type="text" name="user_phone" placeholder="<?=lang_common('user_phone')?>" required>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('category')?>
                                        </label>
                                        <div class="col-md-6">
                                            <select class="form-control" name="category_id">
                                                <?php foreach ($categories as $category): ?>
                                                    <option value="<?=$category->category_id?>" <?php if($item->category_id == $category->category_id) echo 'selected' ?>>
                                                        <?=$category->category_name?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <label class="col-md-1 col-form-label" for="text-input">
                                                <?=lang_common('situation')?>
                                        </label>
                                        <div class="col-md-3">
                                            <div class="icheck-primary d-inline pl-2">
                                                <input type="radio" id="situation01" name="situation" value="1" <?php if($item->situation == 1) echo 'checked' ?>>
                                                <label for="situation01">
                                                    <?=lang_common('situation01')?>
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline pl-2">
                                                <input type="radio" id="situation02" name="situation" value="2" <?php if($item->situation == 2) echo 'checked' ?>>
                                                <label for="situation02">
                                                    <?=lang_common('situation02')?>
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline pl-2">
                                                <input type="radio" id="situation03" name="situation" value="3" <?php if($item->situation == 3) echo 'checked' ?>>
                                                <label for="situation03">
                                                    <?=lang_common('situation03')?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('title')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10">
                                            <input class="form-control" value="<?=old_value('title',$item->title)?>" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>" required>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('file_upload')?>
                                        </label>
                                        <div class="col-md-10 file_upload">
                                            <?php foreach ($files as $index => $fileItem): ?>
                                                <div class="input-group">
                                                    <label><?=$fileItem->file_name?></label>
                                                    <a href="<?=route_admin('inquiry.delete_file',$item->id,$fileItem->file_no)?>" class="pl-2">
                                                        <i class="fa fa-trash color-red" aria-hidden="true"></i>
                                                    </a>
                                                </div>
                                            <?php endforeach;?>
                                            <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                                <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                                                        <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                                                    </div>
                                                    <div class="file_action">
                                                        <?php if($i > 1): ?>
                                                            <a href="javascript:void(0)" class="button-delete color-red">
                                                                <i class="fa fa-minus-square"></i>
                                                            </a>
                                                        <?php else: ?>
                                                            <a href="javascript:void(0)" class="button-add">
                                                                <i class="fas fa-plus-circle"></i>
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endfor; ?>
                                            <span class="help-block">
                                                <code>
                                                    <i class="fa fa-exclamation" aria-hidden="true"></i>
                                                    <?=lang_inquiry('file_upload_note')?>
                                                </code>
                                            </span>
                                        </div>
                                    </div>
                                    <!--<div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('public')?>
                                        </label>
                                        <div class="col-md-10">
                                            <input type="checkbox" name="public_flg" <?=public_check_input($item->public_flg)?> data-bootstrap-switch>
                                        </div>
                                    </div>-->
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('question')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <textarea class="form-control" id="content" name="content" rows="8"><?php echo htmlspecialchars_decode($item->content)?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label" for="text-input">
                                            <?=lang_common('answer')?>
                                            <span class="color-red">*</span>
                                        </label>
                                        <div class="col-md-10">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <textarea class="form-control" id="answer_content" name="answer_content" rows="8"><?php echo htmlspecialchars_decode($item->answer_content)?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>

<script src="<?=asset_js('ckeditor.js')?>"></script>
<script src="<?=asset_js('ko.js')?>"></script>

  <script>
    CKEDITOR.ClassicEditor.create(document.getElementById("content"), {
      language: "ko",
      toolbar: {
        items: [
          //'exportPDF', 'exportWord', '|',
          'findAndReplace', 'selectAll', '|',
          'heading', '|',
          'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
          'bulletedList', 'numberedList', 'todoList', '|',
          'outdent', 'indent', '|',
          'undo', 'redo', '|',
          'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
          'alignment', '|',
          'link', 'insertImage', 'blockQuote', 'insertTable', 
          //'mediaEmbed', 
          'codeBlock', 'htmlEmbed', '|','specialCharacters', 'horizontalLine', 'pageBreak', '|',
          // 'textPartLanguage', '|',
          'sourceEditing'
        ],
        shouldNotGroupWhenFull: true
      },
      list: {
        properties: {
          styles: true,
          startIndex: true,
          reversed: true
        }
      },
      heading: {
        options: [
          { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
          { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
          { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
          { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' },
          { model: 'heading4', view: 'h4', title: 'Heading 4', class: 'ck-heading_heading4' },
          { model: 'heading5', view: 'h5', title: 'Heading 5', class: 'ck-heading_heading5' },
          { model: 'heading6', view: 'h6', title: 'Heading 6', class: 'ck-heading_heading6' }
        ]
      },
      placeholder: '내용을 입력하세요!',
      fontFamily: {
        options: [
          'default',
          'Arial, Helvetica, sans-serif',
          'Courier New, Courier, monospace',
          'Georgia, serif',
          'Lucida Sans Unicode, Lucida Grande, sans-serif',
          'Tahoma, Geneva, sans-serif',
          'Times New Roman, Times, serif',
          'Trebuchet MS, Helvetica, sans-serif',
          'Verdana, Geneva, sans-serif'
        ],
        supportAllValues: true
      },
      fontSize: {
        options: [10, 12, 14, 'default', 18, 20, 22],
        supportAllValues: true
      },
      htmlSupport: {
        allow: [
          {
            name: /.*/,
            attributes: true,
            classes: true,
            styles: true
          }
        ]
      },
      htmlEmbed: {
        showPreviews: true
      },
      link: {
        decorators: {
          addTargetToExternalLinks: true,
          defaultProtocol: 'https://',
          toggleDownloadable: {
            mode: 'manual',
            label: 'Downloadable',
            attributes: {
              download: 'file'
            }
          }
        }
      },
      mention: {
        feeds: [
          {
            marker: '@',
            feed: [
              '@apple', '@bears', '@brownie', '@cake', '@cake', '@candy', '@canes', '@chocolate', '@cookie', '@cotton', '@cream',
              '@cupcake', '@danish', '@donut', '@dragée', '@fruitcake', '@gingerbread', '@gummi', '@ice', '@jelly-o',
              '@liquorice', '@macaroon', '@marzipan', '@oat', '@pie', '@plum', '@pudding', '@sesame', '@snaps', '@soufflé',
              '@sugar', '@sweet', '@topping', '@wafer' 
            ],
            minimumCharacters: 1
          }
        ]
      },
      removePlugins: [
        'ExportPdf',
        'ExportWord',
        'CKBox',
        'CKFinder',
        'EasyImage',
        'RealTimeCollaborativeComments',
        'RealTimeCollaborativeTrackChanges',
        'RealTimeCollaborativeRevisionHistory',
        'PresenceList',
        'Comments',
        'TrackChanges',
        'TrackChangesData',
        'RevisionHistory',
        'Pagination',
        'WProofreader',
        'MathType'
      ]
    });
  </script>

<script>
    CKEDITOR.ClassicEditor.create(document.getElementById("answer_content"), {
      language: "ko",
      toolbar: {
        items: [
          //'exportPDF', 'exportWord', '|',
          'findAndReplace', 'selectAll', '|',
          'heading', '|',
          'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
          'bulletedList', 'numberedList', 'todoList', '|',
          'outdent', 'indent', '|',
          'undo', 'redo', '|',
          'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
          'alignment', '|',
          'link', 'insertImage', 'blockQuote', 'insertTable', 
          //'mediaEmbed', 
          'codeBlock', 'htmlEmbed', '|','specialCharacters', 'horizontalLine', 'pageBreak', '|',
          // 'textPartLanguage', '|',
          'sourceEditing'
        ],
        shouldNotGroupWhenFull: true
      },
      list: {
        properties: {
          styles: true,
          startIndex: true,
          reversed: true
        }
      },
      heading: {
        options: [
          { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
          { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
          { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
          { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' },
          { model: 'heading4', view: 'h4', title: 'Heading 4', class: 'ck-heading_heading4' },
          { model: 'heading5', view: 'h5', title: 'Heading 5', class: 'ck-heading_heading5' },
          { model: 'heading6', view: 'h6', title: 'Heading 6', class: 'ck-heading_heading6' }
        ]
      },
      placeholder: '내용을 입력하세요!',
      fontFamily: {
        options: [
          'default',
          'Arial, Helvetica, sans-serif',
          'Courier New, Courier, monospace',
          'Georgia, serif',
          'Lucida Sans Unicode, Lucida Grande, sans-serif',
          'Tahoma, Geneva, sans-serif',
          'Times New Roman, Times, serif',
          'Trebuchet MS, Helvetica, sans-serif',
          'Verdana, Geneva, sans-serif'
        ],
        supportAllValues: true
      },
      fontSize: {
        options: [10, 12, 14, 'default', 18, 20, 22],
        supportAllValues: true
      },
      htmlSupport: {
        allow: [
          {
            name: /.*/,
            attributes: true,
            classes: true,
            styles: true
          }
        ]
      },
      htmlEmbed: {
        showPreviews: true
      },
      link: {
        decorators: {
          addTargetToExternalLinks: true,
          defaultProtocol: 'https://',
          toggleDownloadable: {
            mode: 'manual',
            label: 'Downloadable',
            attributes: {
              download: 'file'
            }
          }
        }
      },
      mention: {
        feeds: [
          {
            marker: '@',
            feed: [
              '@apple', '@bears', '@brownie', '@cake', '@cake', '@candy', '@canes', '@chocolate', '@cookie', '@cotton', '@cream',
              '@cupcake', '@danish', '@donut', '@dragée', '@fruitcake', '@gingerbread', '@gummi', '@ice', '@jelly-o',
              '@liquorice', '@macaroon', '@marzipan', '@oat', '@pie', '@plum', '@pudding', '@sesame', '@snaps', '@soufflé',
              '@sugar', '@sweet', '@topping', '@wafer' 
            ],
            minimumCharacters: 1
          }
        ]
      },
      removePlugins: [
        'ExportPdf',
        'ExportWord',
        'CKBox',
        'CKFinder',
        'EasyImage',
        'RealTimeCollaborativeComments',
        'RealTimeCollaborativeTrackChanges',
        'RealTimeCollaborativeRevisionHistory',
        'PresenceList',
        'Comments',
        'TrackChanges',
        'TrackChangesData',
        'RevisionHistory',
        'Pagination',
        'WProofreader',
        'MathType'
      ]
    });
  </script>

<?= $this->endSection() ?>
