<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>SHOP - <?= $this->renderSection('head.title') ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <!--meta name="viewport" content="width=device-width, initial-scale=1"-->
    <meta name="viewport" content="width=device-width, initial-scale=0, shrink-to-fit=no">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?=asset_admin_css('lte/plugins/fontawesome-free/css/all.min.css')?>">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Header Css -->
    <?= $this->renderSection('head.first_css') ?>
    <!-- Toastr -->
    <link rel="stylesheet" href="<?=asset_admin_css('lte/plugins/toastr/toastr.min.css')?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?=asset_admin_css('lte/adminlte.min.css')?>">
    <link href="<?=asset_admin_css('style.css')?>" rel="stylesheet">

    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

    <!-- Header Css -->
    <?= $this->renderSection('head.css') ?>

    <!-- jQuery -->
    <script src="<?=asset_admin_js('lte/jquery.min.js')?>"></script>

</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
<!--body style="width:2000px; min-width:2000px; background-color: #EEE; margin: 0 auto;">
    <div style="width:2000px; min-width:2000px;"-->

        <!-- Header -->
        <?= view_cell('\App\Controllers\Admin\Layout\HeaderController::index') ?>

        <!-- Left Menu -->
        <?= view_cell('\App\Controllers\Admin\Layout\LeftMenuController::index') ?>

        <!-- Content Wrapper. Contains page content -->
        <!-- Main-->
        <div class="content-wrapper">
            <!-- @include('admin.common.__breadcrumb')-->
            <!-- @yield('body.breadcrumb')-->

            <!-- Render Body Content -->
            <?= $this->renderSection('content') ?>
        </div>

        <!-- Footer -->
        <?= view_cell('\App\Controllers\Admin\Layout\FooterController::index') ?>

    </div>


    <!-- Bootstrap 4 -->
    <script src="<?=asset_admin_js('lte/bootstrap.bundle.min.js')?>"></script>
    <!-- SweetAlert2 -->
    <script src="<?=asset_admin_js('lte/sweetalert2.min.js')?>"></script>
    <!-- Toastr -->
    <script src="<?=asset_admin_js('lte/toastr.min.js')?>"></script>
    <!-- AdminLTE App -->
    <script src="<?=asset_admin_js('lte/adminlte.min.js')?>"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="<?=asset_admin_js('lte/demo.js')?>"></script>

    <!-- Validation JS -->
    <script src="<?=asset_js('jquery.validate.js')?>"></script>
    <script src="<?=asset_js('additional-methods.min.js')?>"></script>
    <script src="<?=asset_js('jquery.validator.addMethod.js')?>"></script>

    <?php if(isset($validation)): ?>
        <script>
            var validation = $("#form").validate({
                'errorClass' : 'is-invalid',
                'errorElement' : 'span',
                'errorElementClass' : 'error invalid-feedback',
                <?=$validation['rules']?>,
                <?=$validation['messages']?>
            });
        </script>
    <?php endif?>
    <?php if($session->has('message') || $session->has('error_message')): ?>
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000
            });
            <?php if($session->has('message')): ?>
                toastr.success('<?=$session->get('message')?>');
            <?php elseif ($session->has('error_message')):?>
                toastr.error('<?=$session->get('error_message')?>');
            <?php endif;?>
        </script>
    <?php endif; ?>

    <!--Body Js-->
    <?= $this->renderSection('body.js') ?>


    <?=$this->include('admin/common/__popup_confirm_delete')?>
    <?=$this->include('admin/common/__popup_danger_modal')?>
    <?=$this->include('admin/common/__popup_success_modal')?>
    <?=$this->include('admin/common/__popup_taxinvoice_modal')?>
    
    <!--Render Body Popup-->
    <?= $this->renderSection('body.popup') ?>

    <?=$this->include('admin/common/__loading')?>

    <!-- Data Validation -->
    <?=$this->include('common/validations/value_data')?>

</body>
</html>