<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_manager('update_manager')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.manager.update')?>

    <div class="container-fluid">
        <div id="ui-view">
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('manager.update',$account->account_id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group row">
                                                <label class="col-md-2 col-form-label" for="full_name">
                                                    <?=lang_common('name')?>
                                                </label>
                                                <div class="col-md-10">
                                                    <input class="form-control" id="full_name" type="text" value="<?=$account->full_name?>" name="full_name">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 col-form-label" for="account_name">
                                                    <?=lang_common('account_name')?>
                                                </label>
                                                <div class="col-md-10">
                                                    <input class="form-control" id="account_name" type="text" name="account_name" value="<?=$account->account_name?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 col-form-label" for="email">
                                                    <?=lang_common('email')?>
                                                </label>
                                                <div class="col-md-10">
                                                    <input class="form-control" id="email" type="text" name="email" value="<?=$account->email?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 col-form-label" for="account_type_id">
                                                    <?=lang_common('type')?>
                                                </label>
                                                <div class="col-md-10">
                                                    <select class="form-control" name="account_type_id">
                                                        <?php foreach ($types as $type): ?>
                                                            <option value="<?=$type->type_id?>" <?php if($account->account_type_id == $type->type_id) echo 'selected' ?>>
                                                                <?=$type->type_name?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="box box-warning">
                                                <div class="box-body">
                                                    <div class="upload__area-image">
                                                        <span>
                                                             <?php if(isset($account->avatar_dir) && $account->avatar_dir != ''): ?>
                                                                 <img id="imgHandle" src="<?=asset_public($account->avatar_dir)?>">
                                                             <?php else:?>
                                                                 <img id="imgHandle" src="<?=asset_public('images/no_image_available.jpg')?>">
                                                             <?php endif;?>
                                                            <label for="imgAnchorInput">Upload image</label>
                                                        </span>
                                                        <p><small>(Please upload a file of type: jpeg, png, jpg, gif, svg.)</small></p>
                                                    </div>
                                                    <div class="form__upload">
                                                        <div class="form-inline-simple">
                                                            <input type="file" accept="image/*" name="avatar_dir" class="form-control" id="imgAnchorInput" onchange="loadFile(event)">
                                                        </div>
                                                        <script>
                                                            var loadFile = function(event) {
                                                                var output = document.getElementById('imgHandle');
                                                                output.src = URL.createObjectURL(event.target.files[0]);
                                                            };
                                                        </script>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?= $this->endSection() ?>
