<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_orderinfo('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        .date{width: 10%}
        .quote_no{width: 10%}
        .amount{width: 10%}
        .name{width: 15%}
        .email{width: 15%}
        .action{width: 10%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
        a.disabled {
            pointer-events: none;
            cursor: default;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('sale-quote.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
    <script src="<?=asset_admin_js('advanced-forms.js')?>"></script>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.orderinfo')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_orderinfo('list_title')?>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? 'show' : ''?>" id="collapseSearch">
                                <div class="card card-body">

                                    <form action="<?=route_admin('orderinfo.index')?>" method="get">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group row pl-2">
                                                    <label class="col-form-label" for="date-input">
                                                        <?=lang_common('search_from_date')?>
                                                    </label>
                                                    <div class="pl-2 pr-3 pb-4">
                                                        <input class="form-control date-single" value="<?=$from_date?>" type="text" name="from_date" placeholder="date">
                                                    </div>
                                                    <label class="col-form-label" for="date-input">
                                                        <?=lang_common('search_to_date')?>
                                                    </label>
                                                    <div class="pl-2">
                                                        <input class="form-control date-single" value="<?=$to_date?>" id="date-single" type="text" name="to_date" placeholder="date">
                                                    </div>
                                                    <div class="pl-3">
                                                        <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                            <i class="fa fa-search" aria-hidden="true"></i>
                                                            <?=lang_common('search')?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                    <form action="<?=route_admin('orderinfo.index')?>" method="get">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group row pl-2">
                                                    <label class="col-form-label" for="date-input">
                                                        <?=lang_common('item')?> :
                                                    </label>
                                                    <div class="pl-2 pr-3 pb-4">
                                                        <select class="form-control" name="keyword_item">
                                                            <option value="">선택</option>
                                                            <option value="order_code" <?php if($keyword_item == "order_code") echo 'selected' ?>>고객주문번호</option>
                                                            <option value="orderer_name" <?php if($keyword_item == "orderer_name") echo 'selected' ?>>주문자명</option>
                                                            <option value="orderer_email" <?php if($keyword_item == "orderer_email") echo 'selected' ?>>주문자메일(I.D)</option>
                                                            <option value="orderer_phone" <?php if($keyword_item == "orderer_phone") echo 'selected' ?>>연락처</option>
                                                            <option value="orderer_partnumber" <?php if($keyword_item == "orderer_partnumber") echo 'selected' ?>>제품명</option>
                                                        </select>
                                                    </div>
                                                    <label class="col-form-label pl-3" for="date-input">
                                                        <?=lang_common('keyword')?> :
                                                    </label>
                                                    <div class="pl-2 col-md-4">
                                                        <input class="form-control" value="<?="$keyword"?>" type="text" name="keyword">
                                                    </div>
                                                    <div class="pl-3">
                                                        <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                            <i class="fa fa-search" aria-hidden="true"></i>
                                                            <?=lang_common('search')?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                                </div>
                            </div>
                            
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <?php if(count($lists) > 0): ?>
                                    <!-- Header Delete-->
                                    <div class="row">
                                        <div class="col-md-2">
                                            <!--a data-toggle="modal" class="btn btn-danger anchorClick delete"
                                            data-url="<?=route_admin('orderinfo.delete','')?>"
                                            data-url-origin="<?=route_admin('orderinfo.delete','')?>"
                                            data-name="<?=lang_orderinfo('title')?>" href="#deleteModal">
                                            <?=lang_common('delete')?>
                                            </a-->
                                            <a class="btn btn-primary download_excel" href="<?=route_admin('orderinfo.download_excel')?>?keyword_item=<?="$keyword_item"?>&keyword=<?="$keyword"?>&status_code=<?=$status_code?>&from_date=<?=$from_date?>&to_date=<?=$to_date?>">
                                                <i class="fa fa-download" aria-hidden="true"></i>
                                                <?=lang_common('download_excel')?> 
                                            </a>
                                        </div>
                                        <div class="col-md-10">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="text-center checkbox">
                                                <input type="checkbox" name="check_all">
                                            </th>
                                            <th class="amount" >
                                                <?=lang_orderinfo('status')?>

                                                <select name="jump" onchange="location.href=this.value">
                                                        <option value="orderinfo">옵션</option>
                                                    <?php foreach ($orderstatus as $order_status): ?>
                                                        <option value="orderinfo?status_code=<?=$order_status->status_code?>" <?php if($order_status->status_code == $status_code) echo 'selected';?>>
                                                            <?=$order_status->status_info?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </th>
                                            <th class="orderinfo_no">
                                                <?=lang_orderinfo('no')?>
                                            </th>
                                            <th class="amount" >
                                                <?=lang_orderinfo('amount')?>
                                            </th>
                                            <th class="amount" >
                                                <?=lang_orderinfo('method')?>
                                            </th>
                                            <th class="amount" >
                                                발행구분
                                            </th>
                                            <th class="name" >
                                                <?=lang_orderinfo('name')?>
                                            </th>
                                            <!--th class="email" >
                                                <?=lang_common('id')?>
                                            </th-->
                                            <th class="date">
                                                <?=lang_orderinfo('deliverydate')?>
                                            </th>
                                            <th class="date">
                                                등록일시
                                            </th>
                                            <th class="action">
                                            <?=lang_orderinfo('detail')?>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $item): ?>
                                            <tr role="row" class="odd"
                                            <?php
                                            if($item->order_status == "13") {
                                                    echo "style='background-color: #f4df5c;'";
                                                } elseif ($item->order_status == "9" || $item->order_status == "11"){
                                                    echo "style='background-color: #c6c6c6;'";
                                                } elseif ($item->order_status == "10"){
                                                    echo "style='background-color: #8ce0ff;'";
                                                } elseif ($item->order_status == "6"){
                                                    echo "style='background-color: #ffc78f;'";
                                                } elseif ($item->order_status == "7"){
                                                    echo "style='background-color: #69d089;'";
                                                } elseif ($item->order_status == "12"){
                                                    echo "style='background-color: #f46b6b;'";
                                                }
                                            ?>                                          
                                            >
                                                <td class="text-center">
                                                    <input type="checkbox" name="check_box" value="<?=$item->id?>">
                                                </td>
                                                <td class="text-center">
                                                <?php foreach ($orderstatus as $order_status): ?>
                                                    <?php if($order_status->status_code == $item->order_status) echo $order_status->status_info;?>
                                                <?php endforeach; ?>
                                                </td>
                                                <td class="text-center">
                                                    <!--a href="<?=route_admin('orderinfo.detail',$item->info_id)?>" onclick="window.open(this.href, '_blank', 'width=1400, height=900'); return false;">새 창 열기</a-->
                                                    <a onfocus=blur() href="javascript:void(window.open('<?=route_admin('orderinfo.detailwin',$item->info_id)?>','win0','width=1400,height=900,toolbar=no,titlebar=no,menubar=no,location=no'))"><?=$item->order_code?></a>
                                                </td>
                                                <td class="text-right">
                                                    <?=\App\Helpers\NumberHelper::format($item->amount_total, true)?>
                                                </td>
                                                <td class="text-center">
                                                <?php 
                                                if($item->payment_flg == "Card") {
                                                    echo "이니페이 신용카드";
                                                } elseif ($item->payment_flg == "Directbank"){
                                                    echo "이니페이 실시간계좌이체";
                                                } elseif ($item->payment_flg == "vbank"){
                                                    echo "이니페이 가상계좌";
                                                } elseif ($item->payment_flg == "onlynaverpay"){
                                                    echo "이니페이 네이버페이";
                                                } elseif ($item->payment_flg == "onlykakaopay"){
                                                    echo "이니페이 카카오페이";
                                                } elseif ($item->payment_flg == "NPay"){
                                                    echo "네이버N페이";
                                                } elseif ($item->payment_flg == "Tran"){
                                                    echo "무통장입금";
                                                }
                                                ?>
                                                </td>
                                                <td class="text-center">
                                                <?php 
                                                if($item->invoice_type == "1") {
                                                    echo "세금계산서";
                                                } elseif ($item->invoice_type == "2"){
                                                    echo "현금영수증";
                                                }
                                                ?>
                                                </td>
                                                <td class="text-center">
                                                    <?=$item->orderer_name?>
                                                </td>
                                                <!-- td class="text-center">
                                                    <?=$item->orderer_email?>
                                                </td-->
                                                <td class="text-center">
                                                    <?=$item->delivery_date?>
                                                </td>
                                                <td class="text-center">
                                                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd HH:mm')?>
                                                </td>
                                                <td class="text-center">
                                                    <a class="btn btn-success" title="<?=lang_common('detail')?>" href="<?=route_admin('orderinfo.detail',$item->info_id)?>" data-toggle="tooltip" data-original-title="Detail">
                                                        <i class="fa fa-eye" aria-hidden="true"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                        <tr>
                                            <td colspan="7">
                                                <?=lang_common('no_data')?>
                                            </td>
                                        </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-2">
                                            <!--a data-toggle="modal" class="btn btn-danger anchorClick delete"
                                               data-url="<?=route_admin('orderinfo.delete','')?>"
                                               data-url-origin="<?=route_admin('orderinfo.delete','')?>"
                                               data-name="<?=lang_orderinfo('title')?>" href="#deleteModal">
                                                <?=lang_common('delete')?>
                                            </a-->
                                        </div>
                                        <div class="col-md-10 text-right">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>