<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_product('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
<style>
    th{text-align: center}
    .checkbox{width: 5%}
    .product_no{width: 5%}
    .image{width: 10%}
    .part_number{width: 10%}
    .manufacturer{width: 10%}
    .description{width: 10%;word-break: break-all;}
    .break-word{word-break: break-word;}
    .qty{width: 10%}
    .insert_date{width: 10%}
    .update_date{width: 10%}
    .action{width: 5%}
    input[type=checkbox]{
        transform: scale(1.5);
    }
    a.disabled {
        pointer-events: none;
        cursor: default;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
<script src="<?=asset_admin_js('sale-quote.js')?>"></script>
<script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
<script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
<script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
<script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
<script src="<?=asset_admin_js('advanced-forms.js')?>"></script>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.product.list')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_product('list_title')?>
                        <div class="card-header-actions float-right">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('product.show_create')?>">
                                <?=lang_common('create')?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? 'show' : ''?>" id="collapseSearch">
                                    <form action="<?=route_admin('product.index')?>" method="get">
                                        <div class="card card-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group row pl-2">
                                                        <label class="col-form-label pl-3" for="part_number">
                                                        <?=lang_product('list_part_number')?> :
                                                        </label>
                                                        <div class="pl-2 col-md-4">
                                                            <input class="form-control" value="<?=$part_number?>" type="text" name="part_number">
                                                        </div>
                                                        <div class="pl-3">
                                                            <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                                <i class="fa fa-search" aria-hidden="true"></i>
                                                                <?=lang_common('search')?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <?php if(count($lists) > 0): ?>
                                    <!-- Header Delete-->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <a data-toggle="modal" class="btn btn-danger anchorClick delete"
                                               data-url="<?=route_admin('product.delete','')?>"
                                               data-url-origin="<?=route_admin('product.delete','')?>"
                                               data-name="<?=lang_product('list_title')?>" href="#deleteModal">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                <?=lang_common('delete')?>
                                            </a>
                                            <a data-toggle="modal" class="btn btn-danger anchorClick delete-all"
                                               data-title="<?=lang_common('confirm_are_you_sure')?>"
                                               data-url="<?=route_admin('product.delete_all')?>"
                                               data-name="<?=lang_product('list_delete_all_title')?>" href="#deleteModal">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                <?=lang_common('delete_all')?>
                                            </a>
                                            <a class="btn btn-primary download_excel" href="<?=route_admin('product.download_excel')?>">
                                                <i class="fa fa-download" aria-hidden="true"></i>
                                                <?=lang_common('download_excel')?>
                                            </a>
                                        </div>
                                        <div class="col-md-8">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="text-center checkbox">
                                                <input type="checkbox" name="check_all">
                                            </th>
                                            <th class="product_no">
                                                <?=lang_product('list_product_no')?>
                                            </th>
                                            <th class="image">
                                                <?=lang_product('list_image')?>
                                            </th>
                                            <th class="part_number" >
                                                <?=lang_product('list_part_number')?>
                                            </th>
                                            <th class="manufacturer" >
                                                <?=lang_product('list_manufacturer')?>
                                            </th>
                                            <th class="description" >
                                                <?=lang_product('list_description')?>
                                            </th>
                                            <th class="qty" >
                                                <?=lang_product('list_qty')?>
                                            </th>
                                            <th class="insert_date" >
                                                <?=lang_common('insert_date')?>
                                            </th>
                                            <th class="update_date" >
                                                <?=lang_common('update_date')?>
                                            </th>
                                            <th class="action">
                                                <?=lang_common('action')?>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $product): ?>
                                            <tr role="row" class="odd">
                                                <td class="text-center">
                                                    <input type="checkbox" name="check_box" value="<?=$product->product_id?>">
                                                </td>
                                                <td class="text-right">
                                                    <?=$product->product_id?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if(isset($product->image_dir) && $product->image_dir != ''): ?>

                                                    <?php if(isset($product->api_flg) && $product->api_flg == '1'): ?>
                                                        <img src="<?=$product->image_dir?>" width="50"/>
                                                    <?php else : ?>
                                                        <img src="<?=asset_public($product->image_dir)?>" width="50"/>
                                                    <?php endif; ?>

                                                    <?php else : ?>
                                                        <img src="<?=asset_public('images/no_image_available.jpg')?>" width="50"/>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-right">
                                                    <?=$product->part_number?>
                                                </td>
                                                <td class="">
                                                    <?=$product->name?>
                                                </td>
                                                <td class="break-word">
                                                    <?=show_text_dot($product->description,20)?>
                                                </td>
                                                <td class="text-right">
                                                    <?=\App\Helpers\NumberHelper::format($product->qty, true)?>
                                                </td>
                                                <td class="text-center">
                                                    <?=\App\Helpers\DateHelper::toTimeString($product->created_at)?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if(\App\Helpers\DateHelper::toTimeString($product->created_at) != App\Helpers\DateHelper::toTimeString($product->updated_at)):?>
                                                        <?=\App\Helpers\DateHelper::toTimeString($product->updated_at)?>
                                                    <?php endif;?>
                                                </td>
                                                <td class="text-center">
                                                    <a class="btn btn-info" title="<?=lang_common('detail')?>" href="<?=route_admin('product.show_update',$product->product_id)?>" data-toggle="tooltip" data-original-title="Detail">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                            <tr>
                                                <td colspan="10">
                                                    <?=lang_common('no_data')?>
                                                </td>
                                            </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <a data-toggle="modal" class="btn btn-danger anchorClick delete"
                                               data-url="<?=route_admin('product.delete','')?>"
                                               data-url-origin="<?=route_admin('product.delete','')?>"
                                               data-name="<?=lang_product('list_title')?>" href="#deleteModal">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                <?=lang_common('delete')?>
                                            </a>
                                            <a data-toggle="modal" class="btn btn-danger anchorClick delete-all"
                                               data-url="<?=route_admin('product.delete_all')?>"
                                               data-name="<?=lang_product('list_delete_all_title')?>" href="#deleteModal">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                <?=lang_common('delete_all')?>
                                            </a>
                                            <a class="btn btn-primary download_excel" href="<?=route_admin('product.download_excel')?>">
                                                <i class="fa fa-download" aria-hidden="true"></i>
                                                <?=lang_common('download_excel')?>
                                            </a>
                                        </div>
                                        <div class="col-md-8">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
