<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_product('list_update')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">

    <style>
        .ck-editor__editable[role="textbox"] {
          min-height: 400px;
        }
      
        .ck-content .image {
          max-width: 80%;
          margin: 20px auto;
        }
    </style>

<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('form.input.number.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            bsCustomFileInput.init();
        });
    </script>
    <?php if(isset($validation)): ?>
        <script>
            $("#form").validate({
                'errorClass' : 'is-invalid',
                <?=$validation['rules']?>,
                <?=$validation['messages']?>
            });
        </script>
    <?php endif?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?=$breadcrumb->render('admin.product.update')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <i class="icon-note"></i> <?=lang_product('list_update')?>
                                    <div class="card-header-actions float-right">
                                        <a class="btn btn-block btn-secondary" href="<?=route_admin('product.index')?>">
                                            <?=lang_common('back')?>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-2 col-form-label" for="product_code">
                                                    <?=lang_product('list_product_code')?>
                                                </label>
                                                <div class="col-md-10">
                                                    <input class="form-control" id="product_code" type="text"  disabled value="<?=old_value('product_code', $product->product_code)?>">
                                                    
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-2 col-form-label" for="product_code">
                                                API Update Date
                                                </label>
                                                <div class="col-md-10">
                                                    <?=$product->api_updated_at?>   
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                        <form method="post" action="<?=route_admin('product.upshowwindow',$product->product_id)?>" id="form">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="product_code">
                                                    메인노출
                                                </label>
                                                <div class="col-md-7">
                                                    <select name="showwindow_mode" id="showwindow_mode" class="form-control input-lg">
                                                    <option value="new" >신상품</option>
                                                    <option value="best" >베스트상품</option>
                                                    <option value="recom" >추천상품</option>
                                                    <option value="brand" >브랜드상품</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                    <button class="btn btn-secondary" type="submit">등록</button>
                                                </div>
                                            </div>
                                        </form>
                                        </div>

                                        <div class="col-md-4">
                                        <form method="post" action="<?=route_admin('product.update',$product->product_id)?>" enctype="multipart/form-data" id="form">
                                        <input type="hidden" name="product_code" value="<?=$product->product_code?>">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="part_category">
                                                    <?=lang_product('list_part_category1')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <select name="part_category" id="categorylevel1" class="form-control input-lg">
                                                        <option value="">Select Categorylevel1</option>
                                                        <?php
                                                        foreach($categorylevel1 as $row)
                                                        {
                                                            echo '<option value="'.$row["categorylevel1_code"].'"';

                                                            if($row["categorylevel1_code"] == $product->part_category) {
                                                                echo 'selected';
                                                                }
                                                            
                                                            echo '>'.$row["categorylevel1_name"].'</option>';
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                <a class="btn btn-secondary" href="<?=route_admin('categorylevel.categorylevel1create')?>">추가</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">  
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="part_category2">
                                                    <?=lang_product('list_part_category2')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <select name="part_category2" id="categorylevel2" class="form-control input-lg">
                                                        <?php
                                                        foreach($categorylevel2 as $row)
                                                        {
                                                            if($row["categorylevel2_code"] == $product->part_category2) {
                                                                echo '<option value="'.$row["categorylevel2_code"].'" selected>'.$row["categorylevel2_name"].'</option>';
                                                            }
                                                        }
                                                        ?>
                                                        <option value="">Select Category2</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                    <a class="btn btn-secondary" href="<?=route_admin('categorylevel.categorylevel2create')?>">추가</a>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="maker_seq">
                                                    <?=lang_product('list_manufacturer')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <select class="form-control" id="maker_seq" name="maker_seq">
                                                        <?php foreach ($manufacturers as $manufacturer): ?>
                                                            <option value="<?=$manufacturer->maker_seq?>" <?php if($manufacturer->maker_seq == $product->maker_seq) echo 'selected';?> ><?=$manufacturer->name?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                <a class="btn btn-secondary" href="<?=route_admin('manufacturer.create')?>">추가</a>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-4">                                        
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="display_set">
                                                    <?=lang_product('list_display_set')?>
                                                </label>
                                                <div class="col-md-7">

                                                <div class="form-inline">
                                                    <div class="form-check mr-5">
                                                    <input <?php if($product->newproduct_chk == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="newproduct_chk" value="1" id="newproduct_chk">
                                                    <label class="form-check-label" for="newproduct_chk"><?=lang_displayinfo('ID_newproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                    <input <?php if($product->bestproduct_chk == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="bestproduct_chk" value="1" id="bestproduct_chk">
                                                    <label class="form-check-label" for="bestproduct_chk"><?=lang_displayinfo('ID_bestproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                    <input <?php if($product->recomproduct_chk == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="recomproduct_chk" value="1" id="recomproduct_chk">
                                                    <label class="form-check-label" for="recomproduct_chk"><?=lang_displayinfo('ID_recomproduct')?></label>
                                                    </div>
                                                    <div class="form-check mr-5">
                                                    <input <?php if($product->brandproduct_chk == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="brandproduct_chk" value="1" id="brandproduct_chk">
                                                    <label class="form-check-label" for="brandproduct_chk"><?=lang_displayinfo('ID_brandproduct')?></label>
                                                    </div>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="event_set">
                                                    <?=lang_product('list_event_set')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <select class="form-control" id="event_set" name="event_set">
                                                            <option value="">이벤트 없음.</option>
                                                        <?php foreach ($eventinfos as $eventinfo): ?>
                                                            <option value="<?=$eventinfo->id?>" <?php if($eventinfo->id == $product->event_set) echo 'selected';?>>
                                                                <?=$eventinfo->event_title?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="event_set">
                                                    네이버쇼핑
                                                </label>
                                                <div class="col-md-2">
                                                    <div class="form-check mr-5">
                                                        <input <?php if($product->navershop_chk == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="navershop_chk" value="1" id="navershop_chk">
                                                        <label class="form-check-label" for="navershop_chk">노출</label>
                                                        <input type="hidden" name="navershop_status_before" value="<?=$product->navershop_status?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-5">
                                                    <?php 
                                                        echo '현재상태 : ';
                                                        if ($product->navershop_status == "I") {echo 'I (신규 상품)';}
                                                        elseif ($product->navershop_status == "U") {echo 'U (업데이트 상품)';}
                                                        elseif ($product->navershop_status == "D") {echo 'D (품절 상품)';}
                                                    ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">                                    
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="part_number">
                                                    <?=lang_product('list_part_number')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-11">
                                                    <input class="form-control" id="part_number" type="text" name="part_number" value="<?=old_value('part_number', $product->part_number)?>">
                                                </div>
                                                    <input type="hidden" name="old_part_number" value="<?=$product->part_number?>">
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="part_number_sequence">
                                                    <?=lang_product('list_part_number_sequence')?>
                                                </label>
                                                <div class="col-md-11">
                                                    <input class="form-control" id="part_number_sequence" type="text" disabled value="<?=old_value('part_number_sequence', $product->part_number_sequence)?>">
                                                </div>

                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="search_word">
                                                    <?=lang_product('list_search_word')?>
                                                </label>
                                                <div class="col-md-11">
                                                    <textarea class="form-control" id="search_word" name="search_word" rows="2"><?=old_value('search_word', $product->search_word)?></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="brief_description">
                                                    <?=lang_product('list_brief_description')?>
                                                </label>
                                                <div class="col-md-11">
                                                    <textarea class="form-control" id="brief_description" name="brief_description" rows="2"><?=old_value('brief_description', $product->brief_description)?></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="replacement_items">
                                                    <?=lang_product('list_replacement_items')?>
                                                </label>
                                                <div class="col-md-11">
                                                    <input class="form-control" id="replacement_items" type="text" name="replacement_items" value="<?=old_value('replacement_items', $product->replacement_items)?>">
                                                </div>
                                                    <input type="hidden" name="old_replacement_items" value="<?=$product->replacement_items?>">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="qty">
                                                    <?=lang_product('list_qty')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control text-right" id="qty" type="text" name="qty" value="<?=old_value('qty', $product->qty)?>" >
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="packing_code">
                                                    <?=lang_product('list_packing_code')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <select class="form-control" id="packing_code" name="packing_code">
                                                        <option value="" <?php if(!$product->packing_code) echo 'selected';?>>포장단위 선택</option>
                                                        <?php foreach ($packagingunits as $packagingunit_code): ?>
                                                            <option value="<?=$packagingunit_code->packing_code?>"  <?php if($product->packing_code == $packagingunit_code->packing_code) echo 'selected';?>>
                                                            <?=$packagingunit_code->packing_code?> (<?=$packagingunit_code->supplier_code?> : <?=$packagingunit_code->packing_name?>)
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="wearing_price">
                                                    <?=lang_product('list_wearing_price')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control text-right" id="wearing_price" type="text" name="wearing_price" value="<?=old_value('wearing_price', $product->wearing_price)?>">
                                                </div>
                                            </div>
                                        </div>   

                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="price">
                                                    <?=lang_product('list_price')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control text-right" id="price" type="text" name="price" value="<?=old_value('price', $product->price)?>">
                                                </div>
                                            </div>
                                        </div>   

                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="margin_rate">
                                                    <?=lang_product('list_margin_rate')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control text-right" id="margin_rate" type="text" name="margin_rate" value="<?=old_value('margin_rate', $product->margin_rate)?>" disabled>
                                                </div>
                                            </div>
                                        </div>   
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="discount_rate">
                                                    <?=lang_product('list_discount_rate')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control text-right" id="discount_rate" type="text" name="discount_rate" value="<?=old_value('discount_rate', $product->discount_rate)?>">
                                                </div>
                                            </div>
                                        </div>   


                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="date_code">
                                                    <?=lang_product('list_date_code')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control" id="date_code" type="text" name="date_code" value="<?=old_value('date_code', $product->date_code)?>">
                                                </div>
                                            </div>
                                        </div>   
                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="leadtime">
                                                    <?=lang_product('list_leadtime')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <select class="form-control" name="leadtime">
                                                        <?php foreach ($leadtimecategorys as $leadtime): ?>
                                                                <option value="<?=$leadtime->leadtime_id?>" <?php if($leadtime->leadtime_id == $product->leadtime) echo 'selected';?>>
                                                                    <?=$leadtime->leadtime_info?>
                                                                </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="moq">
                                                    <?=lang_product('list_moq')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control text-right" id="moq" type="text" name="moq" value="<?=old_value('moq', $product->moq)?>">
                                                </div>
                                            </div>
                                        </div>   
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="mpq">
                                                    <?=lang_product('list_mpq')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control text-right" id="mpq" type="text" name="mpq" value="<?=old_value('mpq', $product->mpq)?>">
                                                </div>
                                            </div>
                                        </div>   
                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="stock_location">
                                                    <?=lang_product('list_stock_location')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <select class="form-control" name="stock_location">
                                                        <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                                            <option value="<?=$stock_location->location_id?>" <?php if($stock_location->location_id == $product->stock_location) echo 'selected';?>>
                                                                <?=$stock_location->location_info?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>   

                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-4 col-form-label" for="taxable">
                                                    <?=lang_product('list_taxable')?>
                                                </label>
                                                <div class="col-md-3">
                                                    <input class="form-check-input" name="taxable" type="radio" value="0" id="taxable" <?php if($product->taxable == 0) echo 'checked' ?>> 과세
                                                </div>
                                                <div class="col-md-3">
                                                    <input class="form-check-input" name="taxable" type="radio" value="1" id="taxable" <?php if($product->taxable == 1) echo 'checked' ?>> 비과세
                                                </div>
                                            </div>
                                        </div>   
                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-4 col-form-label" for="api_flg">
                                                    <?=lang_product('list_api_flg')?>
                                                </label>
                                                <div class="col-md-3">
                                                    <input class="form-check-input" name="api_flg" type="radio" value="0" id="api_flg" <?php if($product->api_flg == 0) echo 'checked' ?>> 연결하지 않음.
                                                </div>
                                                <div class="col-md-3">
                                                    <input class="form-check-input" name="api_flg" type="radio" value="1" id="api_flg" <?php if($product->api_flg == 1) echo 'checked' ?>> 연결함.
                                                </div>
                                            </div>
                                        </div>   
                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="api_code">
                                                    <?=lang_product('list_api_code')?><span class="text-danger">(*)</span>
                                                </label>
                                                <div class="col-md-7">
                                                    <select class="form-control" name="api_code">
                                                        <?php foreach ($apiinfos as $apiinfo): ?>
                                                                <option value="<?=$apiinfo->api_code?>" <?php if($apiinfo->api_code == $product->api_code) echo 'selected';?>>
                                                                    <?=$apiinfo->provider_name?>
                                                                </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">                                            
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="product_api_id">
                                                    <?=lang_product('list_product_api_id')?>
                                                </label>
                                                <div class="col-md-7">
                                                    <input class="form-control" id="product_api_id" type="text" name="product_api_id" value="<?=old_value('product_api_id', $product->product_api_id)?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="api_flg">

                                                </label>
                                                <div class="col-md-8 box box-warning">
                                                    <div class="box-body">
                                                        <div class="upload__area-image">
                                                    <span>
                                                        <?php if(isset($product->image_dir) && $product->image_dir != ''): ?>

                                                        <?php 
                                                            $image_dir_is = substr($product->image_dir, 0, 4);   
                                                            if ($image_dir_is == "http") {
                                                        ?>
                                                            <img id="imgHandle" src="<?=$product->image_dir?>"/>
                                                        <?php } else { ?>
                                                            <img id="imgHandle" src="<?=asset_public($product->image_dir)?>"/>
                                                        <?php } ?>

                                                        <?php else:?>
                                                            <img id="imgHandle" src="<?=asset_public('images/no_image_available.jpg')?>">
                                                        <?php endif;?>
                                                        <label for="imgAnchorInput">Upload image</label>
                                                    </span>
                                                            <p>
                                                                <small>(Please upload a file of type: jpeg, png, jpg, gif, svg.)</small><br/>
                                                                <small class="color-red hide" id="message_image">(Please upload a file of type: jpeg, png, jpg, gif, svg.)</small>
                                                            </p>
                                                        </div>
                                                        <div class="form__upload">
                                                            <div class="form-inline-simple">
                                                                <input type="file" name="image_file" class="form-control" accept="image/*" maxsizeMb="1" id="imgAnchorInput" onchange="loadFile(event)">
                                                            </div>
                                                            <script>
                                                                var loadFile = function(event) {
                                                                    var output = document.getElementById('imgHandle');
                                                                    var file = event.target.files[0];
                                                                    var size = file.size;
                                                                    var exactSize = size/1024/1024;
                                                                    // var fSExt = new Array('Bytes', 'KB', 'MB', 'GB'),
                                                                    //     i=0;while(size>900){size/=1000;i++;}
                                                                    // var exactSize = (Math.round(size*100)/100)+' '+fSExt[i];
                                                                    console.log(exactSize);

                                                                    if(exactSize >= 2){
                                                                        var message = "File size must not exceed 2 MB";
                                                                        document.getElementById('message_image').innerHTML = message;
                                                                        event.target.value = '';
                                                                        $('#message_image').removeClass('hide');
                                                                    }else{
                                                                        $('#message_image').addClass('hide');
                                                                        output.src = URL.createObjectURL(file);
                                                                    }
                                                                };
                                                            </script>
                                                        </div>
                                                    </div>
                                                </div>

                                                <label class="col-md-1 col-form-label" for="api_flg">

                                                </label>
                                                
                                            </div>
                                        </div>

                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="tariff_rate">
                                                <?=lang_product('list_tariff_rate')?>
                                            </label>
                                            <div class="col-md-9">
                                                <input class="form-control" id="tariff_rate" type="text" name="tariff_rate" value="<?=old_value('tariff_rate', $product->tariff_rate)?>">
                                            </div>
                                        </div>
                                        
                                        <div class="form-group row">
                                        <label class="col-md-2 col-form-label">
                                            <?=lang_product('list_image2_file')?>
                                        </label>
                                        <div class="col-md-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="product_image1" name="product_image1" maxsizeMb="10" accept="image/*">
                                                    <label class="custom-file-label" for="product_image1"> <?=show_text_dot($productdetail->product_image1,200)?></label>
                                                </div>
                                            </div>
                                        </div>
                                        </div>
                                        <div class="form-group row">
                                        <label class="col-md-2 col-form-label">
                                            <?=lang_product('list_image3_file')?>
                                        </label>
                                        <div class="col-md-9">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="product_image2" name="product_image2" maxsizeMb="10" accept="image/*">
                                                    <label class="custom-file-label" for="product_image2"> <?=show_text_dot($productdetail->product_image2,200)?></label>
                                                </div>
                                            </div>
                                        </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label">
                                                <?=lang_product('list_pdf_file')?>
                                            </label>
                                            <div class="col-md-9">
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" id="product_pdf" name="product_pdf" maxsizeMb="10" accept=".pdf,application/pdf">
                                                        <label class="custom-file-label" for="product_pdf"> <?=show_text_dot($productdetail->product_pdf,200)?></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label" for="situation">
                                                품절처리
                                            </label>
                                            <div class="col-md-8">
                                                <input <?php if($product->situation == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="situation" value="1" id="situation">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="delivery_code">
                                                <?=lang_product('list_delivery_code')?>
                                            </label>
                                            <div class="col-md-8">
                                                <select class="form-control" name="delivery_code">
                                                    <?php foreach ($deliverycodes as $delivery_code): ?>
                                                        <option value="<?=$delivery_code->id?>" 
                                                        <?php 
                                                        if($delivery_code->id == $product->delivery_code) {
                                                            echo '<option value="'.$delivery_code->id.'" selected>';
                                                        } else {
                                                            echo '<option value="'.$delivery_code->id.'">';
                                                        }
                                                        ?>
                                                        <?=$delivery_code->title?> (<?=\App\Helpers\NumberHelper::format($delivery_code->price)?> <?=lang_sale('price_unit')?>)
                                                        </option>
                                                    <?php endforeach; ?>
                                                </select>
                                                </div>
                                            <div class="col-md-2">
                                            <a class="btn btn-secondary" href="<?=route_admin('deliverycodes.create')?>">추가</a>
                                            </div>
                                        </div> 
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label" for="exposure">
                                                상품미노출
                                            </label>
                                            <div class="col-md-8">
                                                <input <?php if($product->exposure == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="exposure" value="1" id="exposure">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">                                                                                                                         
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="description">
                                                    <?=lang_product('list_description')?>
                                                </label>
                                                <div class="col-md-11">
                                                    <textarea class="form-control" id="description" name="product_doc" rows="9"><?php echo htmlspecialchars_decode($productdetail->product_doc)?></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-1 col-form-label" for="product_related">
                                                    <?=lang_product('list_product_related')?>
                                                </label>
                                                <div class="col-md-11">
                                                    <input class="form-control" id="product_related" type="text" name="product_related" value="<?=old_value('product_related', $product->product_related)?>">
                                                </div>
                                            </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <table class="table table-condensed">
                                            <thead>
                                            <tr>
                                                <th><?=lang_product('list_selling_price')?></th>
                                                <th>판매기준가<span class="text-danger">(*)</span></th>
                                                <th>판매기준가 단위<span class="text-danger">(*)</span></th>
                                                <th><?=lang_product('list_unit_mini_quantity')?><span class="text-danger">(*)</span></th>
                                                <!--th><?=lang_product('list_unit_max_quantity')?></th-->
                                            </tr>
                                            </thead>

                                            <tbody id="tbodyItems3">
                                            <?php $datakRow = 6;?>
                                            <?php for($k=1;$k <= $datakRow;$k++):?>
                                                <?php
                                                $selling_price = 'selling_price'.$k;
                                                $prices_price = 'prices_price'.$k;
                                                $prices_currency = 'prices_currency'.$k;
                                                $margin_rate = 'margin_rate'.$k;
                                                $unit_mini_quantity = 'unit_mini_quantity'.$k;
                                                $unit_max_quantity = 'unit_max_quantity'.$k;
                                                ?>
                                                <tr class="trPartNo">
                                                    <td>
                                                        <input class="form-control selling_price text-right" id="<?=$selling_price?>" type="text" name="<?=$selling_price?>" disabled value="<?=old_value($selling_price, $product->$selling_price)?>">
                                                    </td>
                                                    <td>
                                                        <input class="form-control prices_price text-right" id="<?=$prices_price?>" type="text" name="<?=$prices_price?>" value="<?=old_value($prices_price, $product->$prices_price)?>">
                                                    </td>
                                                    <td>
                                                        <select class="form-control" name="<?=$prices_currency?>">
                                                            <?php foreach ($exchangecounrty as $exchange_counrty): ?>
                                                                <option value="<?=$exchange_counrty->counrty_code?>"  <?php if($exchange_counrty->counrty_code == $product->$prices_currency) echo 'selected';?>>
                                                                    <?=$exchange_counrty->counrty_code?> (<?=$exchange_counrty->counrty_kor_name?>)
                                                                </option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input class="form-control unit_mini_quantity text-right" id="<?=$unit_mini_quantity?>" type="text" name="<?=$unit_mini_quantity?>" value="<?=old_value($unit_mini_quantity, $product->$unit_mini_quantity)?>">
                                                    </td>
                                                    <!--td>
                                                        <input class="form-control unit_max_quantity text-right" id="<?=$unit_max_quantity?>" type="text" name="<?=$unit_max_quantity?>" value="<?=old_value($unit_max_quantity, $product->$unit_max_quantity)?>">
                                                    </td-->
                                                </tr>
                                            <?php endfor;?>
                                                </tbody>
                                        </table>
                                    </div>
                                    
                                </div>
                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                </div>
                            </div>
                        </form>

<!---------------------------->

<script>

$(document).ready(function(){

    $('#categorylevel1').change(function(){

        var categorylevel1_code = $('#categorylevel1').val();

        var action = 'get_categorylevel2';

        if(categorylevel1_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/CategorylevelSelect/action'); ?>",
                method:"POST",
                data:{categorylevel1_code:categorylevel1_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel2</option>';

                    for(var count = 0; count < data.length; count++)
                    {

                        html += '<option value="'+data[count].categorylevel2_code+'">'+data[count].categorylevel2_name+'</option>';

                    }

                    $('#categorylevel2').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel2').val('');
        }
        $('#categorylevel3').val('');
    });

    $('#categorylevel2').change(function(){

        var categorylevel2_code = $('#categorylevel2').val();

        var action = 'get_categorylevel3';

        if(categorylevel2_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/CategorylevelSelect/action'); ?>",
                method:"POST",
                data:{categorylevel2_code:categorylevel2_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel3</option>';

                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].categorylevel3_code+'">'+data[count].categorylevel3_name+'</option>';
                    }

                    $('#categorylevel3').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel3').val('');
        }

    });

});

</script>

<!-------------------------------->


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?=asset_js('ckeditor.js')?>"></script>
<script src="<?=asset_js('ko.js')?>"></script>

  <script>
    CKEDITOR.ClassicEditor.create(document.getElementById("description"), {
      language: "ko",
      toolbar: {
        items: [
          //'exportPDF', 'exportWord', '|',
          'findAndReplace', 'selectAll', '|',
          'heading', '|',
          'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
          'bulletedList', 'numberedList', 'todoList', '|',
          'outdent', 'indent', '|',
          'undo', 'redo', '|',
          'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
          'alignment', '|',
          'link', 'insertImage', 'blockQuote', 'insertTable', 
          //'mediaEmbed', 
          'codeBlock', 'htmlEmbed', '|','specialCharacters', 'horizontalLine', 'pageBreak', '|',
          // 'textPartLanguage', '|',
          'sourceEditing'
        ],
        shouldNotGroupWhenFull: true
      },
      list: {
        properties: {
          styles: true,
          startIndex: true,
          reversed: true
        }
      },
      heading: {
        options: [
          { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
          { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
          { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
          { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' },
          { model: 'heading4', view: 'h4', title: 'Heading 4', class: 'ck-heading_heading4' },
          { model: 'heading5', view: 'h5', title: 'Heading 5', class: 'ck-heading_heading5' },
          { model: 'heading6', view: 'h6', title: 'Heading 6', class: 'ck-heading_heading6' }
        ]
      },
      placeholder: '내용을 입력하세요!',
      fontFamily: {
        options: [
          'default',
          'Arial, Helvetica, sans-serif',
          'Courier New, Courier, monospace',
          'Georgia, serif',
          'Lucida Sans Unicode, Lucida Grande, sans-serif',
          'Tahoma, Geneva, sans-serif',
          'Times New Roman, Times, serif',
          'Trebuchet MS, Helvetica, sans-serif',
          'Verdana, Geneva, sans-serif'
        ],
        supportAllValues: true
      },
      fontSize: {
        options: [10, 12, 14, 'default', 18, 20, 22],
        supportAllValues: true
      },
      htmlSupport: {
        allow: [
          {
            name: /.*/,
            attributes: true,
            classes: true,
            styles: true
          }
        ]
      },
      htmlEmbed: {
        showPreviews: true
      },
      link: {
        decorators: {
          addTargetToExternalLinks: true,
          defaultProtocol: 'https://',
          toggleDownloadable: {
            mode: 'manual',
            label: 'Downloadable',
            attributes: {
              download: 'file'
            }
          }
        }
      },
      mention: {
        feeds: [
          {
            marker: '@',
            feed: [
              '@apple', '@bears', '@brownie', '@cake', '@cake', '@candy', '@canes', '@chocolate', '@cookie', '@cotton', '@cream',
              '@cupcake', '@danish', '@donut', '@dragée', '@fruitcake', '@gingerbread', '@gummi', '@ice', '@jelly-o',
              '@liquorice', '@macaroon', '@marzipan', '@oat', '@pie', '@plum', '@pudding', '@sesame', '@snaps', '@soufflé',
              '@sugar', '@sweet', '@topping', '@wafer' 
            ],
            minimumCharacters: 1
          }
        ]
      },
      removePlugins: [
        'ExportPdf',
        'ExportWord',
        'CKBox',
        'CKFinder',
        'EasyImage',
        'RealTimeCollaborativeComments',
        'RealTimeCollaborativeTrackChanges',
        'RealTimeCollaborativeRevisionHistory',
        'PresenceList',
        'Comments',
        'TrackChanges',
        'TrackChangesData',
        'RevisionHistory',
        'Pagination',
        'WProofreader',
        'MathType'
      ]
    });
  </script>

<?= $this->endSection() ?>
