<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_product('loop_upload_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
<style>
    th{text-align: center}
    .checkbox{width: 5%}
    .date{width: 10%}
    .quote_no{width: 10%}
    .amount{width: 10%}
    .name{width: 20%}
    .action{width: 10%}
    input[type=checkbox]{
        transform: scale(1.5);
    }
    a.disabled {
        pointer-events: none;
        cursor: default;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            bsCustomFileInput.init();
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.product.loop_upload')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_product('loop_upload_title')?>
                    </div>
                    <div class="card-body">
                        <!--div class="card card-body">
                            <div class="row col-md-12 text-md-center">
                                <span style="color: blue;padding-top: 1px;" class="pr-1"><i class="fas fa-cloud-upload-alt"></i></span>
                                <h4><?=lang_product('loop_upload_process')?></h4>
                            </div>
                            <div class="row col-md-12">
                                1 . <?=lang_product('loop_upload_step_one')?>
                            </div>
                            <div class="row col-md-12">
                                2 . <?=lang_product('loop_upload_step_two')?>
                            </div>
                            <div class="row col-md-12">
                                3 . <?=lang_product('loop_upload_step_three')?>
                            </div>
                            <div class="row col-md-12">
                                4 . <?=lang_product('loop_upload_step_four')?>
                            </div>
                            <div class="row col-md-12">
                                5 . <?=lang_product('loop_upload_step_five')?>
                            </div>
                            <div class="row col-md-12 pl-4">
                                <a href="<?=route_admin('product.loop_upload.download_template')?>">
                                    [ <i class="fas fa-download"></i> <?=lang_product('loop_upload_sample_file_download')?> ]
                                </a>
                            </div>
                        </div-->


                        <form method="post" id="form" enctype="multipart/form-data" action="<?=route_admin('product.loop_upload.import')?>">
                            <!--div class="card pt-2">
                                <div class="col-md-12">
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label pl-4" for="text-input">
                                            <?=lang_product('loop_upload_upload_type')?>
                                        </label>
                                        <div class="col-md-10">
                                            <div class="form-check">
                                                <input class="form-check-input" id="type_overwrite" type="radio" value="<?=EXCEL_UPLOAD_TYPE_OVERWRITE?>" name="upload_type">
                                                <label class="form-check-label" for="type_overwrite">
                                                    <?=lang_product('loop_upload_type_overwrite')?>
                                                    : <?=lang_product('loop_upload_type_overwrite_note')?>
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" id="type_adding" checked="checked" type="radio" value="<?=EXCEL_UPLOAD_TYPE_ADDING?>" name="upload_type">
                                                <label class="form-check-label" for="type_adding">
                                                    <?=lang_product('loop_upload_type_adding')?>
                                                    : <?=lang_product('loop_upload_type_adding_note')?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-2 col-form-label pl-4" for="text-input">
                                            <?=lang_product('loop_upload_file_upload')?>
                                        </label>
                                        <div class="col-md-10">
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="file_upload" name="file_upload" maxsizeMb="10" accept=".xls,.xlsx,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-loop">
                                                    <label class="custom-file-label" for="file_upload">Choose file</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div-->
                            <div class="card-footer text-center">
                                <input type="submit" class="btn btn-primary btn-lg" value="<?=lang_product('loop_upload_button_upload')?>"/>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
