<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_sale('quote_detail')?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?=$breadcrumb->render('admin.refundinfo.detail')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card ">
                            <div class="card-header">
                                <i class="fas fa-edit"></i> <?=lang_sale('quote_detail')?>
                                <div class="card-header-actions float-right">
                                    <a class="btn btn-block btn-secondary" href="<?=route_admin('refundinfo.index')?>">
                                        <?=lang_common('back')?>
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">

                            <div class="card card-secondary">
                                    <div class="card-header font-weight-bold">
                                        <?=lang_sale('quote_detail_item')?>
                                    </div>
                                    <div class="card-body" style="padding: 10px">

                            <?php if (!$lists) :?>

                        <p class="mb-0"> <?=lang_cart('toitem_msg1')?></p><p><a href="<?=route_guest('home')?>"><?=lang_cart('toitem_msg2')?></a><?=lang_cart('toitem_msg3')?></p>

                <?php else: ?>

                    <table class="table table-responsive-sm">
                    <thead>
                    <tr>
                        <th>제품사진</th>
                        <th>주문상품</th>
                        <th>단가</th>
                        <th>주문수량</th>
                        <th>공급가액(VAT)</th>
                        <th>환불액</th>
                        <!--th>분류</th-->
                </tr>
                    </thead>
                    <tbody>

                <?php $i = 1; ?>

                <?php foreach($lists as $item){?>
                    <tr>
                        <td>
                        <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item->nowinfo['image_dir']?>" width="200"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item->nowinfo['image_dir'])?>" width="200"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>" width="200"/>
                        <?php endif; ?>
                        </td>
                        <td>
                            <div class="flex_sb">
                                <div>
                                    <p class="subWrap01ContsName02_sub01">
                                    <?php echo $item->manufacturer_name;?>
                                    </p>
                                    <p class="subWrap01ContsName02_sub02">
                                    <?php echo $item->part_number;?>
                                    </p>
                                </div>

                                <div class="subWrap01subTag01">
                                    <span>
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item->stock_location) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                    </span>
                                </div>
                            </div>
                            <p class="subWrap01ContsName02_sub03">
                            <?=$item->nowinfo['product_code']?> / <?=$item->nowinfo['part_number_sequence']?>
                            </p>
                            <input type="hidden" name="product_code<?=$i?>" value="<?=$item->nowinfo['product_code']?>"/>
                            <div class="subWrap01ContsName02_sub04">
                                <p>
                                <?=$item->nowinfo['brief_description']?><br>
                                </p>
                            </div>
                        </td>
                        <td>
                            <span class="refund_ListPrice"><?=number_format($item->price)?>원</span>
                        </td>
                        <td>
                            <?php echo $item->qty;?>
                        </td>
                        <td>
                            <span class="refund_ListPrice"><?=number_format($item->supply_price)?>원 (<?=number_format($item->vat)?>원)</span>
                        </td>
                        <td>
                            <span class="refund_ListPrice"><?=number_format($item->amount)?>원</span>
                        </td>
                        <!--td>
                        <?php 
                        if($item->refund_type =="1") {
                            echo "교환";
                        } elseif ($item->refund_type =="2"){
                            echo "반품";
                        } elseif ($item->refund_type =="3"){
                            echo "환불";
                        } elseif ($item->refund_type =="0"){
                            echo " ";
                        }
                        ?>
                        </td-->
                    </tr>

                    <tr>
                        <td>반품사유</td>
                        <td colspan="5">
                            <?php 
                            foreach ($reasonreturninfo as $reasonreturn){
                                if ($item->refund_reason == $reasonreturn->return_id) {
                                    echo $reasonreturn->return_info;
                                }
                            }
                            ?>
                        </td>
                    </tr>
                    

                    <?php
                    $all_qty = $all_qty + $item->qty;
                    $all_amount_price = $all_amount_price + $item->supply_price;
                    $all_price_vat = $all_price_vat + $item->vat;
                    ?>
                    <?php $i++; ?>
                    <?php }
                    $total_all_price = $all_amount_price + $all_price_vat;
                    ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
 

  <!-------------------------------------------------------------------------------------------------------------------->
  
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">상품갯수 : </label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                <?=$all_qty?>개
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">합계금액 : </label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                <?=number_format($total_all_price)?>원 (VAT포함)
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
            

        <?php endif;?>

 <!------------------------------------------------------------------------------------------------------------------->
                <form method="post" action="<?=route_admin('refundinfo.update',$refundInfo->info_id)?>" enctype="multipart/form-data" id="form">

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">반품 신청번호</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->refund_code?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문번호</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->order_code?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">신청일시</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=\App\Helpers\DateHelper::toTimeString($refundInfo->created_at,'yyyy-MM-dd')?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문자<?=lang_common('name')?></label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->orderer_name?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문자 Email</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->orderer_email?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문자 휴대전화</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->orderer_phone?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">받는분</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->shipping_name?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">받는분 휴대전화</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->shipping_phone?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">받는분 전화</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->delivery_phone?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">배송지</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->shipping_zipocode?>
                                                    <?=$refundInfo->shipping_add1?>
                                                    <?=$refundInfo->shipping_add2?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">배송메시지</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->shipping_message?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">전달사항</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$refundInfo->notice?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">결제수단</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                <?php 
                                                if($refundInfo->payment_flg =="Card") {
                                                    echo "신용카드";
                                                } elseif ($refundInfo->payment_flg =="Directbank"){
                                                    echo "계좌이체";
                                                } elseif ($refundInfo->payment_flg =="vbank"){
                                                    echo "무통장입금";
                                                }
                                                ?> 
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">환불처리</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                <select class="form-control" name="refund_status">
                                                <option value="" <?php if($refundInfo->refund_status == 0) {  echo "selected";}?>>접수</option>
                                                <option value="1" <?php if($refundInfo->refund_status == 1) {  echo "selected";}?>>신청</option>
                                                <option value="2" <?php if($refundInfo->refund_status == 2) {  echo "selected";}?>>처리중</option>
                                                <option value="3" <?php if($refundInfo->refund_status == 3) {  echo "selected";}?>>완료</option>
                                                </select>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">반품처리</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                <select class="form-control" name="return_status">
                                                <option value="" <?php if($refundInfo->return_status == 0) {  echo "selected";}?>>접수</option>
                                                <option value="1" <?php if($refundInfo->return_status == 1) {  echo "selected";}?>>신청</option>
                                                <option value="2" <?php if($refundInfo->return_status == 2) {  echo "selected";}?>>처리중</option>
                                                <option value="3" <?php if($refundInfo->return_status == 3) {  echo "selected";}?>>완료</option>
                                                </select>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <label class="col-md-1 col-form-label font-weight-bold">반품사유</label>
                                            <div class="col-md-11">
                                                <label class="col-form-label">
                                                <?php 
                                                foreach ($reasonreturninfo as $reasonreturn){
                                                    if ($item->refund_reason == $reasonreturn->return_id) {
                                                        echo $reasonreturn->return_info;
                                                    }
                                                }
                                                ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <label class="col-md-1 col-form-label font-weight-bold">반품 상세 사유</label>
                                            <div class="col-md-11">
                                                <label class="col-form-label">
                                                <?php echo htmlspecialchars_decode($refundInfo->content)?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                        <label class="col-md-1 col-form-label font-weight-bold"><?=lang_common('answer')?></label>
                                            <div class="col-md-11">
                                                <label class="col-form-label" style="width: 100%;">
                                                    <textarea class="form-control" id="answer_content" name="answer_content" rows="8"><?php echo htmlspecialchars_decode($refundInfo->answer_content)?></textarea>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                        </div>
                            <div class="card-footer text-center">

                                <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                <a class="btn btn-primary btn-lg" href="<?=route_admin('refundinfo.index')?>"><?=lang_common('list')?></a>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
