<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<title>404 Page Not Found</title>
	<style>
	div.logo {
		height: 200px;
		width: 155px;
		display: inline-block;
		opacity: 0.08;
		position: absolute;
		top: 2rem;
		left: 50%;
		margin-left: -73px;
	}
	body {
		height: 100%;
		background: #fafafa;
		font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
		color: #777;
		font-weight: 300;
	}
	h1 {
		font-weight: lighter;
		letter-spacing: 0.8;
		font-size: 3rem;
		margin-top: 0;
		margin-bottom: 0;
		color: #222;
	}
	.wrap {
		max-width: 1024px;
		margin: 5rem auto;
		padding: 2rem;
		background: #fff;
		text-align: center;
		border: 1px solid #efefef;
		border-radius: 0.5rem;
		position: relative;
	}
	pre {
		white-space: normal;
		margin-top: 1.5rem;
	}
	code {
		background: #fafafa;
		border: 1px solid #efefef;
		padding: 0.5rem 1rem;
		border-radius: 5px;
		display: block;
	}
	p {
		margin-top: 1.5rem;
	}
	.footer {
		margin-top: 2rem;
		border-top: 1px solid #efefef;
		padding: 1em 2em 0 2em;
		font-size: 85%;
		color: #999;
	}
	a:active,
	a:link,
	a:visited {
		color: #dd4814;
	}
</style>

<style type="text/css">
		<?= preg_replace('#[\r\n\t ]+#', ' ', file_get_contents(__DIR__ . DIRECTORY_SEPARATOR . 'common.css')) ?>
</style>

</head>
<body>
	<div class="wrap">


		<p style="padding:20px 0">

		<?php
		$uri= $_SERVER['REQUEST_URI']; 
		if ($uri == "/cart/inistdpayclose") {header( 'Location: https://chipdirect.co.kr' );}

		$imgdata = base64_encode(file_get_contents(__DIR__ . DIRECTORY_SEPARATOR . '404-not-found.png'));
		echo "<img src='data:image/gif;base64, $imgdata' alt=''>"; 
		?>

		</p>
		<p style="font-size:36px;">요청하신 페이지를 찾을 수 없습니다.</p>
		<div style="padding:30px 0 50px">
			<p>방문하시려는 페이지의 주소가 잘못 입력되었거나,<br>변경 또는 삭제되어 요청하신 페이지를 찾을 수 없습니다.<br></p>
			<p style="padding:10px 0">입력하신 페이지의 주소가 정확한지 다시 한 번 확인해 주시기 바랍니다.</p>
			<p>같은 문제가 계속 발생할 경우 고객센터로 문의해 주시면<br /> 친절하게 안내해 드리겠습니다.</p>
		</div>

		<div class="gt-padding-xlarge">
        <a href="https://<?=$_SERVER["HTTP_HOST"]?>" type="button" class="gt-btn-blue">쇼핑몰 홈으로</a>
		</div>

	</div>
</body>
</html>
