<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$settingInfo->app_name?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<section id="siteMain" class="site-main">
    <div class="container">
        <div class="form-login">
            <?php if($session->has('message')): ?>
                <div class="alert alert-success">
                    <?=$session->get('message')?>
                </div>
            <?php endif; ?>
            <?php if($session->has('error_message')): ?>
                <div class="alert alert-danger">
                    <?=$session->get('error_message')?>
                </div>
            <?php endif; ?>
            <h2 class="form-title"><?=lang_login('title')?></h2>
            <form id="form" method="post" action="<?=route_guest('login')?>">
                <?php if(has_error('error_common')): ?>
                    <div class="alert alert-danger">
                        <span><?=get_error('error_common')?></span>
                    </div>
                <?php endif?>
                <div class="form-group">
                    <label for="member_email" class="form-label"><?=lang_login('user_name')?></label>
                    <input id="member_email" type="text" class="form-control" name="member_email" aria-describedby="member_email" value="<?=old('member_email')?>"/>
                </div>
                <div class="form-group">
                    <label for="password" class="form-label"><?=lang_login('password')?></label>
                    <input id="password" type="password" class="form-control" name="password" aria-describedby="password"/>
                </div>
                <div class="form-group">
                    <div class="form-check">
                        <input class="form-check-input" name="remember" type="checkbox" <?=!empty(old('remember')) ? 'checked' : '' ?> value="<?=REMEMBER_FLG_ON?>" id="remember">
                        <label class="form-check-label" for="remember"><?=lang_login('remember')?></label>
                    </div>
                </div>
                <div class="form-action">
                    <button type="submit" class="btn btn-block btn-outline-primary w-100 active" name="submit"><?=lang_login('button_login')?></button>
                </div>
                </form>

                <div class="form-group" style="padding-top: 8px;">
                    <a class="link-register" href="<?=route_guest('register')?>"><?=lang_login('link_register')?></a> &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                    <a class="link-register" href="<?=route_guest('forgot_password')?>"><?=lang_login('link_forgot_password')?></a>
                </div>

                <?php
                define('NAVER_CLIENT_ID', 'bS6uqBpR00835BFLFGDa');
                define('NAVER_CLIENT_SECRET', 'aETxh2Ecip');

                // define('NAVER_CALLBACK_URL', 'http://localhost/naverapi/naverinfo');
                // $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);
                define('NAVER_CALLBACK_URL', 'https://chipdirect.co.kr/naverapi/naverinfo');
                $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);

                $REST_API_KEY   = "efbf6f87ffc71fde085dec391453d989"; // 내 애플리케이션 > 앱 설정 > 요약 정보
                $CLIENT_SECRET  = ""; // 내 애플리케이션 > 제품 설정 > 카카오 로그인 > 보안
                // $REDIRECT_URI  = urlencode("http://localhost/kakaoapi/kakaoinfo");
                $REDIRECT_URI  = urlencode("https://chipdirect.co.kr/kakaoapi/kakaoinfo");

                ?>

                <div class="form-link text-center">
                    <a class="link-register" href="<?=$naverUrl?>"><img width="150" src="<?=asset_public('images/btnW_naver.png')?>"></a> &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                    <a href="https://kauth.kakao.com/oauth/authorize?client_id=<?=$REST_API_KEY?>&response_type=code&redirect_uri=<?=$REDIRECT_URI?>"><img width="150" src="<?=asset_public('images/btnW_kakao.png')?>"></a>
                </div>

        </div>
    </div>

    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {        
            <?php if(session()->getFlashdata('status')) {?>
                swal({
                    title: "<?=session()->getFlashdata('status')?>",
                    text: "<?=session()->getFlashdata('status_text')?>",
                    icon: "<?=session()->getFlashdata('status_icon')?>",
                    buttons: "확인",
                });
            <?Php } ?>
        });
    </script>

</section>
<?= $this->endSection() ?>
