<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$settingInfo->app_name?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<section id="siteMain" class="site-main">
    <div class="container">
        <div class="form-register">
            <h2 class="form-title"><?= lang_register('title') ?></h2>
            <form method="post" action="<?=route_guest('register.create')?>" enctype="multipart/form-data" id="form">
            <input type="hidden" name="member_code" value="<?="MBR".date(time())?>" required/>
                <div class="form-group">
                    <label><?=lang_register('category')?></label>
                    <div class="form-inline">
                        <div class="form-check mr-5">
                            <input class="form-check-input" name="category_id" type="radio" value="<?=MEMBER_CATEGORY_PERSON?>" checked id="person">
                            <label class="form-check-label" for="person"><?=lang_register('category_person')?></label>
                        </div>
                        <div class="form-check mr-5">
                            <input class="form-check-input" name="category_id" type="radio" value="<?=MEMBER_CATEGORY_COMPANY?>" id="company">
                            <label class="form-check-label" for="company"><?=lang_register('category_company')?></label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" name="category_id" type="radio" value="<?=MEMBER_CATEGORY_DEALER?>" id="dealer">
                            <label class="form-check-label" for="dealer"><?=lang_register('category_dealer')?></label>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="member_name" class="form-label">
                        <?=lang_register('name')?> <span class="text-danger">(*)</span></label>
                    <input id="member_name" value="<?=old('member_name')?>" type="text" class="form-control" name="member_name" aria-describedby="member_name"/>
                </div>
                <div class="form-group">
                    <label for="member_email" class="form-label">
                        <?=lang_register('email')?> <span class="text-danger">(*)</span></label>
                    <input id="member_email" value="<?=old('member_email')?>" type="text" class="form-control" name="member_email" aria-describedby="member_email"/>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">
                        <?=lang_register('password')?> <span class="text-danger">(*)</span></label>
                    <input id="password" type="password" class="form-control" name="password" aria-describedby="password"/>
                    <div class="small">
                        <span class="text-danger">(*)</span> <?=lang_register('password_note')?>
                    </div>
                </div>
                <div class="form-group">
                    <label for="pass_confirm" class="form-label">
                        <?=lang_register('confirm_password')?> <span class="text-danger">(*)</span></label>
                    <input id="pass_confirm" type="password" class="form-control" name="pass_confirm" aria-describedby="pass_confirm"/>
                </div>

                <div class="form-group">
                    <label for="member_phone" class="form-label">
                        <?=lang_register('phone')?> <span class="text-danger">(*)</span></label>
                    <input id="member_phone" value="<?=old('member_phone')?>" type="text" class="form-control" name="member_phone" aria-describedby="member_phone"/>
                </div>

                <div class="form-group">
                    <label for="member_zipcode" class="form-label">
                        <?=lang_register('zipcode')?> <span class="text-danger">(*)</span></label>
                    <input id="member_zipcode" value="<?=old('member_zipcode')?>" type="text" class="form-control" name="member_zipcode" aria-describedby="member_zipcode"/>
                </div>

                <div class="form-group">
                    <label for="member_address1" class="form-label">
                        <?=lang_register('address1')?> <span class="text-danger">(*)</span></label>
                    <input id="member_address1" value="<?=old('member_address1')?>" type="text" class="form-control" name="member_address1" aria-describedby="member_address1"/>
                </div>

                <div class="form-group">
                    <label for="member_address2" class="form-label">
                        <?=lang_register('address2')?> <span class="text-danger">(*)</span></label>
                    <input id="member_address2" value="<?=old('member_address2')?>" type="text" class="form-control" name="member_address2" aria-describedby="member_address2"/>
                </div>

                <div class="form-group">
                    <label for="com_name" class="form-label">
                        <?=lang_register('comname')?> <span class="text-danger">(*)</span></label>
                    <input id="com_name" value="<?=old('com_name')?>" type="text" class="form-control" name="com_name" aria-describedby="com_name"/>
                </div>
                <div class="form-group">
                    <label for="com_englishname" class="form-label">
                        <?=lang_register('comenglishname')?> <span class="text-danger">(*)</span></label>
                    <input id="com_englishname" value="<?=old('com_englishname')?>" type="text" class="form-control" name="com_englishname" aria-describedby="com_englishname"/>
                </div>
                <div class="form-group">
                    <label for="biz_number" class="form-label">
                        <?=lang_register('biznumber')?> <span class="text-danger">(*)</span></label>
                    <input id="biz_number" value="<?=old('biz_number')?>" type="text" class="form-control" name="biz_number" aria-describedby="biz_number"/>
                </div>

                <div class="form-group">
                    <label for="ceo_name" class="form-label">
                        <?=lang_register('ceoname')?> <span class="text-danger">(*)</span></label>
                    <input id="ceo_name" value="<?=old('ceo_name')?>" type="text" class="form-control" name="ceo_name" aria-describedby="ceo_name"/>
                </div>

                <div class="form-group">
                    <label for="com_zipcode" class="form-label">
                        <?=lang_register('comzipcode')?> <span class="text-danger">(*)</span></label>
                    <input id="com_zipcode" value="<?=old('com_zipcode')?>" type="text" class="form-control" name="com_zipcode" aria-describedby="com_zipcode"/>
                </div>

                <div class="form-group">
                    <label for="com_address1" class="form-label">
                        <?=lang_register('comaddress1')?> <span class="text-danger">(*)</span></label>
                    <input id="com_address1" value="<?=old('com_address1')?>" type="text" class="form-control" name="com_address1" aria-describedby="com_address1"/>
                </div>
                <div class="form-group">
                    <label for="com_address2" class="form-label">
                        <?=lang_register('comaddress2')?> <span class="text-danger">(*)</span></label>
                    <input id="com_address2" value="<?=old('com_address2')?>" type="text" class="form-control" name="com_address2" aria-describedby="com_address2"/>
                </div>
                <div class="form-group">
                    <label for="com_phone" class="form-label">
                        <?=lang_register('comphone')?> <span class="text-danger">(*)</span></label>
                    <input id="com_phone" value="<?=old('com_phone')?>" type="text" class="form-control" name="com_phone" aria-describedby="com_phone"/>
                </div>
                <div class="form-group">
                    <label for="com_fax" class="form-label">
                        <?=lang_register('comfax')?> <span class="text-danger">(*)</span></label>
                    <input id="com_fax" value="<?=old('com_fax')?>" type="text" class="form-control" name="com_fax" aria-describedby="com_fax"/>
                </div>
                <div class="form-group">
                    <label for="homepage" class="form-label">
                        <?=lang_register('homepage')?> <span class="text-danger">(*)</span></label>
                    <input id="homepage" value="<?=old('homepage')?>" type="text" class="form-control" name="homepage" aria-describedby="homepage"/>
                </div>
                <div class="form-group">
                    <label for="invoice_email" class="form-label">
                        <?=lang_register('invoiceemail')?> <span class="text-danger">(*)</span></label>
                    <input id="invoice_email" value="<?=old('invoice_email')?>" type="text" class="form-control" name="invoice_email" aria-describedby="invoice_email"/>
                </div>
                <div class="form-group">
                    <label for="sectors" class="form-label">
                        <?=lang_register('sectors')?> <span class="text-danger">(*)</span></label>
                    <input id="sectors" value="<?=old(' sectors')?>" type="text" class="form-control" name=" sectors" aria-describedby=" sectors"/>
                </div>
                <div class="form-group">
                    <label for="condition" class="form-label">
                        <?=lang_register('condition')?> <span class="text-danger">(*)</span></label>
                    <input id="condition" value="<?=old('condition')?>" type="text" class="form-control" name="condition" aria-describedby="condition"/>
                </div>
                <div class="form-group">
                    <label for="account_bankname" class="form-label">
                        <?=lang_register('accountbankname')?> <span class="text-danger">(*)</span></label>
                    <input id="account_bankname" value="<?=old('account_bankname')?>" type="text" class="form-control" name="account_bankname" aria-describedby="account_bankname"/>
                </div>
                <div class="form-group">
                    <label for="account_number" class="form-label">
                        <?=lang_register('accountnumber')?> <span class="text-danger">(*)</span></label>
                    <input id="account_number" value="<?=old('account_number')?>" type="text" class="form-control" name="account_number" aria-describedby="account_number"/>
                </div>
                <div class="form-group">
                    <label for="account_depositor" class="form-label">
                        <?=lang_register('accountdepositor')?> <span class="text-danger">(*)</span></label>
                    <input id="account_depositor" value="<?=old(' account_depositor')?>" type="text" class="form-control" name="account_depositor" aria-describedby="account_depositor"/>
                </div>


        <div class="form-group file_upload">
            <label for="account_depositor" class="form-label">
                <?=lang_common('file_upload')?></label>

            <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                        <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                    </div>
                    <div class="file_action">
                        <?php if($i > 1): ?>
                            <a href="javascript:void(0)" class="button-delete color-red">
                                <i class="fa fa-minus-square"></i>
                            </a>
                        <?php else: ?>
                            <a href="javascript:void(0)" class="button-add">
                                <i class="fas fa-plus-circle"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endfor; ?>
            <span class="help-block">
                <code>
                    <i class="fa fa-exclamation" aria-hidden="true"></i>
                    <?=lang_common('file_upload_note')?>
                </code>
            </span>
            </div>
        </div>

                <div class="form-action">
                    <button type="submit" class="btn btn-submit btn-login w-100" name="submit"><?=lang_register('button_register')?></button>
                </div>
                <div class="form-link text-center">
                    <p><a class="link-register" href="<?=route_guest('login')?>"><?=lang_register('link_login')?></a></p>
                </div>
            </form>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
