<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$settingInfo->app_name?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<!------------------------------------------------------------------------------------------------------------------->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">

      <nav class="breadcrumb" style='background-color: #ffffff;'>
          <ul>
              <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
              <li><a href="#">회원가입</a></li> 
          </ul>            
      </nav>

        <div class="d-flex">
            <div class="row align-l">
                <h2 class="mb-0 pb-0">회원가입</h2>
                <p class="font-xsm col-gray"> </p>
            </div>
        </div>

        <div class="cart_flow mb-2">
            <div class="flow cartFlow_1second">01 가입유형</div>
            <div class="flow cartFlow_2second">02 가입서작성</div>
            <div class="flow cartFlow_3second">03 가입완료</div>
        </div>

            <form method="post" action="<?=route_guest('register.create')?>" enctype="multipart/form-data" id="form">
                    <input type="hidden" name="member_code" value="<?="MBR".date(time())?>" required/>
                    <input type="hidden" name="category_id" value="<?=$memCategory?>" required/>
                    <input type="hidden" name="api_type" value="<?=$api_type?>" required/>
                    <input type="hidden" name="password" value="<?=$member_phone?>" required/>
                    <input type="hidden" name="pass_confirm" value="<?=$member_phone?>" required/>
                    <input type="hidden" name="member_email" value="<?=$member_email?>" required/>
                    <input type="hidden" name="member_name" value="<?=$member_name?>" required/>
                    <input type="hidden" name="member_phone" value="<?=$member_phone?>" required/>

        <!-- 주문자 정보 s -->
        <div class="border-light-box">
        <div class="sub_title d-flex">기업/단체 정보</div>
            <div class="border-light-box order-form">
            <div class="sub_title d-flex">회사정보</div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('email')?><span class="col-red">*</span></label>
                        <input id="member_email" value="<?=$member_email?>" type="text" class="form-control" disabled aria-describedby="member_email"/>
                    </div>  
                    <div class="d-flex g-2">

                    </div>
                </div>

                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('comname')?><span class="col-red">*</span></label>
                        <input id="com_name" value="<?=old('com_name')?>" type="text" name="com_name" aria-describedby="com_name" required/>
                    </div>
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('comenglishname')?></label>
                        <input id="com_englishname" value="<?=old('com_englishname')?>" type="text" name="com_englishname" aria-describedby="com_englishname"/>
                    </div>  
                </div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('biznumber')?></label>
                        <input id="biz_number" value="<?=old('biz_number')?>" type="text" name="biz_number" aria-describedby="biz_number"/>
                    </div>
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('ceoname')?></label>
                        <input id="ceo_name" value="<?=old('ceo_name')?>" type="text" name="ceo_name" aria-describedby="ceo_name"/>
                    </div>  
                </div>

                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_info_edit('zipcode')?><span class="col-red">*</span></label>
                        <div class="group-btn d-flex">
                        <input type="text"  class="col-md-4" id="com_zipcode" name="com_zipcode" value="<?=$itemsub->com_zipcode?>" placeholder="<?=lang_info_edit('comzipcode')?>"/>
                        <input type="button" onclick="addr02_execDaumPostcode()" value="우편번호 찾기" class="btn btn-gray ml-1">
                        </div>
                    </div>
                    <div class="d-flex g-2"> </div>
                </div>
                <div class="form-gp">                
                    <div class="d-flex g-1">
                        <label for=""><?=lang_info_edit('address1')?><span class="col-red">*</span></label>
                        <input type="text" id="com_address1" name="com_address1" value="<?=$itemsub->com_address1?>" placeholder="<?=lang_info_edit('comaddress1')?>" required/>
                    </div>
                </div>
                <div class="form-gp">                
                    <div class="d-flex g-1">
                        <label for=""><?=lang_info_edit('address2')?></label>
                        <input type="text" id="com_address2" name="com_address2" value="<?=$itemsub->com_address2?>" placeholder="<?=lang_info_edit('comaddress2')?>"/>
                    </div>
                </div>
                <div class="form-gp">                
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('comphone')?></label>
                        <input id="com_phone" value="<?=old('com_phone')?>" type="text" name="com_phone" aria-describedby="com_phone"/>
                    </div>              
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('comfax')?></label>
                        <input id="com_fax" value="<?=old('com_fax')?>" type="text" name="com_fax" aria-describedby="com_fax"/>
                    </div>
                </div>
                <div class="form-gp">
                    <div class="d-flex g-1">
                        <label for=""><?=lang_register('homepage')?></label>
                        <input id="homepage" value="<?=old('homepage')?>" type="text" name="homepage" aria-describedby="homepage"/>
                    </div>
                </div>
            </div>

            <div class="border-light-box order-form">
            <div class="sub_title d-flex">담당자 정보</div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for="">담당자 이름<span class="col-red">*</span></label>
                        <input id="member_name" value="<?=$member_name?>" type="text" class="form-control" disabled aria-describedby="member_name" required/>
                    </div>
                    <div class="d-flex g-2">

                    </div>  
                </div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for="">담당자 휴대폰<span class="col-red">*</span></label>
                        <?php if ($member_phone) { ?>
                            <input id="member_phone" value="<?=$member_phone?>" type="text" class="form-control" disabled aria-describedby="member_phone" required/>
                        <?php } else { ?>
                            <input id="member_phone" value="<?=$member_phone?>" type="text" class="form-control" aria-describedby="member_phone" required/>
                        <?php } ?>
                    </div>
                    <input id="certificationsns" value="sns" type="hidden" name="certificationsns" required/>   
                    <div class="d-flex g-2">

                    </div>  
                </div>
            </div>

            <div class="border-light-box order-form">
            <div class="sub_title d-flex">계산서 발행정보</div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('invoiceemail')?></label>
                        <input id="invoice_email" value="<?=old('invoice_email')?>" type="email" name="invoice_email" aria-describedby="invoice_email"/>
                    </div>
                    <div class="d-flex g-2">

                    </div>  
                </div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('sectors')?></label>
                        <input id="sectors" value="<?=old(' sectors')?>" type="text" name="sectors" aria-describedby="sectors"/>
                    </div>
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('condition')?></label>
                        <input id="condition" value="<?=old('condition')?>" type="text" name="condition" aria-describedby="condition"/>
                    </div>  
                </div>
            </div>
            
            <div class="border-light-box order-form">
            <div class="sub_title d-flex">회사계좌정보</div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('accountdepositor')?></label>
                        <input id="account_depositor" value="<?=old(' account_depositor')?>" type="text" name="account_depositor" aria-describedby="account_depositor"/>
                    </div>
                    <div class="d-flex g-2">

                    </div>  
                </div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('accountbankname')?></label>
                        <input id="account_bankname" value="<?=old('account_bankname')?>" type="text" name="account_bankname" aria-describedby="account_bankname"/>
                    </div>
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('accountnumber')?></label>
                        <input id="account_number" value="<?=old('account_number')?>" type="text" name="account_number" aria-describedby="account_number"/>
                    </div>  
                </div>
            </div>

            <div class="border-light-box order-form">
            <div class="sub_title d-flex">첨부문서</div>
                <div class="form-gp">
                    <div class="d-flex g-1">
                        <label for="">사업자등록증</label>
                        <input type="file" id="files_1" name="files_1" maxsizeMb="5" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf"/>   
                    </div>
                </div>
                <div class="form-gp">
                    <div class="d-flex g-1">
                        <label for=""> </label>
                        <?=lang_register('file_upload_note')?>
                    </div>
                </div>

                <!--div class="form-group file_upload">
                    <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                        <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="5" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf" required/>
                                <label class="custom-file-label" for="files_<?=$i?>">파일선택</label>
                            </div>
                            <div class="file_action">
                                <?php if($i > 1): ?>
                                    <a href="javascript:void(0)" class="button-delete color-red">
                                        <i class="fa fa-minus-square"></i>
                                    </a>
                                <?php else: ?>
                                    <a href="javascript:void(0)" class="button-add">
                                        <i class="fas fa-plus-circle"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endfor; ?>
                    <span class="help-block">
                        <code>
                            <i class="fa fa-exclamation" aria-hidden="true"></i>
                            <?=lang_register('file_upload_note')?>
                        </code>
                    </span>
                </div-->


                </div>
            </div>

        </div>

        <div class="order-btn-box mt-3 mb-2"> </div>
        <div class="order-btn-box btn-lg-box btn-box align-c">
            <button type="submit" class="btn btn-lg btn-blue w-20 ml-1"><?=lang_common('create')?></button>
        </div>
            
        </form>

<!------------------------------------------------------------------------------------------------------------------->
</div>
</section>
<!-- product details top info e -->
<!------------------------------------------------------------------------------------------------------------------->

    <script>
        function check() {
        <?php
            echo "let certification = $('#certification').val();";
            echo "let certificationMd5 = '$certification';";
        ?>
            if (certification!==certificationMd5) {
                $("#check").show();
            } else{
                $("#check").hide();
            }
        }
            $(document).ready(function() {
            $("#check").hide();
        });
    </script>
                
    <script src="//t1.daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js"></script>
    <script>
        function addr01_execDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("member_address2").value = extraAddr;                    
                    } else {
                        document.getElementById("member_address2").value = '';
                    }
                    document.getElementById('member_zipcode').value = data.zonecode;
                    document.getElementById("member_address1").value = addr;
                    document.getElementById("member_address2").focus();
                }
            }).open();
        }

        function addr02_execDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("com_address2").value = extraAddr;                    
                    } else {
                        document.getElementById("com_address2").value = '';
                    }
                    document.getElementById('com_zipcode').value = data.zonecode;
                    document.getElementById("com_address1").value = addr;
                    document.getElementById("com_address2").focus();
                }
            }).open();
        }
    </script>

<?= $this->endSection() ?>
