<?php
use App\Helpers\AuthHelpers;

// 이니시스페이 설정
        require_once('inicis/libs/INIStdPayUtil.php');
        require_once('inicis/libs/HttpClient.php');
 
        $util = new INIStdPayUtil();
 
        try {
 
            //#############################
            // 인증결과 파라미터 수신
            //#############################

            if (strcmp("0000", $_REQUEST["resultCode"]) == 0) {
 
                //############################################
                // 1.전문 필드 값 설정(***가맹점 개발수정***)
                //############################################
 
                $mid        = $_REQUEST["mid"];
                $timestamp  = $util->getTimestamp();
                $charset    = "UTF-8";
                $format     = "JSON";
                $authToken  = $_REQUEST["authToken"]; 
                $authUrl    = $_REQUEST["authUrl"];
                $netCancel  = $_REQUEST["netCancelUrl"];        
                $merchantData = $_REQUEST["merchantData"];
 
                //#####################
                // 2.signature 생성
                //#####################
                $signParam["authToken"] = $authToken;   // 필수
                $signParam["timestamp"] = $timestamp;   // 필수
                // signature 데이터 생성 (모듈에서 자동으로 signParam을 알파벳 순으로 정렬후 NVP 방식으로 나열해 hash)
                $signature = $util->makeSignature($signParam);
 
 
                //#####################
                // 3.API 요청 전문 생성
                //#####################
                $authMap["mid"]        = $mid;       // 필수
                $authMap["authToken"]  = $authToken; // 필수
                $authMap["signature"]  = $signature; // 필수
                $authMap["timestamp"]  = $timestamp; // 필수
                $authMap["charset"]    = $charset;   // default=UTF-8
                $authMap["format"]     = $format;    // default=XML
 
                try {
 
                    $httpUtil = new HttpClient();
 
                    //#####################
                    // 4.API 통신 시작
                    //#####################
 
                    $authResultString = "";
                    if ($httpUtil->processHTTP($authUrl, $authMap)) {
                        $authResultString = $httpUtil->body;
 
                    } else {
                        echo "Http Connect Error\n";
                        echo $httpUtil->errormsg;
 
                        throw new Exception("Http Connect Error");
                    }
 
                    //############################################################
                    //5.API 통신결과 처리(***가맹점 개발수정***)
                    //############################################################
                    
                    $resultMap = json_decode($authResultString, true);
 
 
                } catch (Exception $e) {
                    //    $s = $e->getMessage() . ' (오류코드:' . $e->getCode() . ')';
                    //####################################
                    // 실패시 처리(***가맹점 개발수정***)
                    //####################################
                    //---- db 저장 실패시 등 예외처리----//
                    $s = $e->getMessage() . ' (오류코드:' . $e->getCode() . ')';
                    echo $s;
 
                    //#####################
                    // 망취소 API
                    //#####################
 
                    $netcancelResultString = ""; // 망취소 요청 API url(고정, 임의 세팅 금지)
                    if ($httpUtil->processHTTP($netCancel, $authMap)) {
                        $netcancelResultString = $httpUtil->body;
                    } else {
                        echo "Http Connect Error\n";
                        echo $httpUtil->errormsg;
 
                        throw new Exception("Http Connect Error");
                    }
 
                    echo "<br/>## 망취소 API 결과 ##<br/>";
                    
                    /*##XML output##*/
                    //$netcancelResultString = str_replace("<", "&lt;", $$netcancelResultString);
                    //$netcancelResultString = str_replace(">", "&gt;", $$netcancelResultString);
 
                    // 취소 결과 확인
                    echo "<p>". $netcancelResultString . "</p>";
                }
            } else {
 
            }
        } catch (Exception $e) {
            $s = $e->getMessage() . ' (오류코드:' . $e->getCode() . ')';
            echo $s;
        }
// 이니시스페이 설정 끝

/*
$resultMap["orderinId"] = $orderinId;
$queryString = http_build_query($resultMap);
$url = 'https://chipdirect.co.kr/cart/inistdpayclose?'.$queryString;
// echo "<script>location.href='https://chipdirect.co.kr/cart/inistdpayclose'</script>";
echo "<meta http-equiv='refresh' content='0;url=".$url."'>";

array(46) { ["CARD_Quota"]=> string(2) "00" ["CARD_ClEvent"]=> string(0) "" ["CARD_CorpFlag"]=> string(1) "0" ["buyerTel"]=> string(13) "010-9028-7124" ["parentEmail"]=> string(0) "" 
["applDate"]=> string(8) "20241017" ["buyerEmail"]=> string(17) "pixel25@naver.com" ["OrgPrice"]=> string(0) "" ["p_Sub"]=> string(0) "" ["resultCode"]=> string(4) "0000" ["mid"]=> string(10) "INIpayTest" 
["CARD_UsePoint"]=> string(0) "" ["CARD_Num"]=> string(16) "465887*********1" ["authSignature"]=> string(64) "75c12240e8feb65839e5983313eb7afb6016a86d5ed0b46b2fdd5a7a81b4b0c7" ["tid"]=> string(40) "StdpayCARDINIpayTest20241017143727810618" 
["EventCode"]=> string(0) "" ["goodName"]=> string(27) "전자부품(M607372000000)" ["TotPrice"]=> string(3) "308" ["payMethod"]=> string(4) "Card" ["CARD_MemberNum"]=> string(0) "" ["MOID"]=> string(23) "ORD_INI_1729143379987" 
["CARD_Point"]=> string(0) "" ["currency"]=> string(3) "WON" ["CARD_PurchaseCode"]=> string(0) "" ["CARD_PrtcCode"]=> string(1) "1" ["applTime"]=> string(6) "143730" ["goodsName"]=> string(27) "전자부품(M607372000000)" 
["CARD_CheckFlag"]=> string(1) "0" ["FlgNotiSendChk"]=> string(0) "" ["CARD_Code"]=> string(2) "14" ["CARD_BankCode"]=> string(2) "26" ["CARD_TerminalNum"]=> string(10) "019058I000" ["P_FN_NM"]=> string(12) "신한카드" 
["buyerName"]=> string(9) "정경연" ["p_SubCnt"]=> string(0) "" ["applNum"]=> string(8) "21661462" ["resultMsg"]=> string(28) "정상처리되었습니다." ["CARD_Interest"]=> string(1) "0" ["CARD_SrcCode"]=> string(0) "" 
["CARD_ApplPrice"]=> string(3) "308" ["CARD_GWCode"]=> string(1) "G" ["custEmail"]=> string(17) "pixel25@naver.com" ["CARD_Expire"]=> string(0) "" ["CARD_PurchaseName"]=> string(12) "신한카드" 
["CARD_PRTC_CODE"]=> string(1) "1" ["payDevice"]=> string(2) "PC" }

var_dump($resultMap);
exit;
*/

?>

<form id="return_form" action="./inistdpayclose" method="post">
    <input type="hidden" name="resultCode" value="<?=$resultMap["resultCode"]?>">
    <input type="hidden" name="resultMsg" value="<?=$resultMap["resultMsg"]?>">
    <input type="hidden" name="tid" value="<?=$resultMap["tid"]?>">
    <input type="hidden" name="MOID" value="<?=$resultMap["MOID"]?>">
    <input type="hidden" name="TotPrice" value="<?=$resultMap["TotPrice"]?>">
    <input type="hidden" name="goodName" value="<?=$resultMap["goodName"]?>">
    <input type="hidden" name="applDate" value="<?=$resultMap["applDate"]?>">
    <input type="hidden" name="applTime" value="<?=$resultMap["applTime"]?>">
    <input type="hidden" name="payMethod" value="<?=$resultMap["payMethod"]?>">
    <input type="hidden" name="applNum" value="<?=$resultMap["applNum"]?>">
    <input type="hidden" name="P_FN_NM" value="<?=$resultMap["P_FN_NM"]?>">
    <input type="hidden" name="VACT_Num" value="<?=$resultMap["VACT_Num"]?>">
    <input type="hidden" name="VACT_BankCode" value="<?=$resultMap["VACT_BankCode"]?>">
    <input type="hidden" name="vactBankName" value="<?=$resultMap["vactBankName"]?>">
    <input type="hidden" name="VACT_Date" value="<?=$resultMap["VACT_Date"]?>">
    <input type="hidden" name="payDevice" value="<?=$resultMap["payDevice"]?>">
    <input type="hidden" name="orderinId" value="<?=$orderinId?>">
</form>

<script type="text/javascript"> 
    this.document.getElementById("return_form").submit(); 
</script> 