<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>
<?= $this->section('head.title') ?>
    <?=lang_cart('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('cart.js')?>"></script>
    <script src="<?=asset_guest_js('calculator.js')?>"></script>
    <script>
        $("input[type='number']").inputSpinner();
        CartJS.init();
    </script>

    <script>
        function info_chk() {
        return true;
        }
        function info_chk2(frm) {
        frm.action='<?=route_guest('cart.sheet')?>';
        frm.submit();
        return true;
        }
        function info_chk3(frm) {
        frm.action='<?=route_guest('cart.sheet')?>';
        frm.submit();
        return true;
        }
    </script>

    <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>

	<script type="text/javascript">
        function selectAll(selectAll)  {
        const checkboxes 
            = document.querySelectorAll('input[type="checkbox"]');
        checkboxes.forEach((checkbox) => {
            checkbox.checked = selectAll.checked
        })
        }
	</script>

    <link rel="stylesheet" href="<?=asset_guest_css('cart.css')?>">

<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->

<section class="sub_wrap">
    <div class="content_wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <div class="d-flex">
            <div class="row align-l">
                <h2 class="mb-0 pb-0">주문완료</h2>
                <p class="font-xsm col-gray"> </p>
            </div>
        </div>


        <div class="cart_flow mb-2">
            <div class="flow cartFlow_1third">01 장바구니</div>
            <div class="flow cartFlow_2third">02 주문/결제</div>
            <div class="flow cartFlow_3third">03 주문완료</div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->

            <!-- 처리내역 s -->
            <div class="border-light-box order-form">
                    <div class="sub_title d-flex"><?=lang_common('toitem_msg1')?></div>
                    
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">처리내역</label><?=$orderInfo->resultMsg?>
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">주문번호</label><?=$orderInfo->MOID?>
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">결제분류</label><?=$orderInfo->payMethod?>
                        </div>                
                    </div>

                <?php
				if ($orderInfo->payMethod == "VBank") { //가상계좌
                    echo "
                    <div class='form-gp'>
                        <div class='d-flex g-1'>
                            <label>가상계좌은행</label>
                                ".$orderInfo->vactBankName."
                        </div>
                    </div>
                    <div class='form-gp'>
                        <div class='d-flex g-1'>
                            <label>가상계좌번호</label>
                                ".$orderInfo->VACT_Num."
                        </div>
                    </div>
                    <div class='form-gp'>
                        <div class='d-flex g-1'>
                            <label>입금마감일</label>
                                ".$orderInfo->VACT_Date."
                        </div>
                    </div>
					";
                } else if ($orderInfo->payMethod == "VCard") {
                    echo "
                    <div class='form-gp'>
                        <div class='d-flex g-1'>
                            <label>승인번호</label>
                                ".$orderInfo->applNum."
                        </div>
                    </div>
                    ";
				}else if ($orderInfo->payMethod == "Card") {
                    echo "
                    <div class='form-gp'>
                        <div class='d-flex g-1'>
                            <label>승인번호</label>
                                ".$orderInfo->applNum."
                        </div>
                    </div>
                    <div class='form-gp'>
                        <div class='d-flex g-1'>
                            <label>카드계열</label>
                                ".$orderInfo->P_FN_NM."
                        </div>
                    </div>
					";
				}
				?>
            </div>
            <!-- 처리내역 e -->
            
<!------------------------------------------------------------------------------------------------------------------->

</div>
    <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
        <a href="<?=route_guest('home')?>"><button class="btn btn-lg btn-blue w-20 ml-1">확인</button></a>
    </div>

<!------------------------------------------------------------------------------------------------------------------->
</section>

<?= $this->endSection() ?>