<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_cart('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('cart.js')?>"></script>
    <script src="<?=asset_guest_js('calculator.js')?>"></script>
    <script>
        $("input[type='number']").inputSpinner();
        CartJS.init();
    </script>

    <script>
        function info_chk() {
        frm.action='<?=route_guest('cart.deletepart')?>';
        frm.submit();
        return true;
        }
        function info_chk1(frm) {
        frm.action='<?=route_guest('cart.sheetall')?>';
        frm.submit();
        return true;
        }
        function info_chk2(frm) {
        frm.action='<?=route_guest('cart.sheet')?>';
        frm.submit();
        return true;
        }
        function info_chk3(frm) {
        frm.action='<?=route_guest('sale.estifromcart')?>';
        frm.submit();
        return true;
        }
    </script>
    <script type="text/javascript" src="https://wcs.naver.net/wcslog.js"></script>

    <script type="text/javascript">
        function selectAll(selectAll)  {
        const checkboxes 
            = document.querySelectorAll('input[id="pcheckbox"]');
        checkboxes.forEach((checkbox) => {
            checkbox.checked = selectAll.checked
        })
        }
	</script>

    <link rel="stylesheet" href="<?=asset_guest_css('cart.css')?>">
<?= $this->endSection() ?>
<?= $this->section('body.breadcrumb') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<!------------------------------------------------------------------------------------------------------------------->
<!-- product details top info s -->
<section class="sub_wrap">

    <div class="content_wrap">
    <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
                <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
                <li><a href="#">장바구니</a></li> 
            </ul>            
        </nav>

        <div class="d-flex">
            <div class="row align-l">
                <h2 class="mb-0 pb-0">장바구니</h2>
                <p class="font-xsm col-gray"> </p>
            </div>
        </div>


        <div class="cart_flow mb-2">
            <div class="flow cartFlow_1first">01 장바구니</div>
            <div class="flow cartFlow_2first">02 주문/결제</div>
            <div class="flow cartFlow_3first">03 주문완료</div>
        </div>

    <?php if (!$lists) :?>
    <div class="order_List mb40">

    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>

        <script>
            swal({
            title: "담겨진 상품이 없습니다.",
            text: "장바구니에 주문하실 상품을 담으신 후 진행하세요.",
            icon: "warning",
            buttons: "확인"
            }).then(function() {
                window.location = "<?=route_guest('home')?>";
            });
        </script>

    </div>
    <?php else: ?>

        <!-- 주문 상품정보 s -->
        <div class="border-light-box">
            <div class="sub_title">주문 상품정보</div>
            <table class="table_style2 order_list">
                <thead>
                    <tr>
                        <th><input type='checkbox' name='product' value='selectall'  onclick='selectAll(this)'/></th>
                        <th>이미지</th>
                        <th>주문상품</th>
                        <th>단가</th>
                        <th>주문수량</th>
                        <th>공급가액</th>
                        <th>VAT</th>
                        <th>금액</th>
                        <th>삭제</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                $i = 1; 
                $deliverydays = 0;
                
                foreach($lists as $item){
                
                    $item_price = $item->price;
                    $amount_price = $item_price * $item->qty;
                    $price_vat = $amount_price*0.1;
                    $total_price = $amount_price+$price_vat;
                ?>

                <form id="form-cart" name="user_form" method="post" action="<?=route_guest('cart.deletepart')?>">
                    <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>">
                    <input type="hidden" name="inquiry_code<?=$i?>" value="<?=$item->inquiry_code?>">
                    <input type="hidden" name="member_id<?=$i?>" value="<?=$item->member_id?>">
                    <input type="hidden" name="name<?=$i?>" value="<?=$item->name?>"/>
                    <input type="hidden" name="category3_code<?=$i?>" value="<?=$item->nowinfo['category3_code']?>"/>
                    <input type="hidden" name="part_number<?=$i?>" value="<?=$item->nowinfo['part_number']?>"/>
                    <input type="hidden" name="stock_location<?=$i?>" value="<?=$item->nowinfo['stock_location']?>"/>
                    <input type="hidden" name="delivery_code<?=$i?>" value="<?=$item->nowinfo['delivery_code']?>"/>
                    <input type="hidden" name="leadtime<?=$i?>" value="<?=$item->nowinfo['leadtime']?>"/>
                    <input type="hidden" name="product_code<?=$i?>" value="<?=$item->nowinfo['product_code']?>"/>
                    <input type="hidden"  name="p_num<?=$i?>" value="<?=$item->qty?>"/>
                    <input type="hidden" name="price<?=$i?>" id="p_price<?=$i?>" class="p_price" value="<?=$item_price?>">

                    <tr>
                        <td><input id="pcheckbox"  type="checkbox" name="chk<?=$i?>" value="active<?=$i?>"></td>
                        <td><p class="prd-img">
                        <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                        </p></td>
                        <td>
                            <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                            </label></p>
                            <p class="col-blue font-sm"><?php echo $item->name;?></p>
                            <p class="prd-subject"><a href="<?=route_guest('sale.detail', $item->nowinfo['product_code'])?>"><?php echo $item->part_number;?></a></p>
                            <p class="prd-cmt col-gray font-sm"><a href="<?=route_guest('sale.detail', $item->nowinfo['product_code'])?>"><?=$item->nowinfo['product_code']?></a></p>
                            <p class="prd-option col-gray font-sm">
                                <?php
                                $brief_description = $item->nowinfo['brief_description'];
                                $prd_description = explode('|^|', $brief_description);
                                echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                ?>
                            </p>
                        </td>
                        <td><?=number_format($item_price)?>원</td>
                        <td><?php echo $item->qty;?> <button class="btn font-xsm btn-outline-white" type="button" onclick="edit_cart(<?php echo $item->inquiry_id;?>)">변경</button></td>
                        <td><?=number_format($amount_price)?>원</td>
                        <td><?=number_format($price_vat)?>원</td>
                        <td><?=number_format($total_price)?>원</td>
                        <td><button class="btn font-xsm btn-blue" type="button" onclick="delete_cart(<?php echo $item->inquiry_id;?>)">삭제</button></td>
                    </tr>

                    <?php
                    $all_qty = $all_qty + $item->qty;;
                    $all_amount_price = $all_amount_price + $amount_price;
                    $all_price_vat = $all_price_vat + $price_vat;
 
                    if ($deliverydays > $item->leadtime_info) {
                        $deliverydays = $deliverydays;
                    } else {
                        $deliverydays = $item->leadtime_info;
                    }

                    $i++;

                    }

                    $all_price = $all_amount_price + $all_price_vat;
                    $timestamp = strtotime($deliverydays."days");
                    ?>
                </tbody>
            </table>

            <input type="hidden" name="dataRow" value="<?=$i?>">
            
            <dl class="order_list_mobile">
                <dt>                    
                    <?php
                    $i = 1; 
                    $deliverydays = 0;
                    foreach($lists as $item_mobile){
                    ?>
                    <div class="prd-img">
                        <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                    </div>

                    <div class="prd-info">
                        <p><label class="badge_blue font-sm">
                            <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                            <?php endforeach; ?>
                        </label></p>                     
                        <p class="col-blue font-sm"><?=$item_mobile->name;?> <input id="pcheckbox"  type="checkbox" name="chk<?=$i?>" value="active<?=$i?>"></p>
                        <p class="prd-subject"><a href="<?=route_guest('sale.detail', $item->nowinfo['product_code'])?>"><?=$item_mobile->part_number;?></a> <button class="btn font-xsm btn-blue" type="button" onclick="delete_cart(<?php echo $item_mobile->inquiry_id;?>)">삭제</button></p>
                        <p class="prd-cmt col-gray font-sm"><a href="<?=route_guest('sale.detail', $item->nowinfo['product_code'])?>"><?=$item_mobile->nowinfo['product_code']?></a></p>
                        <p class="prd-option col-gray font-sm">
                                <?php
                                $brief_description = $item_mobile->nowinfo['brief_description'];
                                $prd_description = explode('|^|', $brief_description);
                                echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                ?>
                        </p>
                        <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                        <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                    </div>
                    <?php } ?>
                </dt>
                <dd class="bg-light-gray border-b">
                    <ul>
                        <li>상품개수</li> <li><?=$all_qty?>개</li>
                        <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                        <li>VAT</li> <li><?=number_format($all_price_vat)?>원</li>
                        <li>총 금액</li> <li><?=number_format($all_price)?>원</li>
                    </ul>
                </dd>
            </dl>

            <table class="table_style2 order_list_footer">
                <thead>
                    <tr>
                        <th>상품개수</th>
                        <th>공급가액</th>
                        <th>부가세(VAT)</th>
                        <th>총 금액(VAT포함)</th>                        
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?=$all_qty?>개</td>
                        <td><?=number_format($all_amount_price)?>원</td>
                        <td><?=number_format($all_price_vat)?>원</td>
                        <td><?=number_format($all_price)?>원</td>                        
                    </tr>                    
                </tbody>
            </table>

            </div>

            <div class="order-btn-box btn-box">        
                <!--a href="<?=route_guest('cart.printestimate')?>" class="btn font-xsm btn-outline-white float-l" title="견적서 출력">견적서 출력</a--> 
                <a onfocus=blur() href="javascript:void(window.open('<?=route_guest('cart.printestimate')?>','win0','width=1400,height=900,toolbar=no,titlebar=no,menubar=no,location=no'))" class="btn font-xsm btn-outline-white float-l" title="견적서 출력">견적서 출력</a> 
            </div>


        <div class="order-btn-box mt-3 mb-2"> </div>
        <!-- 주문수단 s -->
        <div class="border-button-box">
            <ul class="tabnav cartpay-btn">
                <li><button class="btn btn-blue ml-1" style="width: 100%;" type="button" onclick="return info_chk2(this.form);">선택주문</button></li>
                <li><button class="btn btn-blue ml-1" style="width: 100%;" type="button" onclick="return info_chk1(this.form);">전체주문</button></li>
                <li><button class="btn btn-blue ml-1" style="width: 100%;" type="button" onclick="return info_chk3(this.form);">견적요청</button></li>
            </ul>
            <!--button class="btn btn-lg btn-green btn-naver ml-1" style="width: 100%;">Pay 구매</button-->
        </div>

            <div class="prd_detail_top prd_info_wrap btn_wrap">

            <?php if ($device_type == "mobile") { ?>


                <!--script type="text/javascript" src="https://test-pay.naver.com/customer/js/mobile/naverPayButton.js" charset="UTF-8"></script-->
                <script type="text/javascript" src="https://pay.naver.com/customer/js/mobile/naverPayButton.js" charset="UTF-8"></script> <!--네이버페이상용-->
                <script type="text/javascript" >
                naver.NaverPayButton.apply({
                BUTTON_KEY:"0CD946C2-AA7D-49C0-B551-0DCC40759C2C", // 네이버페이에서 할당받은 버튼 KEY 를 입력하세요.
                TYPE: "MA", // 버튼 타입
                COLOR: 1,  // 버튼 색
                COUNT: 1, // 버튼 개수 설정. 구매하기 버튼만 있으면 1, 찜하기 버튼과 함께 있으면 2를 입력한다.
                ENABLE: "Y", // 품절 등의 이유로 버튼 모음을 비활성화할 때에는 "N" 입력
                BUY_BUTTON_HANDLER: jsNaverPay // 구매하기 버튼 이벤트 Handler 함수 등록, 품절인 경우 not_buy_nc 함수 사용
                });

                function jsNaverPay() {
                    swal({
                        icon: "<?=asset_public('images/npay_notice.png')?>",
                        buttons: ["취소", "확인"]
                    })
                    .then(function(result){
                        console.log(result);
                        
                        if(result){
                            var frm = document.getElementById("form-cart");
                                    frm.action='<?=route_guest('order.npay_cart')?>';
                                    frm.submit();
                        }
                    });

                }
                </script>

            <?php } else { ?>

                <!--script type="text/javascript" src="https://test-pay.naver.com/customer/js/naverPayButton.js" charset="UTF-8"></script-->
                <script type="text/javascript" src="https://pay.naver.com/customer/js/naverPayButton.js" charset="UTF-8"></script> <!--네이버페이상용-->
                <script type="text/javascript" >
                naver.NaverPayButton.apply({
                BUTTON_KEY:"0CD946C2-AA7D-49C0-B551-0DCC40759C2C", // 네이버페이에서 할당받은 버튼 KEY 를 입력하세요.
                TYPE: "A", // 버튼 타입
                COLOR: 1,  // 버튼 색
                COUNT: 1, // 버튼 개수 설정. 구매하기 버튼만 있으면 1, 찜하기 버튼과 함께 있으면 2를 입력한다.
                ENABLE: "Y", // 품절 등의 이유로 버튼 모음을 비활성화할 때에는 "N" 입력
                BUY_BUTTON_HANDLER: jsNaverPay // 구매하기 버튼 이벤트 Handler 함수 등록, 품절인 경우 not_buy_nc 함수 사용
                });

                function jsNaverPay() {
                    swal({
                        icon: "<?=asset_public('images/npay_notice.png')?>",
                        buttons: ["취소", "확인"]
                    })
                    .then(function(result){
                        console.log(result);
                        
                        if(result){
                            var frm = document.getElementById("form-cart");
                                    frm.action='<?=route_guest('order.npay_cart')?>';
                                    frm.submit();
                        }
                    });

                }
                </script>
                
            <?php } ?>

            </div>
        <!-- 주문수단 e -->

    </div>

    </form>
    <?php endif;?>

</section>
<!-- product details top info e -->
        
<!------------------------------------------------------------------------------------------------------------------->
<!------------------------------------------------------------------------------------------------------------------->

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
	$(function () {
        'use strict';
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });
</script>
<!------------------------------------------------------------------------------------------------------------------->
    <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
    <script src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js" type="text/javascript"></script>

    <script type="text/javascript">
    $(document).ready( function () {
        $('#table_id').DataTable();
    } );
        var save_method; //for save method string
        var table;

        function add_cart()
        {
        save_method = 'add';
        $('#form')[0].reset(); // reset form on modals
        $('#modal_form').modal('show'); // show bootstrap modal
        //$('.modal-title').text('Add Person'); // Set Manufacturer to Bootstrap modal title
        }
    
        function edit_cart(id)
        {
        save_method = 'update';
        $('#form')[0].reset(); // reset form on modals
        <?php header('Content-type: application/json'); ?>
        //Ajax Load data from ajax
        $.ajax({
            url:"<?=route_guest('cartmodify.cart_edit')?>" + id,
            type: "GET",
            dataType: "JSON",
            success: function(data)
            {
                console.log(data);
    
                $('[name="part_sequence"]').val(data.part_sequence);
                $('[name="inquiry_id"]').val(data.inquiry_id);
                $('[name="part_number"]').val(data.part_number);
                $('[name="name"]').val(data.name);
                $('[name="qty"]').val(data.qty);
                $('[name="price"]').val(data.price);
    
                $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('수량변경'); // Set title to Bootstrap modal title
    
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                console.log(jqXHR);
                alert('데이터를 전달할 수 없습니다.');
            }
        });
        }
    
        function save()
        {   
        var url;
        if(save_method == 'add')
        {
            url = "<?=route_guest('cartmodify.cart_add')?>";
        } else {
            url = "<?=route_guest('cartmodify.cart_update')?>";
        }
    
        // ajax adding data to database
            $.ajax({
                url : url,
                type: "POST",
                data: $('#form').serialize(),
                dataType: "JSON",

                success: function(jqXHR, data)
                {

                if (jqXHR.status == true) {

                    if (jqXHR.readyState == 200) {

                    // alert( jqXHR.status );
                    // alert( jqXHR.statusText );
                    // alert( jqXHR.responseText );
                    // alert( jqXHR.readyState );
                    //if success close modal and reload ajax table
                    $('#modal_form').modal('hide');
                    location.reload(); // for reload a page

                    } else {
                    // alert( jqXHR.status );
                    // alert( jqXHR.statusText );
                    alert( jqXHR.responseText );
                    // alert( jqXHR.readyState );
                    }

                } else {
                    // alert( jqXHR.status );
                    // alert( jqXHR.statusText );
                    alert( jqXHR.responseText );
                    // alert( jqXHR.readyState );
                }

                },

                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert( jqXHR.responseText );
                }
            });
        }
    
        function delete_cart(id)
        {
        if(confirm('이 데이터를 삭제하시겠습니까?'))
        {
            // ajax delete data from database
            $.ajax({
                url:"<?=route_guest('cartmodify.cart_delete')?>"+id,
                type: "POST",
                dataType: "JSON",
                success: function(data)
                {
                    
                location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    var err_msg = jqXHR.status;

                    alert('데이터 삭제 에러'+err_msg);
                }
            });
    
        }
        }
    </script>
    
    <!-- Bootstrap modal -->
    <div class="modal fade" id="modal_form" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
            <h3 class="modal-title">Cart Form</h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <div class="modal-body form">
            <form action="#" id="form" class="form-horizontal">
            <input type="hidden" value="" name="inquiry_id"/>
            <div class="form-body">
                <div class="form-group">
                    <input name="part_sequence" placeholder="Part Sequence" class="form-control" type="hidden">
                    <div class="form-group">
                    <label class="control-label col-md-3">제품명</label>
                    <div class="col-md-9">
                        <input name="part_number" placeholder="Part Number" disabled class="form-control" type="text">
                    </div>
                    </div>
                    <div class="form-group">
                    <label class="control-label col-md-3">브랜드</label>
                    <div class="col-md-9">
                        <input name="name" placeholder="Manufacturer" disabled class="form-control" type="text">
                    </div>
                    </div>
                    <!--div class="form-group">
                    <label class="control-label col-md-3">단가</label>
                    <div class="col-md-9">
                        <input name="price" placeholder="Price" disabled class="form-control" type="text">
                    </div>
                    </div-->
                    <div class="form-group">
                    <label class="control-label col-md-3">변경수량</label>
                    <div class="col-md-9">
                            <input name="qty" placeholder="Quantity" class="form-control" type="text">
                    </div>
                    </div>
                </div>
            </div>
            </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="btnSave" onclick="save()" class="btn btn-primary">수정</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">취소</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <!-- End Bootstrap modal -->

    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {        
            <?php if(session()->getFlashdata('status')) {?>
                swal({
                    title: "<?=session()->getFlashdata('status')?>",
                    text: "<?=session()->getFlashdata('status_text')?>",
                    icon: "<?=session()->getFlashdata('status_icon')?>",
                    buttons: "확인"
                });
            <?Php } ?>
        });
    </script>

<?= $this->endSection() ?>