<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?php
// 이니시스페이 설정
require_once('inicis/libs/INIStdPayUtil.php');
$SignatureUtil = new INIStdPayUtil();

// 상용키
$mid 			= "chipdire24";  							// 상점아이디			
$signKey 		= "c08zTkVWL3ZHSEZSQVl6bCswZEovUT09"; 		// 웹 결제 signkey
$our_siteadd    = "https://chipdirect.co.kr";                  // 상점 사이트주소

// 테스트키
// $mid 			= "INIpayTest";  							// 상점아이디			
// $signKey 		= "SU5JTElURV9UUklQTEVERVNfS0VZU1RS"; 		// 웹 결제 signkey
// $our_siteadd    = "http://localhost";                       // 테스트 사이트주소

$mKey 	= $SignatureUtil->makeHash($signKey, "sha256");
$timestamp 		= $SignatureUtil->getTimestamp();   			// util에 의해서 자동생성
$orderNumber 	= "ORD_INI_" . $timestamp; 				    // 가맹점 주문번호(가맹점에서 직접 설정)

/*
$price 			= "1000";        								// 상품가격(특수기호 제외, 가맹점에서 직접 설정)
$params = array(
    "oid" => $orderNumber,
    "price" => $price,
    "timestamp" => $timestamp
);
$sign   = $SignatureUtil->makeSignature($params);
*/

// 이니시스페이 설정 끝
?>

<?= $this->section('head.title') ?>
    <?=lang_cart('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('cart.js')?>"></script>
    <script>
        $("input[type='number']").inputSpinner();
        CartJS.init();
    </script>

    <script language="javascript" type="text/javascript">
        var name = "";
        var phone = "";
        function InitValue(frm){
            name = frm.orderer_name.value;
            phone = frm.orderer_phone.value;
        }

        function ShipToBill(frm){		
            if(frm.agree.checked){
                InitValue(frm);			//현재 텍스트박스와 체크박스의 상태유지
                document.getElementById("shipping_name").value = document.getElementById("orderer_name").value;
                document.getElementById("shipping_phone").value = document.getElementById("orderer_phone").value;
                frm.chkDeliveryEmail.checked = phone;
            }else{						//체크박스를 해제한다면
                frm.shipping_name.value="";
                frm.shipping_phone.value="";
            }

        } 
    </script>

    <!------------- // 이니시스페이 설정 ------------>
    <!------------- // 이니시스페이 설정 ------------>

    <script language="javascript" type="text/javascript">
        var dataRow = "";
        var inquiry_code = "";
        var inquiry_id_all = "";
        var firstitem_code = "";
        var firstitem_number = "";
        var firstitem_image = "";
        var item_counts = "";
        var supply_price = "";
        var vat = "";
        var delivery_fee = "";
        var amount_total = "";
        var order_code = "";
        var orderer_name = "";
        var orderer_email = "";
        var orderer_phone = "";
        var shipping_name = "";
        var shipping_phone = "";
        var delivery_phone = "";
        var shipping_zipocode = "";
        var shipping_add1 = "";
        var shipping_add2 = "";
        var shipping_message = "";
        var notice = "";
        var invoice_com = "";
        var invoice_biznum = "";
        var invoice_ceo = "";
        var gopaymethod = "";
        var member_code = "";
        var selectinfo = "";
        var company_name = "";
        var delivery_date = "";
        function InitValue(frm){
            dataRow = document.getElementById("dataRow").value;
            inquiry_code = document.getElementById("inquiry_code").value;
            inquiry_id_all = document.getElementById("inquiry_id_all").value;
            firstitem_code = document.getElementById("firstitem_code").value;
            firstitem_number = document.getElementById("firstitem_number").value;
            firstitem_image = document.getElementById("firstitem_image").value;
            item_counts = document.getElementById("item_counts").value;
            supply_price = document.getElementById("supply_price").value;
            vat = document.getElementById("vat").value;
            delivery_fee = document.getElementById("delivery_fee").value;
            amount_total = document.getElementById("amount_total").value;
            orderer_code = document.getElementById("order_code").value;
            orderer_name = document.getElementById("orderer_name").value;
            orderer_name_encode = encodeURI(orderer_name);
            orderer_email = document.getElementById("orderer_email").value;
            orderer_phone = document.getElementById("orderer_phone").value;
            shipping_name = document.getElementById("shipping_name").value;
            shipping_name_encode = encodeURI(shipping_name);
            shipping_phone = document.getElementById("shipping_phone").value;
            delivery_phone = document.getElementById("delivery_phone").value;
            company_name = document.getElementById("company_name").value;
            company_name_encode = encodeURI(company_name);
            shipping_zipocode = document.getElementById("shipping_zipocode").value;
            shipping_add1 = document.getElementById("shipping_add1").value;
            shipping_add1_encode = encodeURI(shipping_add1);
            shipping_add2 = document.getElementById("shipping_add2").value;
            shipping_add2_encode = encodeURI(shipping_add2);
            shipping_message = document.getElementById("shipping_message").value;
            shipping_message_encode = encodeURI(shipping_message);
            notice = document.getElementById("notice").value;
            notice_encode = encodeURI(notice);
            invoice_com = document.getElementById("invoice_com").value;
            invoice_com_encode = encodeURI(invoice_com);
            invoice_biznum = document.getElementById("invoice_biznum").value;
            invoice_biznum_encode = encodeURI(invoice_biznum);
            invoice_ceo = document.getElementById("invoice_ceo").value;
            invoice_ceo_encode = encodeURI(invoice_ceo);
            gopaymethod = document.getElementById("gopaymethod").value;
            member_code = document.getElementById("member_code").value;
            selectinfo = document.getElementById("selectinfo").value;
            delivery_date = document.getElementById("delivery_date").value;
        }

        function ShipToMerchant(frm){
            if(frm.agree1.checked){
                InitValue(frm);			//현재 텍스트박스와 체크박스의 상태유지 한글 입력불가, 한글입력은 urlencode 필수
                document.getElementById("merchantData").value = "dataRow="+dataRow+"|inquiry_code="+inquiry_code+"|inquiry_id_all="+inquiry_id_all+"|firstitem_code="+firstitem_code+
                "|firstitem_number="+firstitem_number+"|firstitem_image="+firstitem_image+"|item_counts="+item_counts+"|supply_price="+supply_price+"|vat="+vat+"|delivery_fee="+delivery_fee+"|amount_total="+amount_total+
                "|order_code="+orderer_code+"|orderer_name="+orderer_name_encode+"|orderer_email="+orderer_email+"|orderer_phone="+orderer_phone +"|shipping_name="+shipping_name_encode+
                "|shipping_phone="+shipping_phone+"|delivery_phone="+delivery_phone+"|company_name="+company_name_encode+"|shipping_zipocode="+shipping_zipocode+"|shipping_add1="+shipping_add1_encode+"|shipping_add2="+shipping_add2_encode+
                "|shipping_message="+shipping_message_encode+"|notice="+notice_encode+"|invoice_com="+invoice_com_encode+"|invoice_biznum="+invoice_biznum_encode+"|invoice_ceo="+invoice_ceo_encode+
                "|gopaymethod="+gopaymethod+"|member_code="+member_code+"|selectinfo="+selectinfo+"|delivery_date="+delivery_date;
            }
        }
    </script>


	<link rel="stylesheet" href="<?=asset_guest_css('inicis.css')?>">

	<!--테스트 JS><script language="javascript" type="text/javascript" src="https://stgstdpay.inicis.com/stdjs/INIStdPay.js" charset="UTF-8"></script-->
	<!--운영 JS-->
    <script language="javascript" type="text/javascript" src="https://stdpay.inicis.com/stdjs/INIStdPay.js" charset="UTF-8"></script>
    
    <script type="text/javascript">
        function paybtn() {
            var orderer_name = document.getElementById("orderer_name");
                if (orderer_name.value == "") {
                    alert("주문하는 분 이름을 입력하세요.");
                    orderer_name.focus();
                    return false;
                };
            var orderer_email = document.getElementById("orderer_email");
                if (orderer_email.value == "") {
                    alert("주문하는 분 E-MAIL을 입력하세요.");
                    orderer_email.focus();
                    return false;
                };
            var orderer_phone = document.getElementById("orderer_phone");
                if (orderer_phone.value == "") {
                    alert("주문하는 분 전화번호를 입력하세요.");
                    orderer_phone.focus();
                    return false;
                };
            var shipping_name = document.getElementById("shipping_name");
                if (shipping_name.value == "") {
                    alert("받는 분 이름을 입력하세요.");
                    shipping_name.focus();
                    return false;
                };
            var shipping_phone = document.getElementById("shipping_phone");
                if (shipping_phone.value == "") {
                    alert("받는 분 휴대 전화번호를 입력하세요.");
                    shipping_phone.focus();
                    return false;
                };
            var shipping_zipocode = document.getElementById("shipping_zipocode");
                if (shipping_zipocode.value == "") {
                    alert("배송지 우편번호를 입력하세요.");
                    shipping_zipocode.focus();
                    return false;
                };
            var shipping_add1 = document.getElementById("shipping_add1");
                if (shipping_add1.value == "") {
                    alert("배송지 주소를 입력하세요.");
                    shipping_add1.focus();
                    return false;
                };
            var agree1 = document.getElementById("agree1");
                if (!agree1.checked) { //체크박스 미체크시
                    alert("전자상거래법 제8조2항에 동의를 체크하세요.");
                    agree1.focus();
                    return false;
                }

            INIStdPay.pay('SendPayForm_id');
        }
    </script>
<!------------- // 이니시스페이 설정 끝 ------------>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb') ?>
    <?php $breadcrumb->render('guest.cart')?>
<?= $this->endSection() ?>


<?= $this->section('content') ?>
<!--#siteMain-->
<section class="sub_wrap">
<!------------------------------------------------------------------------------------------------------------------->
        
<div class="content_wrap">
        <div class="d-flex">
            <div class="row align-l">
                <h2 class="mb-0 pb-0">주문/결제</h2>
                <p class="font-xsm col-gray">주문/결제 정보를 정확히 입력해 주세요.</p>
            </div>
        </div>

        <div class="cart_flow mb-2">
            <div class="flow cartFlow_1second">01 장바구니</div>
            <div class="flow cartFlow_2second">02 주문/결제</div>
            <div class="flow cartFlow_3second">03 주문완료</div>
        </div>


        <div class="border-light-box">
            <div class="sub_title d-flex">총 결제 금액 : <?=number_format($price)?>원 (VAT포함)</div>

            <div class="form-gp">
                <div class="d-flex g-1">
                    <label for="">결제수단정보</label>
                    <?php
                        if ($payment_flg == "Card") {
                            echo "이니페이 신용카드";
                        } elseif ($payment_flg == "Directbank") {
                            echo "이니페이 실시간이체";
                        } elseif ($payment_flg == "vbank") {
                            echo "이니페이 가상계좌";
                        } elseif ($payment_flg == "onlynaverpay") {
                            echo "이니페이 네이버페이";
                        } elseif ($payment_flg == "onlynaverpay") {
                            echo "이니페이 카카오페이";
                        } else {
                            echo "이니페이 신용카드";
                        }
                    ?>
                </div>                
            </div>

        </div>

    <form name="" id="SendPayForm_id" method="post" class="mt-5">

        <?php $i = 1; ?>
        <?php foreach ($lists as $key => $item): ?>

        <input  type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
        <input  type="hidden" name="manufacturer_name<?=$i?>" value="<?=$item->name?>"/>
        <input  type="hidden" name="part_number<?=$i?>" value="<?=$item->nowinfo['part_number']?>"/>
        <input  type="hidden" name="stock_location<?=$i?>" value="<?=$item->nowinfo['stock_location']?>"/>
        <input  type="hidden" name="delivery_code<?=$i?>" value="<?=$item->nowinfo['delivery_code']?>"/>
        <input  type="hidden" name="item_code<?=$i?>" value="<?=$item->nowinfo['product_code']?>"/>
        <input  type="hidden" name="part_category3<?=$i?>" value="<?=$item->nowinfo['part_category3']?>"/>

        <?php 
        $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.",";
        $item_price = $item->price;
        $amount_price = $item_price * $item->qty;
        $price_vat = $amount_price*0.1;
        $total_price = $amount_price+$price_vat;
        ?>
        <input  type="hidden" name="price<?=$i?>" value="<?=$item_price?>"/>
        <input  type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
        <input  type="hidden" name="supply_price<?=$i?>" value="<?=$amount_price?>"/>
        <input  type="hidden" name="vat<?=$i?>" value="<?=$price_vat?>"/>
        <input  type="hidden" name="amount<?=$i?>" value="<?=$total_price?>"/>

        <?php

        //$inistgoodname = count($lists)."개 품목";

        if ($i > 1) {
            $inistgoodname = $item->nowinfo['product_code']." 외 ".count($lists)."개 품목";
        } else {
            $inistgoodname = $item->nowinfo['product_code'];
        }

        
        if ($deliverydays > $item->leadtime_info) {
            $deliverydays = $deliverydays;
        } else {
            $deliverydays = $item->leadtime_info;
        }

        if ($delivery_prices > $item->delivery_price) {
            $delivery_prices = $delivery_prices;
        } else {
            $delivery_prices = $item->delivery_price;
        }

            $all_amount_price = $all_amount_price + $amount_price;
            $all_price_vat = $all_price_vat + $price_vat;
            $i++; 

        endforeach;

        $delivery_free_standard = 30000; // 배송료무료 기준설정
        if ($all_amount_price > $delivery_free_standard) {
            $delivery_prices = 0;
        }
        
        $all_order_total = $all_amount_price + $all_price_vat + $delivery_prices;
        $deliverytime = strtotime($deliverydays."days");

        ?>

            <input type="hidden" id="inquiry_id_all" name="inquiry_id_all" value="<?=$inquiry_id_all?>">
            <input type="hidden" id="dataRow" name="dataRow" value="<?=$i?>">
            <input type="hidden" id="delivery_date" name="delivery_date" value="<?php echo  date("Y-m-d", $deliverytime);?>">
            <input type="hidden" id="firstitem_code" name="firstitem_code" value="<?=$lists[0]->part_sequence?>">

            <input type="hidden" id="firstitem_image" name="firstitem_image" value="<?=$lists[0]->nowinfo['image_dir']?>">
            <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">
            <input type="hidden" id="supply_price" name="supply_price" value="<?=$all_amount_price?>"/>
            <input type="hidden" id="vat" name="vat" value="<?=$all_price_vat?>"/>
            <input type="hidden" id="delivery_fee" name="delivery_fee" value="<?=$delivery_prices?>"/>
            <input type="hidden" id="amount_total" name="amount_total" value="<?=round($all_order_total)?>"/>

            <input type="hidden" id="inquiry_code" name="inquiry_code" value="<?=$inquiry_code?>">
            <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$firstitem_number?>">

        <?php 

        $params = array(
            "oid" => $orderNumber,
            "price" => $price,
            "timestamp" => $timestamp
        );
        
        $sign = $SignatureUtil->makeSignature($params);
        ?>
    
        <input type="hidden" id="order_code" name="order_code" value="<?=$orderNumber?>"/>
        <input type="hidden" id="selectinfo" name="selectinfo" value="<?=$selectinfo?>"/>

        <!-- 주문자 정보 s -->
        <div class="border-light-box">
            <div class="sub_title d-flex">주문자 정보</div>
            <div class="form-gp">
                <div class="d-flex g-1">
                <label for="">주문자</label><?=$buyername?>
                    <input id="orderer_name" type="hidden" name="buyername" value="<?=$buyername?>"/>
                    <input id="member_code" type="hidden" name="member_code" value="<?=$member_code?>"/>
                </div>                
            </div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for="">휴대폰</label><?=$buyertel?>
                    <input id="orderer_phone" type="hidden" name="buyertel" value="<?=$buyertel?>"/>
                </div>
                <div class="d-flex g-2">
                    <label for="">이메일</label><?=$buyeremail?>
                    <input id="orderer_email" type="hidden" name="buyeremail" value="<?=$buyeremail?>"/>
                </div>
            </div>
        </div>
        <!-- 주문자 정보 e -->

        <!-- 배송지 정보 s -->
        <div class="border-light-box">
            <div class="sub_title d-flex">배송지 정보</div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for="">받는분</label><?=$shipping_name?>
                    <input id="shipping_name" type="hidden" class="form-control" name="shipping_name"  value="<?=$shipping_name?>"/>
                </div>
                <div class="d-flex g-2">
                    <label for="">회사명</label><?=$company_name?>
                    <input id="company_name" type="hidden" name="company_name" value="<?=$company_name?>"/>
                </div>
            </div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for="">휴대폰</label><?=$shipping_phone?>
                    <input id="shipping_phone" type="hidden" class="form-control" name="shipping_phone" value="<?=$shipping_phone?>"/>
                </div>
                <div class="d-flex g-2">
                    <label for="">전화번호</label><?=$shipping_phone?>
                    <input id="delivery_phone" type="hidden" class="form-control" name="shipping_phone" value="<?=$shipping_phone?>"/>
                </div>
            </div>
            <div class="form-gp">
                        <?php
                        if ($usersubinfo->com_zipcode) {
                            $user_zipcode = $usersubinfo->com_zipcode;
                        } else {
                            $user_zipcode = $userinfo->member_zipcode;
                        }

                        if ($usersubinfo->com_address1) {
                            $user_address1 = $usersubinfo->com_address1;
                        } else {
                            $user_address1 = $userinfo->member_address1;
                        }

                        if ($usersubinfo->com_address2) {
                            $user_address2 = $usersubinfo->com_address2;
                        } else {
                            $user_address2 = $userinfo->member_address2;
                        }
                        ?>
                <div class="d-flex g-1">
                    <label for="">배송주소</label>[<?=$shipping_zipocode?>] <?=$shipping_add1?> <?=$shipping_add2?>
                    <input id="shipping_zipocode" type="hidden" name="shipping_zipocode" value="<?=$shipping_zipocode?>"/>
                    <input id="shipping_add1" type="hidden" name="shipping_add1" value="<?=$shipping_add1?>"/>
                    <input id="shipping_add2" type="hidden" name="shipping_add2" value="<?=$shipping_add2?>"/>
                </div>                
            </div>
            <div class="form-gp">
                <div class="d-flex g-1">
                    <label for="">메시지</label><?=$shipping_message?>
                    <input id="shipping_message" type="hidden" name="shipping_message" value="<?=$shipping_message?>"/>
                </div> 
            </div>
        </div>
        <!-- 배송지 정보 e -->

        <!-- 계산서 발행 s -->
            <input id="invoice_com" type="hidden" name="invoice_com" value="<?=$invoice_com?>"/>
            <input id="invoice_biznum" type="hidden" name="invoice_biznum" value="<?=$invoice_biznum?>"/>
            <input id="invoice_ceo" type="hidden" name="invoice_ceo" value="<?=$invoice_ceo?>"/>
            <input id="notice" type="hidden" name="notice" value="<?=$notice?>"/>
        <!-- 계산서 발행 e -->

            <input id="gopaymethod" type="hidden" name="gopaymethod" value="<?=$payment_flg?>">
            <input type="hidden" name="version" value="1.0">
            <input type="hidden" name="merchantData" id="merchantData">
            <input type="hidden" name="mid" value="<?php echo $mid ?>">
            <input type="hidden" name="oid" value="<?php echo $orderNumber ?>">
            <input type="hidden" name="price" value="<?php echo $price ?>">
            <input type="hidden" name="goodname" value="전자부품(<?php echo $inistgoodname ?>)">           
			<input type="hidden" name="timestamp" value="<?php echo $timestamp ?>">
            <input type="hidden" name="signature" value="<?php echo $sign ?>">
			<input type="hidden" name="mKey" value="<?php echo $mKey ?>">
            <input type="hidden" name="currency" value="WON">
			<input type="hidden" name="returnUrl" value="<?php echo $our_siteadd ?>/cart/inistdpayreturn">
            <input type="hidden" name="closeUrl" value="<?php echo $our_siteadd ?>/cart/inistdpayclose">
            <input type="hidden" name="acceptmethod" value="HPP(1):below1000:va_receipt:cardonly:useescrow:SKIN(#007AB9)">
            
        <!--  이용 약관 s -->
        <div class="border-light-box order-form">
            <div class="order_guideWrap mb56">
                <div class="order_guideinput" style="text-align: left;">
                    <input type="checkbox" id="agree1" name="agree1" onclick="ShipToMerchant(this.form);" required/>
                    <label for=""><b>(전자상거래법 제8조2항) 결제할 서비스 내용을 확인하였으며 구매에 동의합니다.<span class="text-danger">(*)</span></b></label>
                </div>
            </div>
        </div>
        <!--  이용 약관 e -->
        </form>

    </div>

    <div class="order-btn-box btn-lg-box btn-box align-c">
        <a href="<?=route_guest('cart')?>" class="btn btn-lg btn-outline-white w-20">장바구니로</a>
        <button class="btn btn-lg btn-blue w-20 ml-1" onclick="paybtn()">결제하기</button>
    </div>

</section>
<!-- product details top info e -->
<!------------------------------------------------------------------------------------------------------------------->

<script src="//t1.daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js"></script>
    <script>
        function sample6_execDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add2").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add2").value = '';
                    }
                    document.getElementById('shipping_zipocode').value = data.zonecode;
                    document.getElementById("shipping_add1").value = addr;
                    document.getElementById("shipping_add2").focus();
                }
            }).open();
        }
    </script>

<?= $this->endSection() ?>
