<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_contact('inquiry')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#regulation').on('scroll', function () {
                regulationScroll();
            });
            $('#agree').on('change',function () {
                if($(this).is(":checked")){
                    $('#btn-submit').removeAttr('disabled');
                }else{
                    $('#btn-submit').attr('disabled','disabled');
                }
            });
            regulationScroll();
        });
        function regulationScroll() {
            let offset = 50;
            let regulation = $('#regulation');
            let top = regulation.offset().top;
            let height = regulation.height()
            let bottom = top + height
            if(bottom <= top + height){
                $('#agree').removeAttr('disabled');
            }else{
                if (regulation.scrollTop()  >= $('#regulation').height() - offset) {
                    $('#agree').removeAttr('disabled');
                }
            }
        }
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <!--#siteHeroBanner-->
    <!--div id="carouselHero" class="carousel carousel-hero-banner" data-ride="carousel">
        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="<?=asset_public('images/products/hero-banner.jpg')?>" class="d-block w-100" alt="...">
                <div class="carousel-caption d-none d-md-block">
                    <h5>First slide label</h5>
                    <p>Nulla vitae elit libero, a pharetra augue mollis interdum.</p>
                </div>
            </div>
        </div>
    </div-->
    <!--/#siteHeroBanner-->

    <!--#Breadcrumb-->
    <?=$breadcrumb->render('guest.contact.inquiry')?>

    <section id="siteMain" class="site-main">
        <div class="container">
            <div class="form form-contact mb-5">
                <h2 class="form-title"><?=lang_contact('inquiry')?></h2>
                <?php if($session->has('message')): ?>
                    <div class="alert alert-success">
                        <?=$session->get('message')?>
                    </div>
                <?php endif;?>

                <form id="form" action="<?=route_guest('contact.inquiry.create')?>" method="post">
                    <div class="form-group">
                        <label class="form-label" for="name">
                            <?=lang_contact('inquiry_name')?>
                            <code>*</code>
                        </label>
                        <input id="name" type="text" class="form-control" name="name" value="<?=old_value('name', $memberName)?>"
                               placeholder="<?=lang_contact('inquiry_name')?>" aria-describedby="name"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="email">
                            <?=lang_contact('inquiry_email')?>
                            <code>*</code>
                        </label>
                        <input id="email" type="email" class="form-control" name="email" value="<?=old_value('email',$memberEmail)?>"
                               placeholder="<?=lang_contact('inquiry_email')?>" aria-describedby="email"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="tel">
                            <?=lang_contact('inquiry_tel')?>
                            <code>*</code>
                        </label>
                        <input id="tel" type="tel" class="form-control" name="tel" value="<?=old('tel',$memberPhone)?>"
                               placeholder="<?=lang_contact('inquiry_tel')?>"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="inquiry_title">
                            <?=lang_contact('inquiry_title')?>
                            <code>*</code>
                        </label>
                        <input id="title" type="text" class="form-control" name="title" value="<?=old('title')?>"
                               placeholder="<?=lang_contact('inquiry_title')?>" aria-describedby="title"/>
                    </div>
                    <div class="form-group">
                        <label class="form-label" for="memo_content">
                            <?=lang_contact('inquiry_memo')?>
                            <code>*</code>
                        </label>
                        <textarea id="memo_content" class="form-control" name="memo_content"
                                  placeholder="<?=lang_contact('inquiry_memo')?>" rows="5"></textarea>
                    </div>
                    <div class="form-group">
                        <textarea id="regulation" class="form-control" rows="5">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Atque, exercitationem inventore labore neque qui quos repellat unde vero? Dolorem eligendi ipsa odit officia vel? Accusamus culpa dolores molestiae nulla</textarea>
                    </div>
                    <div class="form-group">
                        <div class="form-check">
                            <input disabled <?=!empty(old('agree')) ? 'checked': ''?> class="form-check-input" type="checkbox" name="agree" value="1" id="agree">
                            <label class="form-check-label" for="agree"><?=lang_contact('inquiry_label_checked')?></label>
                        </div>
                    </div>

                    <div class="form-action">
                        <button type="submit" class="btn btn-submit btn-login w-100" id="btn-submit" disabled name="submit">
                            <?=lang_contact('inquiry_send')?>
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </section>
<?= $this->endSection() ?>
