<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_contract('title_pcbsmt')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<style>
    .box {
        border: 1px solid rgb(142, 141, 141);
        margin: 0 auto;
        padding: 15px;
        width: 100%;
        border-radius: 10px;
        background: rgb(255, 255, 255);
        box-shadow: 3px 3px 6px 3px rgb(154, 154, 154);
    }
    .text {
        margin: 0;
        text-align: left;
        font-size: 25px;
        color:rgb(0, 0, 0);
    }

    .text2 {
        margin: 0;
        text-align: left;
        font-size: 20px;
        color:rgb(0, 0, 0);
    }

</style>

<!--#siteMain-->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
                <li><a href="#"><?=lang_contract('title_pcbsmt')?></a></li>                
            </ul>            
        </nav>

                <!-- 내역 s -->
        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_contract('title_pcbsmt')?></div>
                <table border="0" width="100%">
                    <tr>
                        <td width="100%" align="center">
                            <p style='font-size: 25px;'>PCB/PCBA 제조</p><br>
                            당사는 인쇄 회로 기판(PCB)과 인쇄 회로 기판 조립(PCBA) 생산을 전문으로 합니다.
                        </td>
                    </tr>
                </table>

            <div class="form-gp">
                <div class="d-flex g-2">
                    <div class="box">
                    <p class="text">PCB 제조</p>
                    <img src="<?=asset_public('images/pcbsmt/img01.png')?>">
                    </div> 
                </div>                
                <div class="d-flex g-2">
                    <div class="box">
                    <p class="text">구성 요소 소싱</p>
                    <img src="<?=asset_public('images/pcbsmt/img02.png')?>">
                    </div> 
                </div>                
            </div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <div class="box">
                    <p class="text">PCB 조립</p>
                    <img src="<?=asset_public('images/pcbsmt/img03.png')?>">
                    </div> 
                </div>                
                <div class="d-flex g-2">
                    <div class="box">
                    <p class="text">커스텀 케이블</p>
                    <img src="<?=asset_public('images/pcbsmt/img04.png')?>">

                    <p class="text">전면패널</p>
                    <img src="<?=asset_public('images/pcbsmt/img05.png')?>">
                    </div> 
                </div>                
            </div>


            <table border="0" width="100%">
                    <tr>
                        <td width="100%" align="center">
                            <p style='font-size: 25px;'>PCB 제작: PCB 프로토타입 및 배치 주문</p>
                        </td>
                    </tr>
                </table>

            <div class="form-gp">
                <div class="d-flex g-3">
                    <div class="box" style='height:300px;'>
                    <img src="<?=asset_public('images/pcbsmt/img06_1.png')?>">
                    <p class="text">FR-4 PCB</p>
                    <br>
                        <div style='text-align: left;'>
                        우리는 정품 A등급 재료를 사용하고, 1-32개 레이어와 제어된 임피던스를 지원합니다. 가격은 5개당 $2부터 시작하며, 빌드 시간은 24시간입니다.
                        </div> 
                    </div> 
                </div>                
                <div class="d-flex g-3">
                    <div class="box" style='height:300px;'>
                    <img src="<?=asset_public('images/pcbsmt/img06_2.png')?>">
                    <p class="text">플렉스 PCB</p>
                    <br>
                        <div style='text-align: left;'>
                        유연성이 좋고 밀도가 높으며 Pl, FR4, 3M 테이프 강화재를 지원합니다. 가격은 5개당 $2부터 시작하며 제작 시간은 4일부터입니다.
                        </div> 
                    </div> 
                </div>
                <div class="d-flex g-3">
                    <div class="box" style='height:300px;'>
                    <img src="<?=asset_public('images/pcbsmt/img06_3.png')?>">
                    <p class="text">알루미늄 PCB</p>
                    <br>
                        <div style='text-align: left;'>
                        열전도성과 전기 절연성이 좋으며, 일반적으로 LED 분야에 사용됩니다.
                        </div> 
                    </div> 
                </div>                
            </div>
            <div class="form-gp">
                <div class="d-flex g-3">
                    <div class="box" style='height:300px;'>
                    <img src="<?=asset_public('images/pcbsmt/img06_4.png')?>">
                    <p class="text">구리 PCB</p>
                    <br>
                        <div style='text-align: left;'>
                        그 특성은 높은 열전도도 및 방열성, 고전력 공급이며 주로 LED에 사용됩니다.
                        </div> 
                    </div> 
                </div>                
                <div class="d-flex g-3">
                    <div class="box" style='height:300px;'>
                    <img src="<?=asset_public('images/pcbsmt/img06_5.png')?>">
                    <p class="text">로저스 PCB</p>
                    <br>
                        <div style='text-align: left;'>
                        낮은 소산율, 견고한 치수 안정성, 고주파 응용 분야 등.
                        </div> 
                    </div> 
                </div>
                <div class="d-flex g-3">
                    <div class="box" style='height:300px;'>
                    <img src="<?=asset_public('images/pcbsmt/img06_6.png')?>">
                    <p class="text">PTFE 테프론 PCB</p>
                    <br>
                        <div style='text-align: left;'>
                        낮은 소산율, 고온 및 고주파 응용 분야에 적합합니다.
                        </div> 
                    </div> 
                </div>                
            </div>


            <table border="0" width="100%">
                <tr>
                    <td width="100%" align="center">
                        <p style='font-size: 25px;'>PCB 조립</p>
                    </td>
                </tr>
            </table>

            <div class="box">
                <div class="form-gp">
                    <div class="d-flex g-2"  style='padding: 20px; text-align: left;'>
                    당사는 SMT(표면 실장 기술) 및 THT(스루홀 기술)를 지원합니다.<br>
                    당사의 인쇄 회로 기판 조립에는 단면 장착과 양면 장착이 포함됩니다.<br>
                    당사는 560,000개 이상의 부품을 재고로 보유하고 있으며, 리지드 보드와 플렉스 보드의 조립을 지원합니다.<br>
                    PCBA 가격은 5개당 8달러부터 시작하며 제작 시간은 24시간입니다.<br>
                    </div>
                    <div class="d-flex g-2">
                    <img src="<?=asset_public('images/pcbsmt/img07.png')?>">    
                    </div>        
                </div>
            </div> 

            <div class="form-gp">
                <div class="d-flex g-3">
                    <div class="box" style='height:250px;'>
                    <p class="text2">01. PCB 조립라인:</p>
                        <br>
                        <div style='text-align: left;'>
                        우리 공장에는 약 100명의 전문가가 있습니다.<br>
                        PCB  조립 라인은 첨단 기술을 활용합니다.<br>
                        야마하 12헤드 고속 자동 배치 머신.<br>
                        </div> 
                    </div> 
                </div>                
                <div class="d-flex g-3">
                    <div class="box" style='height:250px;'>
                    <p class="text2">02. PCB 조립 라인에는 다음이 장착되어 있습니다.</p>
                        <br>
                        <div style='text-align: left;'>
                        자동 보드 로더<br>
                        자동 솔더 페이스트 프린터<br>
                        AOI(자동 광학 검사) 기계<br>
                        X-RAY 검사기 등<br>
                        </div> 
                    </div> 
                </div>
                <div class="d-flex g-3">
                    <div class="box" style='height:250px;'>
                    <p class="text2">03. PCBA의 고급 옵션은 다음과 같습니다.</p>
                        <br>
                        <div style='text-align: left;'>
                        사진확인<br>
                        커포멀 코팅<br>
                        보드 청소<br>
                        베이크 구성 요소<br>
                        배송 전 디 패널 보드 및 에지 레일<br>
                        비행 프로브 시험 등<br>
                        </div> 
                    </div> 
                </div>                
            </div>

            <table border="0" width="100%">
                <tr>
                    <td width="100%" align="center">
                        <p style='font-size: 25px;'>PCB 조립 제조 공정</p>
                    </td>
                </tr>
            </table>

            <div class="box">
                <div class="form-gp">
                    <img src="<?=asset_public('images/pcbsmt/img08.png')?>">           
                </div>
            </div> 

        </div>
        <!-- 내역 e -->

<!------------------------------------------------------------------------------------------------------------------->
    </div>
</section>
<?= $this->endSection() ?>
