<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
<?=lang_deferredpay('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <!--#siteMain-->


    <section id="siteMain" class="site-main">

    <style>
        .news-detail .item .title {
            text-align: center;
            /*text-transform: uppercase;*/
            background-color: #ddd;
            padding: 10px;
        }
        .news-detail .item .content{
            padding: 10px;
        }
        .news-detail div.row.item{
            border: #E6E6E6 1px solid;
            margin: 0 auto;
        }
        .step-news-detail{
            color: #b00020;
        }
        .news-detail div.row.button{
            padding: 10px;
        }
        .content .hit{
            padding-left: 10px;
        }
    </style>
    <div class="container">
        <!--h6 class="step-news-detail">List <i class="fas fa-angle-right"></i> Detail </h6-->

    <div class="sub07Wrap">
        <div class="wrap">
            
            <div class="subWrap01Top">
                <div class="sub_category">
                    <div class="sub_categoryName">
                        <p>HOME > <?=lang_deferredpay('title')?>
                    </div>
                    <div class="sub_categoryBtn">
                        <p>서브메뉴 접기 </p>
                        <span><img src="<?=asset_public('images/upbtn.png')?>" alt="접기"></span>
                    </div>
                </div>
                <div class="sub_categoryMenu on">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li class="on"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>
            </div>
            
            <!--div class="order_List mb40">
                <div class="order_ListTh">
                    <ul>
                        <li class="order_ListTh01">제품사진</li>
                        <li class="order_ListTh02">주문상품</li>
                        <li class="order_ListTh03">단가</li>
                        <li class="order_ListTh04">주문수량</li>
                        <li class="order_ListTh05">공급가액</li>
                        <li class="order_ListTh06">VAT</li>
                        <li class="order_ListTh07">금액</li>
                    </ul>
                </div>
                <div class="order_ListTdWrap">
                    <div class="order_ListTd">
                        <div class="order_photo">
                            <img src="<?=asset_public('images/sub01.png')?>" alt="상품">
                        </div>
                        <div class="order_listText">
                            <div class="flex_sb">
                                <div>
                                    <p class="subWrap01ContsName02_sub01">
                                        Artesyn Embedded Technologies
                                    </p>
                                    <p class="subWrap01ContsName02_sub02">
                                        UFR6000-00J
                                    </p>
                                </div>

                                <div class="subWrap01subTag01">
                                    <span>자사</span>
                                </div>
                            </div>
                            <p class="subWrap01ContsName02_sub03">
                                RACK FOR 3 UFE2000-X 3 SLOT 1U
                            </p>
                            <div class="subWrap01ContsName02_sub04">
                                <p>
                                    계열 : UFR 부속품 유형 : 랙 실장 키트 함께 사용 가능 <br>
                                    관련 부품 : UFE2000-X
                                </p>
                            </div>

                        </div>
                        <div class="order_ListTd03">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd04">
                            <span class="order_ListPrice">  10,000</span>
                        </div>
                        <div class="order_ListTd05">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd06">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd07">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                    </div>

                    <div class="order_ListTd">
                        <div class="order_photo">
                            <img src="<?=asset_public('images/sub01.png')?>" alt="상품">
                        </div>
                        <div class="order_listText">
                            <div class="flex_sb">
                                <div>
                                    <p class="subWrap01ContsName02_sub01">
                                        Artesyn Embedded Technologies
                                    </p>
                                    <p class="subWrap01ContsName02_sub02">
                                        UFR6000-00J
                                    </p>
                                </div>

                                <div class="subWrap01subTag01">
                                    <span>자사</span>
                                </div>
                            </div>
                            <p class="subWrap01ContsName02_sub03">
                                RACK FOR 3 UFE2000-X 3 SLOT 1U
                            </p>
                            <div class="subWrap01ContsName02_sub04">
                                <p>
                                    계열 : UFR 부속품 유형 : 랙 실장 키트 함께 사용 가능 <br>
                                    관련 부품 : UFE2000-X
                                </p>
                            </div>

                        </div>
                        <div class="order_ListTd03">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd04">
                            <span class="order_ListPrice">  10,000</span>
                        </div>
                        <div class="order_ListTd05">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd06">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd07">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                    </div>

                    <div class="order_ListTd">
                        <div class="order_photo">
                            <img src="<?=asset_public('images/sub01.png')?>" alt="상품">
                        </div>
                        <div class="order_listText">
                            <div class="flex_sb">
                                <div>
                                    <p class="subWrap01ContsName02_sub01">
                                        Artesyn Embedded Technologies
                                    </p>
                                    <p class="subWrap01ContsName02_sub02">
                                        UFR6000-00J
                                    </p>
                                </div>

                                <div class="subWrap01subTag01">
                                    <span>자사</span>
                                </div>
                            </div>
                            <p class="subWrap01ContsName02_sub03">
                                RACK FOR 3 UFE2000-X 3 SLOT 1U
                            </p>
                            <div class="subWrap01ContsName02_sub04">
                                <p>
                                    계열 : UFR 부속품 유형 : 랙 실장 키트 함께 사용 가능 <br>
                                    관련 부품 : UFE2000-X
                                </p>
                            </div>

                        </div>
                        <div class="order_ListTd03">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd04">
                            <span class="order_ListPrice">  10,000</span>
                        </div>
                        <div class="order_ListTd05">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd06">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>
                        <div class="order_ListTd07">
                            <span class="order_ListPrice"> 1,000원</span>
                        </div>

                    </div>

                </div>
            </div-->

            <div class="order_List inquiry mb40 ">
                <div class="order_ListTh inquiry">
                    <ul>
                        <li class="order_ListTh01">후불문의 <?=lang_common('create')?></li>
                        <!--li class="order_ListTh01">젼적번호 : <span>K09652974</span></li-->                   
                    </ul>
                </div>
            </div>

            <form method="post" action="<?=route_guest('deferredpay.create')?>" enctype="multipart/form-data" id="form">
            <div class="inquiry">
                <div class="inquiryT">
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('user_name')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" id="text-input" type="text" name="user_name" value="<?=old_value('name', $memberName)?>" placeholder="<?=lang_common('user_name')?>">
                        </div>
                    </div>
                    <div class="inquiryWrapE">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p><?=lang_common('user_email')?><span class="color-red">*</span></p>
                            </div>
                            <div class="col-md-10">
                                <input class="form-control" id="text-input" type="email" name="user_email" value="<?=old_value('email', $memberEmail)?>" placeholder="<?=lang_common('user_email')?>">
                            </div>
                        </div>

                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_common('reply_emeil')?></p>
                            </div>
                            <div class="inquiryText">
                            <input <?=!empty(old('replyemeil_chk')) ? 'checked': ''?> class="form-check-input" type="checkbox" name="replyemeil_chk" value="1" id="replyemeil_chk">
                            <?=lang_common('reply_note')?>
                            </div>
                        </div>
                    </div>
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('user_phone')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" id="text-input" type="text" name="user_phone" value="<?=old_value('phone', $memberPhone)?>" placeholder="<?=lang_common('user_phone')?>">
                        </div>
                        <input class="form-control" id="text-input" type="hidden" name="member_code" value="<?=old_value('member_code', $memberCode)?>">
                    </div>

                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('category')?></p>
                        </div>
                        <div class="col-md-10">
                            <select class="form-control" name="category_id">
                                <?php foreach ($categories as $category): ?>
                                    <option value="<?=$category->category_id?>">
                                        <?=$category->category_name?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_contact('news_title')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>">
                        </div>
                    </div>

                    <!--div class="inquiryWrapE">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p><?=lang_contact('news_title')?><span class="color-red">*</span></p>
                            </div>
                            <div class="col-md-7">
                                <input class="form-control" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>">
                            </div>
                        </div>
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p>비밀번호</p>
                            </div>
                            <div class="inquiryText">
                                <input class="form-control" id="text-input" type="password" name="password" value="" placeholder="비밀번호를 등록하면 비밀글로 지정됩니다.">
                            </div>
                        </div>
                    </div-->
                    <!--div class="inquiryWrap">
                        <div class="inquiryLableFile">
                            <p><?=lang_common('file_upload')?></p>
                        </div>
                        <div class="col-md-10">
                            <div class="inquiryTextFile file_upload">
                                <p>
                                <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                    <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                                            <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                                        </div>
                                        <div class="file_action">
                                            <?php if($i > 1): ?>
                                                <a href="javascript:void(0)" class="button-delete color-red">
                                                    <i class="fa fa-minus-square"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:void(0)" class="button-add">
                                                    <i class="fas fa-plus-circle"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endfor; ?>
                                <span class="help-block">
                                    <code>
                                        <i class="fa fa-exclamation" aria-hidden="true"></i>
                                        <?=lang_common('file_upload_note')?>
                                    </code>
                                </span>
                                </p>
                            </div>
                        </div>
                    </div-->
                    
                    <div class="inquiryWrapD">
                            <div class="inquiryLable100">
                                <p><?=lang_common('question')?></p>
                            </div>
                    </div>
                </div>

                <div class="inquiryContents answerinquiry">
                    <p>
                    <textarea class="form-control" id="content" name="content" rows="8"></textarea>
                    </p>
                </div>

            </div>

            <div class="inquirybtnList">
                <ul>
                    <!--li><a href="#">이전내용</a></li-->
                    <li class="inquiryList"><button type="submit"><?=lang_common('create')?></button></li>
                    <!--li><a href="#">다음내용</a></li-->
                </ul>
            </div>
        </form>

        </div>

        <!--div class="sub04LastBtn">
            <ul>
                <li><button class="sub04payBtn"><span>확인</span></button></li>
                <li><button class="sub04cartBtn"><span>취소</span></button></li>
            </ul>
        </div-->

    </div>

    </div>
</section>  

    <!--section id="siteMain" class="site-main">
        <div class="container">

    <form method="post" action="<?=route_guest('deferredpay.create')?>" enctype="multipart/form-data" id="form">
        <div class="card-body">
            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="text-input">
                    <?=lang_common('category')?>
                </label>
                <div class="col-md-10">
                    <select class="form-control" name="category_id">
                        <?php foreach ($categories as $category): ?>
                            <option value="<?=$category->category_id?>">
                                <?=$category->category_name?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="text-input">
                    <?=lang_common('title')?>
                    <span class="color-red">*</span>
                </label>
                <div class="col-md-10">
                    <input class="form-control" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="text-input">
                    <?=lang_common('file_upload')?>
                </label>
                <div class="col-md-10 file_upload">

                    <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                        <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                                <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                            </div>
                            <div class="file_action">
                                <?php if($i > 1): ?>
                                    <a href="javascript:void(0)" class="button-delete color-red">
                                        <i class="fa fa-minus-square"></i>
                                    </a>
                                <?php else: ?>
                                    <a href="javascript:void(0)" class="button-add">
                                        <i class="fas fa-plus-circle"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endfor; ?>
                    <span class="help-block">
                        <code>
                            <i class="fa fa-exclamation" aria-hidden="true"></i>
                            <?=lang_common('file_upload_note')?>
                        </code>
                    </span>

                </div>
            </div>

            <div class="form-group row">
                <label class="col-md-2 col-form-label" for="text-input">
                    <?=lang_common('content')?>
                    <span class="color-red">*</span>
                </label>
                <div class="col-md-10">
                    <div class="row">
                        <div class="col-md-12">
                            <textarea class="form-control" id="content" name="content" rows="8"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <div class="form-group text-center">
        <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('create')?></button>
    </div>

    </div>
    </form>

        </div>
    </section-->
    
    <!--/#siteMain-->
<?= $this->endSection() ?>
