<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
<?=lang_deferredpay('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <!--#siteMain-->
    <section id="siteMain" class="site-main">

    <style>
        .news-detail .item .title {
            text-align: center;
            /*text-transform: uppercase;*/
            background-color: #ddd;
            padding: 10px;
        }
        .news-detail .item .content{
            padding: 10px;
        }
        .news-detail div.row.item{
            border: #E6E6E6 1px solid;
            margin: 0 auto;
        }
        .step-news-detail{
            color: #b00020;
        }
        .news-detail div.row.button{
            padding: 10px;
        }
        .content .hit{
            padding-left: 10px;
        }
    </style>
    <div class="container">
        <!--h6 class="step-news-detail">List <i class="fas fa-angle-right"></i> Detail </h6-->

    <div class="sub07Wrap">
        <div class="wrap">
            
            <div class="subWrap01Top">
                <div class="sub_category">
                    <div class="sub_categoryName">
                        <p>HOME > <?=lang_deferredpay('title')?>
                    </div>
                    <div class="sub_categoryBtn">
                        <p>서브메뉴 접기 </p>
                        <span><img src="<?=asset_public('images/upbtn.png')?>" alt="접기"></span>
                    </div>
                </div>
                <div class="sub_categoryMenu on">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li class="on"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>
            </div>

            <div class="order_List inquiry mb40 ">
                <div class="order_ListTh inquiry">
                    <ul>
                        <li class="order_ListTh01"><?=lang_common('update')?></li>
                        <li class="order_ListTh01"> <span> </span></li>                   
                    </ul>
                </div>
            </div>

            <form method="post" action="<?=route_guest('deferredpay.update',$item->id)?>" enctype="multipart/form-data" id="form">
            <div class="inquiry">
                <div class="inquiryT">
                    
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('user_name')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" value="<?=old_value('user_name',$item->user_name)?>" id="text-input" type="text" name="user_name" value="<?=old_value('name', $memberName)?>" placeholder="<?=lang_common('user_name')?>">
                        </div>
                    </div>
                    <div class="inquiryWrapE">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p><?=lang_common('user_email')?><span class="color-red">*</span></p>
                            </div>
                            <div class="col-md-10">
                                <input class="form-control" value="<?=old_value('user_email',$item->user_email)?>" id="text-input" type="email" name="user_email" value="<?=old_value('email', $memberEmail)?>" placeholder="<?=lang_common('user_email')?>">
                            </div>
                        </div>
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_common('reply_emeil')?></p>
                            </div>
                            <div class="inquiryText">
                            <input <?php if($item->replyemeil_chk == '1') echo 'checked' ?> class="form-check-input" type="checkbox" name="replyemeil_chk" value="1" id="replyemeil_chk">
                            <?=lang_common('reply_note')?>
                            </div>
                        </div>
                    </div>
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('user_phone')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" value="<?=old_value('user_phone',$item->user_phone)?>" id="text-input" type="text" name="user_phone" value="<?=old_value('phone', $memberPhone)?>" placeholder="<?=lang_common('user_phone')?>">
                        </div>
                    </div>

                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_common('category')?></p>
                        </div>
                        <div class="col-md-10">
                        <select class="form-control" name="category_id">
                            <?php foreach ($categories as $category): ?>
                                <option value="<?=$category->category_id?>" <?php if($item->category_id == $category->category_id) echo 'selected' ?>>
                                    <?=$category->category_name?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        </div>
                    </div>
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_contact('news_title')?><span class="color-red">*</span></p>
                        </div>
                        <div class="col-md-10">
                            <input class="form-control" value="<?=old_value('title',$item->title)?>" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>" required>
                        </div>
                    </div>
                    <!--div class="inquiryWrap">
                        <div class="inquiryLableFile">
                            <p><?=lang_common('file_upload')?></p>
                        </div>
                        <div class="col-md-10">
                            <div class="inquiryTextFile file_upload">
                                <p>
                                <?php foreach ($files as $index => $fileItem): ?>
                                <div class="input-group">
                                    <label><?=$fileItem->file_name?></label>
                                    <a href="<?=route_guest('deferredpay.delete_file',$item->id,$fileItem->file_no)?>" class="pl-2">
                                        <i class="fa fa-trash color-red" aria-hidden="true"></i>
                                    </a>
                                </div>
                                <?php endforeach;?>

                                <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                                        <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                                    </div>
                                    <div class="file_action">
                                        <?php if($i > 1): ?>
                                            <a href="javascript:void(0)" class="button-delete color-red">
                                                <i class="fa fa-minus-square"></i>
                                            </a>
                                        <?php else: ?>
                                            <a href="javascript:void(0)" class="button-add">
                                                <i class="fas fa-plus-circle"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php endfor; ?>

                                <span class="help-block">
                                    <code>
                                        <i class="fa fa-exclamation" aria-hidden="true"></i>
                                        <?=lang_common('file_upload_note')?>
                                    </code>
                                </span>
                                </p>
                            </div>
                        </div>
                    </div-->
                    
                    <div class="inquiryWrapD">
                            <div class="inquiryLable100">
                                <p><?=lang_common('question')?></p>
                            </div>
                    </div>
                </div>

                <div class="inquiryContents answerinquiry">
                    <p>
                    <textarea class="form-control" id="summary-ckeditor" name="content" rows="8"><?=esc(old_value('content',$item->content))?></textarea>
                    </p>
                </div>

            </div>

            <div class="inquirybtnList">
                <ul>
                    <!--li><a href="#">이전내용</a></li-->
                    <li class="inquiryList"><a href="<?=route_guest('deferredpay')?>"><?=lang_common('back')?></a></li>
                    <li><button type="submit"><?=lang_common('update')?></button></li>
                    <!--li><a href="#">다음내용</a></li-->
                </ul>
            </div>

            </form>
            </div>
        </div>
    </div>
</section>  


    <!--section id="siteMain" class="site-main">
        <div class="container">


        <form method="post" action="<?=route_guest('deferredpay.update',$item->id)?>" enctype="multipart/form-data" id="form">

        <div class="card">
<div class="card-header">
    <i class="fa fa-edit"></i> <?=lang_common('update')?>
    <div class="card-header-actions float-right">
        <a class="btn btn-block btn-secondary" href="<?=route_guest('deferredpay')?>">
            <?=lang_common('back')?>
        </a>
    </div>
</div>
<div class="card-body">
    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('category')?>
        </label>
        <div class="col-md-10">
            <select class="form-control" name="category_id">
                <?php foreach ($categories as $category): ?>
                    <option value="<?=$category->category_id?>" <?php if($item->category_id == $category->category_id) echo 'selected' ?>>
                        <?=$category->category_name?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('title')?>
            <span class="color-red">*</span>
        </label>
        <div class="col-md-10">
            <input class="form-control" value="<?=old_value('title',$item->title)?>" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>" required>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('file_upload')?>
        </label>
        <div class="col-md-10 file_upload">
            <?php foreach ($files as $index => $fileItem): ?>
                <div class="input-group">
                    <label><?=$fileItem->file_name?></label>
                    <a href="<?=route_guest('deferredpay.delete_file',$item->id,$fileItem->file_no)?>" class="pl-2">
                        <i class="fa fa-trash color-red" aria-hidden="true"></i>
                    </a>
                </div>
            <?php endforeach;?>

            <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                        <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                                <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                            </div>
                            <div class="file_action">
                                <?php if($i > 1): ?>
                                    <a href="javascript:void(0)" class="button-delete color-red">
                                        <i class="fa fa-minus-square"></i>
                                    </a>
                                <?php else: ?>
                                    <a href="javascript:void(0)" class="button-add">
                                        <i class="fas fa-plus-circle"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endfor; ?>
                    <span class="help-block">
                        <code>
                            <i class="fa fa-exclamation" aria-hidden="true"></i>
                            <?=lang_common('file_upload_note')?>
                        </code>
                    </span>
        </div>
    </div>

    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('content')?>
            <span class="color-red">*</span>
        </label>
        <div class="col-md-10">
            <div class="row">
                <div class="col-md-12">
                    <textarea class="form-control" id="summary-ckeditor" name="content" rows="8"><?=esc(old_value('content',$item->content))?></textarea>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card-footer text-center">
    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
</div>
</div>
        
         </form>

        </div>
    </section-->

    <!--/#siteMain-->
<?= $this->endSection() ?>
