<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
<?=lang_estimate('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <!--#siteMain-->

    <?php if(AuthHelpers::checkLoginGuest()):?>

<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_estimate('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>" class="active">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->
    <!--/div>
</section-->
<!-- product details top info e -->

<!---------------------------------------------------------------------------------------------------------------->

        <?php if (!$lists) :?>

                <div class="border-light-box order-form">
                    <div class="sub_title d-flex">견적을 요청하실 상품을 등록하세요!</div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                        견적을 요청하시는 상품이 없습니다.
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""> </label>
                        </div>                
                    </div>
                </div>

                <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
                    <a href="<?=route_guest('home')?>"><button class="btn btn-lg btn-blue w-20 ml-1">확인</button></a>
                </div>

        <?php else: ?>

                <form id="form-inq" name="user_form" method="post" action="<?=route_guest('estimate.create')?>" enctype="multipart/form-data">
                <!-- 견적 상품정보 s -->
                <div class="border-light-box">
                    <div class="sub_title">견적상품<?=lang_common('create')?></div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>견적상품</th>
                                <th>기준단가</th>
                                <th>견적수량</th>
                                <!--th>공급가액</th>
                                <th>VAT</th>
                                <th>금액</th-->
                                <th>삭제</th>
                            </tr>
                        </thead>

                        <?php
                        $i = 1;
                        foreach($lists as $item){

                        $item_price = $item->nowinfo['selling_price1'];
                        $amount_price = $item_price * $item->qty;
                        $price_vat = $amount_price*0.1;
                        $total_price = $amount_price+$price_vat;
                        ?>
                        <tr>
                            <td><p class="prd-img">
                            <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                                <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                    <img src="<?=$item->nowinfo['image_dir']?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                                <?php endif; ?>
                            <?php else : ?>
                                <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                            <?php endif; ?>
                            </p></td>
                            <td>
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>
                                <p class="col-blue font-sm"><?=$item->name?></p>
                                <p class="prd-subject"><?=$item->nowinfo['part_number']?></p>
                                <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
                                <?php $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.","; ?>
                                <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                                <p class="prd-option col-gray font-sm">
                                    <?php
                                    $brief_description = $item->nowinfo['brief_description'];
                                    $prd_description = explode('|^|', $brief_description);

                                    echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                    ?>
                                </p>
                            </td>
                            <td><?=number_format($item_price)?>원</td>
                            <td><?php echo $item->qty;?> <button class="btn font-xsm btn-outline-white" type="button" onclick="edit_estimate(<?=$item->estimate_id;?>)">변경</button></td>
                            <!--td><?=number_format($amount_price)?>원</td>
                            <td><?=number_format($price_vat)?>원</td>
                            <td><?=number_format($total_price)?>원</td-->
                            <td><button class="btn font-xsm btn-blue" type="button" onclick="delete_estimate(<?=$item->estimate_id;?>)">삭제</button></td>
                        </tr>

                        <?php
                        $i++;
                        }
                        ?>
                        </tbody>
                    </table>

                <input type="hidden" name="inquiry_code" value="<?=$inquiry_code?>"/>
                <!--------  s -->
 
                    <input type="hidden" name="estimate_code" value="<?=$estimate_code?>">
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for=""><?=lang_common('user_name')?><span class="col-red">*</span></label>
                            <input id="text-input" type="text" name="user_name" value="<?=old_value('name', $memberName)?>" placeholder="<?=lang_common('user_name')?>">
                        </div>
                        <div class="d-flex g-2">
                            <label for=""><?=lang_common('user_phone')?><span class="col-red">*</span></label>
                            <input class="form-control" id="text-input" type="text" name="user_phone" value="<?=old_value('phone', $memberPhone)?>" placeholder="<?=lang_common('user_phone')?>">
                            <input class="form-control" id="text-input" type="hidden" name="member_code" value="<?=old_value('member_code', $memberCode)?>">
                        </div>
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for=""><?=lang_common('user_email')?></label>
                            <input id="text-input" type="email" name="user_email" value="<?=old_value('email', $memberEmail)?>" placeholder="<?=lang_common('user_email')?>">
                        </div>
                        <div class="d-flex g-2">
                            <label for=""><?=lang_common('reply_note')?></label>
                            <input type="checkbox" name="replyemeil_chk" value="1" id="replyemeil_chk" <?=!empty(old('replyemeil_chk')) ? 'checked': ''?>>
                        </div>
                    </div>

                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""><?=lang_contact('news_title')?><span class="col-red">*</span></label>
                            <input class="form-control" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>">
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""><?=lang_common('question')?><span class="col-red">*</span></label>
                        </div>                
                    </div>
                    <div class="order_guideWrap mb56">
                        <div class="order_guideWrap02">
                        <textarea class="form-control" id="content" name="content" rows="8"></textarea>
                        </div>
                    </div>
                </div>

        <!--  e -->

                <div class="order-btn-box btn-box">
                        <a href="<?=route_guest('estimate.downloadbom')?>" class="btn font-xsm btn-outline-white float-l">BOM 양식받기</a>
                </div>
            </div>
        
            <div class="order-btn-box mt-3 mb-2"> </div>
        <div class="order-btn-box btn-lg-box btn-box align-c">
            <button type="submit" class="btn btn-lg btn-blue w-20 ml-1">확인</button>
        </div>
        
    </form>

    <?php endif;?>

<!------------------------------------------------------------------------------------------------------------------->


</div>
<!------------------------------------------------------------------------------------------------------------------->

</section>
<!-- product details top info e -->
<!-------------------------------------------------------------------------------------------------------------------->

<script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
    <script src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js" type="text/javascript"></script>

    <script type="text/javascript">
        
    $(document).ready( function () {
        $('#table_id').DataTable();
    } );
        var save_method; //for save method string
        var table;
    
        function edit_estimate(id)
        {
        save_method = 'update';
        $('#form')[0].reset(); // reset form on modals
        <?php header('Content-type: application/json'); ?>
        //Ajax Load data from ajax
        $.ajax({
            url:"<?=route_guest('estimatemodify.estimate_edit')?>" + id,
            type: "GET",
            dataType: "JSON",
            success: function(data)
            {
                console.log(data);
    
                $('[name="estimate_id"]').val(data.estimate_id);
                $('[name="part_number"]').val(data.part_number);
                $('[name="name"]').val(data.name);
                $('[name="qty"]').val(data.qty);
                $('[name="price"]').val(data.price);
    
                $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('수량변경'); // Set title to Bootstrap modal title
    
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                console.log(jqXHR);
                alert('데이터를 전달할 수 없습니다.');
            }
        });
        }

        function save()
        {
        var url;

        url = "<?=route_guest('estimatemodify.estimate_update')?>";

        // ajax adding data to database
            $.ajax({
                url : url,
                type: "POST",
                data: $('#form').serialize(),
                dataType: "JSON",
                success: function(data)
                {
                //if success close modal and reload ajax table
                $('#modal_form').modal('hide');
                location.reload();// for reload a page
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error adding / update data');
                }
            });
        }

        function delete_estimate(id)
        {
        if(confirm('이 데이터를 삭제하시겠습니까?'))
        {
            // ajax delete data from database
            $.ajax({
                url:"<?=route_guest('estimatemodify.estimate_delete')?>"+id,
                type: "POST",
                dataType: "JSON",
                success: function(data)
                {
                    
                location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('추가/삭제에 에러가 발생했습니다.');
                }
            });
    
        }
        }
    
    </script>

    <!-- Bootstrap modal -->
        <div class="modal fade" id="modal_form" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
        <h3 class="modal-title">Cart Form</h3>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"></span></button>
        </div>
        <div class="modal-body form">
            <form action="#" id="form" class="form-horizontal">
            <input type="hidden" value="" name="estimate_id"/>
            <div class="form-body">
                <div class="form-group">
                <label class="control-label col-md-3">제품명</label>
                <div class="col-md-9">
                    <input name="part_number" placeholder="Part Number" disabled class="form-control" type="text">
                </div>
                </div>
                <div class="form-group">
                <label class="control-label col-md-3">브랜드</label>
                <div class="col-md-9">
                    <input name="name" placeholder="Manufacturer" disabled class="form-control" type="text">
                </div>
                </div>
                <!--div class="form-group">
                <label class="control-label col-md-3">단가</label>
                <div class="col-md-9">
                    <input name="price" placeholder="Price" disabled class="form-control" type="text">
                </div>
                </div-->
                <div class="form-group">
                <label class="control-label col-md-3">변경수량</label>
                <div class="col-md-9">
                        <input name="qty" placeholder="Quantity" class="form-control" type="text">
                </div>
                </div>
            </div>
            </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="btnSave" onclick="save()" class="btn btn-primary">수정</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">취소</button>
            </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
    <!-- End Bootstrap modal -->


<!------------------------------------------------------------------------------------------------------------------->
        <?php else: ?>
            <section id="siteMain" class="site-main">
                <div class="container">
                    <div class="form-login">
                        <?php if($session->has('message')): ?>
                            <div class="alert alert-success">
                                <?=$session->get('message')?>
                            </div>
                        <?php endif; ?>
                        <?php if($session->has('error_message')): ?>
                            <div class="alert alert-danger">
                                <?=$session->get('error_message')?>
                            </div>
                        <?php endif; ?>
                        <h2 class="form-title"><?=lang_login('title')?></h2>
                        <form id="form" method="post" action="<?=route_guest('loginestimate')?>">
                            <?php if(has_error('error_common')): ?>
                                <div class="alert alert-danger">
                                    <span><?=get_error('error_common')?></span>
                                </div>
                            <?php endif?>
                            <div class="form-group">
                                <label for="member_email" class="form-label"><?=lang_login('user_name')?></label>
                                <input id="member_email" type="text" class="form-control" name="member_email" aria-describedby="member_email" value="<?=old('member_email')?>"/>
                            </div>
                            <div class="form-group">
                                <label for="password" class="form-label"><?=lang_login('password')?></label>
                                <input id="password" type="password" class="form-control" name="password" aria-describedby="password"/>
                            </div>
                            <div class="form-group">
                                <div class="form-check">
                                    <input class="form-check-input" name="remember" type="checkbox" <?=!empty(old('remember')) ? 'checked' : '' ?> value="<?=REMEMBER_FLG_ON?>" id="remember">
                                    <label class="form-check-label" for="remember"><?=lang_login('remember')?></label>
                                </div>
                            </div>
                            <div class="form-action">
                                <button type="submit" class="btn btn-block btn-outline-primary w-100 active" name="submit"><?=lang_login('button_login')?></button>
                            </div>
                            </form>

                            <div class="form-link text-center">
                                <a class="link-register" href="<?=route_guest('register')?>"><?=lang_login('link_register')?></a>&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                                <a class="link-register" href="<?=route_guest('forgot_password')?>"><?=lang_login('link_forgot_password')?></a>
                            </div>

                            <?php
                            define('NAVER_CLIENT_ID', 'bS6uqBpR00835BFLFGDa');
                            define('NAVER_CLIENT_SECRET', 'aETxh2Ecip');

                            // define('NAVER_CALLBACK_URL', 'http://localhost/naverapi/naverinfo');
                            // $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);

                            define('NAVER_CALLBACK_URL', 'https://chipdirect.co.kr/naverapi/naverinfo');
                            $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);


                            $REST_API_KEY   = "efbf6f87ffc71fde085dec391453d989"; // 내 애플리케이션 > 앱 설정 > 요약 정보
                            $CLIENT_SECRET  = ""; // 내 애플리케이션 > 제품 설정 > 카카오 로그인 > 보안
                            // $REDIRECT_URI  = urlencode("http://localhost/kakaoapi/kakaoinfo");
                            $REDIRECT_URI  = urlencode("https://chipdirect.co.kr/kakaoapi/kakaoinfo");

                            ?>

                            <div class="form-link text-center">
                                <a class="link-register" href="<?=$naverUrl?>"><img width="150" src="<?=asset_public('images/btnW_naver.png')?>"></a>&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                                <a href="https://kauth.kakao.com/oauth/authorize?client_id=<?=$REST_API_KEY?>&response_type=code&redirect_uri=<?=$REDIRECT_URI?>"><img width="150" src="<?=asset_public('images/btnW_kakao.png')?>"></a>
                            </div>
                    </div>
                </div>

                <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
                <script>
                    $(document).ready(function () {        
                        <?php if(session()->getFlashdata('status')) {?>
                            swal({
                                title: "<?=session()->getFlashdata('status')?>",
                                text: "<?=session()->getFlashdata('status_text')?>",
                                icon: "<?=session()->getFlashdata('status_icon')?>",
                                buttons: "확인",
                            });
                        <?Php } ?>
                    });
                </script>

            </section>

        <?php endif; ?>

<!---------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->
<?= $this->endSection() ?>
