<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
<?=lang_inquiry('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('body.js') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <!--#siteMain-->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
                <li><a href="#"><?=lang_inquiry('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                <?=lang_inquiry('title')?>
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>" class="active">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->
    <!--/div>
</section-->
<!-- product details top info e -->
<!---------------------------------------------------------------------------------------------------------------->

    <div class="border-light-box">
        <div class="border-light-box order-form">
            <div class="sub_title d-flex">문의상품정보</div>
            <table class="prd-linelist">
                <thead>
                    <tr>
                    <td class="image">Image</td>
                    <td class="info1">Mfr.Part#</td>
                    <td class="info2">Manufacturer</td>
                    <td class="desc">Description</td>
                    <td class="info3">MOQ/MPQ/PKG</td>
                    <td class="info4">Priceing</td>
                    </tr>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="image">
                            <a href="<?=route_guest('sale.detail', $productinfo->product_code)?>">
                            <?php if(isset($productinfo->image_dir) && $productinfo->image_dir != ''): ?>
                                <?php if(isset($productinfo->api_flg) && $productinfo->api_flg == '1'): ?>
                                    <img src="<?=$productinfo->image_dir?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($productinfo->image_dir)?>"/>
                                <?php endif; ?>
                            <?php else : ?>
                                <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                            <?php endif; ?>
                            </a>
                        </td>
                        <td data-label="Mfr.Part#" class="info1">
                            <a href="<?=route_guest('sale.detail', $productinfo->product_code)?>">
                            <?=$productinfo->part_number?>
                            </a>
                            <input id="name" type="hidden" class="form-control" name="part_number" value="<?=$productinfo->part_number?>" placeholder="<?=lang_cart('part_number')?>" aria-describedby="part_number"/>
                        </td>
                        <td data-label="Manufacturer" class="info2"><?=$productinfo->name?></td>
                        <?php
                            $brief_description = $productinfo->brief_description;
                            $prd_description = explode('|^|', $brief_description);
                        ?>
                        <td data-label="Description" class="desc"><?=$prd_description[0]?>, <?=$prd_description[1]?></td>
                        <td data-label="MOQ/MPQ/PKG" class="info3">                                    
                            <ul>
                                <li>MOQ : <?=\App\Helpers\NumberHelper::format($productinfo->moq, true)?></li>
                                <li>MPQ : <?=\App\Helpers\NumberHelper::format($productinfo->mpq, true)?></li>
                                <li>PKG : <?=$productinfo->packing_name?>(<?=$productinfo->packing_code?>)</li>
                            </ul>  
                        </td>
                        <td data-label="Priceing" class="info4">
                            <ul>
                                <?php 
                                if($productinfo->unit_mini_quantity1 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity1, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price1, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity2 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity2, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price2, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity3 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity3, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price3, true).''.lang_sale('price_unit').'</li>';
                                }

                                if($productinfo->unit_mini_quantity4 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity4, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price4, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity5 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity5, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price5, true).''.lang_sale('price_unit').'</li>';
                                }
                                if($productinfo->unit_mini_quantity6 > 0) {
                                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($productinfo->unit_mini_quantity6, true).'개 ~';
                                echo ' '.\App\Helpers\NumberHelper::format($productinfo->selling_price6, true).''.lang_sale('price_unit').'</li>';
                                }
                                ?>
                            </ul> 
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

<!------------------------------------------------------------------------------------------------------------------->

    <div class="border-light-box">
        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_inquiry('title')?> <?=lang_common('update')?></div>

            <form method="post" action="<?=route_guest('inquiry.update',$item->id)?>" enctype="multipart/form-data" id="form">
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_common('user_name')?><span class="col-red">*</span></label>
                    <input id="text-input" type="text" name="user_name" value="<?=old_value('user_name',$item->user_name)?>" placeholder="<?=lang_common('user_name')?>">
                </div>
                <div class="d-flex g-2">
                    <label for=""><?=lang_common('user_phone')?><span class="col-red">*</span></label>
                    <input class="form-control" id="text-input" type="text" name="user_phone" value="<?=old_value('user_phone',$item->user_phone)?>" placeholder="<?=lang_common('user_phone')?>">
                </div>
            </div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_common('user_email')?><span class="col-red">*</span></label>
                    <input id="text-input" type="email" name="user_email" value="<?=old_value('user_email',$item->user_email)?>" placeholder="<?=lang_common('user_email')?>">
                </div>
                <div class="d-flex g-2">
                <label for=""><?=lang_common('reply_note')?></label>
                    <input <?php if($item->replyemeil_chk == '1') echo 'checked' ?> type="checkbox" name="replyemeil_chk" value="1" id="replyemeil_chk">
                </div>
            </div>
            <div class="form-gp">
                <div class="d-flex g-1">
                    <label for=""><?=lang_common('category')?></label>
                    <select name="category_id">
                        <?php foreach ($categories as $category): ?>
                            <option value="<?=$category->category_id?>" <?php if($item->category_id == $category->category_id) echo 'selected' ?>>
                                <?=$category->category_name?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>                
            </div>
            <div class="form-gp">
                <div class="d-flex g-1">
                    <label for=""><?=lang_contact('news_title')?><span class="col-red">*</span></label>
                    <input id="text-input" type="text" name="title" value="<?=old_value('title',$item->title)?>" placeholder="<?=lang_common('title')?>">
                </div>
            </div>
            <div class="form-gp">
                <div class="d-flex g-1">
                    <label for=""><?=lang_common('question')?><span class="col-red">*</span></label>
                    <textarea class="form-control" id="content" name="content" rows="14"><?=esc(old_value('content',$item->content))?></textarea>
                </div>
            </div>

        </div>
    </div>

    </div>
    
        <div class="order-btn-box mt-3 mb-2"> </div>
        <div class="order-btn-box btn-lg-box btn-box align-c">
            <a onClick="history.go(-1)" class="btn btn-lg btn-outline-white" style="width:47%;"><?=lang_common('back')?></a>
            <button type="submit" class="btn btn-lg btn-blue ml-1" style="width:47%;"><?=lang_common('create')?></button>
        </div>
        
    </form>

<!---------------------------------------------------------------------------------------------------------------->

</section>
<!-- product details top info e -->
<!--/#siteMain-->
<!---------------------------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->
<?= $this->endSection() ?>
