<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
<?=lang_naverapi('info_title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>
    <script type="text/javascript">
        function selectAll(selectAll)  {
        const checkboxes 
            = document.querySelectorAll('input[id="ucheckbox"]');
        checkboxes.forEach((checkbox) => {
            checkbox.checked = selectAll.checked
        })
        }
	</script>
<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->
<!------------------------------------------------------------------------------------------------------------------->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">

      <nav class="breadcrumb" style='background-color: #ffffff;'>
          <ul>
              <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
              <li><a href="#">회원가입</a></li> 
          </ul>            
      </nav>

        <div class="d-flex">
            <div class="row align-l">
                <h2 class="mb-0 pb-0">회원가입</h2>
                <p class="font-xsm col-gray"> </p>
            </div>
        </div>

        <div class="cart_flow mb-2">
            <div class="flow cartFlow_1first">01 가입유형</div>
            <div class="flow cartFlow_2first">02 가입서작성</div>
            <div class="flow cartFlow_3first">03 가입완료</div>
        </div>

            <form method="post" action="<?=route_guest('register.show_create')?>" enctype="multipart/form-data" id="form">
            <input type="hidden" name="member_email" value="<?=$member_email?>"/>
            <input type="hidden" name="member_name" value="<?=$member_name?>"/>
            <input type="hidden" name="member_phone" value="<?=$member_phone?>"/>
            <input type="hidden" name="api_type" value="1"/>

          <div class="border-light-box">
          <div class="sub_title d-flex">카카오회원 가입입정보</div>
              <div class="border-light-box order-form">
                <div class="form-gp">
                  <div class="d-flex g-1">
                    <label for=""> </label>입력하신 카카오 로그인 정보와 일치하는 회원정보가 없습니다.
                  </div>  
                </div>
                <div class="form-gp">
                  <div class="d-flex g-1">
                    <label for=""> </label>카카오 정보로 회원가입 후 이용하시겠습니까?  
                  </div>  
                </div>
              </div>
          </div>     

            <div class="border-light-box order-form">
                <div class="order_guideinput" style="text-align: left;">
                    <input type="checkbox" id="to_kakao"  value='selectall'  onclick='selectAll(this)' required/>
                      <label for=""><b>(필수) 카카오 정보로 회원가입 전체동의</b><span class="text-danger">(*)</span></label>
                    </div>

          <div class="form-gp">
              <div class="d-flex g-1">
                  <label for=""><?=lang_register('category')?></label>
                  <label class="input-container ml-1"><?=lang_register('category_person')?>
                  <input class="form-check-input" name="category_id" type="radio" value="<?=MEMBER_CATEGORY_PERSON?>" checked id="person">
                      <span class="checkmark"></span>
                  </label>
                  <label class="input-container ml-1"><?=lang_register('category_company')?>
                  <input class="form-check-input" name="category_id" type="radio" value="<?=MEMBER_CATEGORY_COMPANY?>" id="company">
                      <span class="checkmark"></span>
                  </label>
                  <label class="input-container ml-1"><?=lang_register('category_dealer')?>
                  <input class="form-check-input" name="category_id" type="radio" value="<?=MEMBER_CATEGORY_DEALER?>" id="dealer">
                      <span class="checkmark"></span>
                  </label>
              </div>                
          </div>


          <!--  이용 약관 s -->
          <div class="border-light-box order-form">
            <div class="sub_title d-flex">서비스 이용 약관, 개인정보 수집 및 이용 안내</div>
            
                <div class="order_guideWrap mb56">
                    <div class="order_guideinput" style="text-align: left;">
                        <input type="checkbox" id="ucheckbox" name="agree1" onclick="ShipToMerchant(this.form);" required/>
                        <label for=""><b>(필수) 서비스 이용 약관 동의</b><span class="text-danger">(*)</span></label>
                    </div>
                    <div class="order_guideWrap02">
                    <textarea style="width: 100%; border: none; resize: none;" rows="20" readonly>
전자상거래(인터넷사이버몰) 표준약관

표준약관 제10023호
(2014. 9. 19. 개정)

제1조(목적) 이 약관은칩다이렉트 회사(전자상거래 사업자)가 운영하는 칩다이렉트 사이버 몰(이하 “몰”이라 한다)에서 제공하는 인터넷 관련 서비스(이하 “서비스”라 한다)를 이용함에 있어 사이버 몰과 이용자의 권리·의무 및 책임사항을 규정함을 목적으로 합니다.

  ※「PC통신, 무선 등을 이용하는 전자상거래에 대해서도 그 성질에 반하지 않는 한 이 약관을 준용합니다.」

제2조(정의)

  ① “몰”이란 칩다이렉트 회사가 재화 또는 용역(이하 “재화 등” 이라 함)을 이용자에게 제공하기 위하여 컴퓨터 등 정보통신설비를 이용하여 재화 등을 거래할 수 있도록 설정한 가상의 영업장을 말하며, 아울러 사이버몰을 운영하는 사업자의 의미로도 사용합니다.

  ② “이용자”란 “몰”에 접속하여 이 약관에 따라 “몰”이 제공하는 서비스를 받는 회원 및 비회원을 말합니다.

  ③ ‘회원’이라 함은 “몰”에 회원등록을 한 자로서, 계속적으로 “몰”이 제공하는 서비스를 이용할 수 있는 자를 말합니다.

  ④ ‘비회원’이라 함은 회원에 가입하지 않고 “몰”이 제공하는 서비스를 이용하는 자를 말합니다.
                    </textarea>
                    </div>
                </div>

                <div class="form-gp">
                    <div class="d-flex g-1">
                        <label for=""> </label>
                    </div>                
                </div>
                
                <div class="order_guideWrap mb56">
                    <div class="order_guideinput" style="text-align: left;">
                        <input type="checkbox" id="ucheckbox" name="agree2" required/>
                        <label for=""><b>(필수) 개인정보 수집 및 이용 동의</b><span class="text-danger">(*)</span></label>
                    </div>
                    <div class="order_guideWrap02">
                    <textarea style="width: 100%; border: none; resize: none;" rows="20" readonly>
칩다이렉트(이하 '회사'는)은 고객님의 개인정보를 중요시하며, "정보통신망 이용촉진 및 정보보호"에 관한 법률을 준수하고 있습니다.

[개인정보의 수집 및 이용목적]
"개인정보"라 함은 생존하는 개인에 관한 정보로서 당해 정보에 포함되어 있는 성명, 주민등록번호 등의 사항에 의하여 당해 개인을 식별할 수 있는 정보(당해 정보만으로는 특정 개인을 식별할 수 없더라도 다른 정보와 용이하게 결합하여 식별할 수 있는 것을 포함)를 말합니다.

대부분의 회사 서비스는 별도의 사용자 등록이 없이 언제든지 사용할 수 있습니다. 그러나 회사는 회원서비스를 통하여 이용자들에게 맞춤식 서비스를 비롯한 보다 더 향상된 양질의 서비스를 제공하기 위하여 이용자 개인의 정보를 수집하고 있습니다.

[개인정보의 보유 및 이용기간]
이용자가 회사의 회원으로서 회사에 제공하는 서비스를 이용하는 동안 회사는 이용자들의 개인정보를 계속적으로 보유하며 서비스 제공 등을 위해 이용합니다. 다만, 아래의 "마. 이용자 자신의 개인정보 관리(열람,정정,삭제 등)에 관한 사항" 에서 설명한 절차와 방법에 따라 회원 본인이 직접 삭제하거나 수정한 정보, 가입해지를 요청한 경우에는 재생할 수 없는 방법에 의하여 디스크에서 완전히 삭제하며 추후 열람이나 이용이 불가능한 상태로 처리됩니다.

[개인정보의 파기절차 및 방법]
회사는 개인정보 보유기간의 경과, 처리목적 달성 등 개인정보가 불필요하게 되었을 때에는 해당 정보를 지체없이 파기합니다.
개인정보 파기절차 및 방법은 다음과 같습니다.

1. 파기절차
회사는 파기 사유가 발생한 개인정보를 선정하고, 회사의 개인정보 보호책임자의 승인을 받아 개인정보를 파기합니다.
2. 파기방법
회사는 전자적 파일형태로 저장된 개인정보는 기록을 재생할 수 없도록 파기합니다.
                    </textarea>
                    </div>
                </div>

            </div>
        </div>
        <!--  이용 약관 e -->


        </div>

        <div class="order-btn-box mt-3 mb-2"> </div>
        <div class="order-btn-box btn-lg-box btn-box align-c">
            <button type="submit" class="btn btn-lg btn-blue w-20 ml-1"><?=lang_common('create')?></button>
        </div>
            
      </form>

<!------------------------------------------------------------------------------------------------------------------->
    </div>
</section>
<!-- product details top info e -->
<!------------------------------------------------------------------------------------------------------------------->
<?= $this->endSection() ?>