<?php
// require_once "./NHNAPISCL.php";
// require_once "./Naver_pay_lib.php";
require_once('NHNAPISCL.php');
require_once('Naver_pay_lib.php');


class naver_pay
{

    protected $SELLER_CODE;
    protected $License="0100010000f39765a55303e6a94c329481b5dc9cafb24b3b2af022d994e3c2b16819cc064f";
    protected $Secret="AQABAAB8I2PiU2WUTQ4a2pTKtnem9tpff2pWy6AjWM49zN7u8Q==";
    protected $Mall="np_yyqii399489";
    protected $xml;

    public function __construct()
    {
        ini_set('memory_limit','-1');
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: api_key, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        header("Content-type:text/html;Charset=UTF-8");
    }

    /**
     * URL
     * @param $kind
     * @return mixed
     */
    public function getUrl($kind)
    {

        $request_url = array();
        //주문 API
        $request_url['ORDER_SANDBOX'   ] = 'http://sandbox.api.naver.com/Checkout/';
        $request_url['ORDER_PRODUCTION'] = 'http://ec.api.naver.com/Checkout/';

        //문의 API
        $request_url['INQUIRY_SANDBOX'   ] = 'http://sandbox.api.naver.com/Checkout/';
        $request_url['INQUIRY_PRODUCTION'] = 'http://ec.api.naver.com/Checkout/';

        return $request_url[$kind];
    }

    public function call_curl($strCallName, $arrRequestArgument, $strRequestUri = null){

        $ch = curl_init();

        $headers = [
            "Content-Type: text/xml;charset=UTF-8",
            "SOAPAction: ".$strCallName
        ];

        curl_setopt($ch, CURLOPT_URL, $strRequestUri);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arrRequestArgument);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        //var_dump($response);

        if (curl_errno($ch)) {
            echo 'cURL Error: ' . curl_error($ch);
        }

        curl_close($ch);

        $this->output( "\n" );
        echo "## RESPONSE";//2021-04-09추가
        $this->output( "\n" );//2021-04-09추가

        $response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $response);
        $response = simplexml_load_string( $response );

        return $response;
    }

    /**
     * Xml soap request
     * @param $service
     * @param $operation
     * @param $array
     * @param $api
     * @return array
     */
    private function getSoapRequest($service, $operation, $array, $api)
    {
    
        $scl        = new NHNAPISCL();
        $timestamp  = $scl->getTimestamp();
        //var_dump($timestamp);
        //var_dump($timestamp.$service.$operation);
        // var_dump($this->Secret);
        $signature  = $scl->generateSign( $timestamp.$service.$operation, $this->Secret );        
        //var_dump($signature);
        $secret     = $scl->generateKey( $timestamp, $this->Secret );
        //var_dump($secret);

        switch( $service ){

            //주문API
            case 'MallService5' :
                $version    = '5.0';
                $tns        = 'http://mall.checkout.platform.nhncorp.com';
                break;

            //문의 API
            case 'CustomerInquiryService' :
                $version    = '1.0';
                $tns        = 'http://mall.checkout.platform.nhncorp.com';
                break;

            default :
                $version    = '5.0';
                $tns        = 'http://checkout.platform.nhncorp.com';
                break;
        }

        $NHNAPISCL = array();
        $NHNAPISCL['AccessLicense'] = $this->License;
        $NHNAPISCL['Timestamp'    ] = $timestamp;
        $NHNAPISCL['Signature'    ] = $signature;
        $NHNAPISCL['RequestID'    ] = $this->Mall;
        $NHNAPISCL['Version'      ] = $version;

        $request = array();
        $request = array_merge( $NHNAPISCL, $array );

        foreach ($request as $key => $row){
            $api = str_replace( '##'.$key.'##', '<![CDATA['.$row.']]>', $api );
        }
        $this->output( "\n" );
        echo "## REQUEST";//2021-04-09추가
        $this->output( "\n" );//2021-04-09추가
        echo $api;

        $soap = array();
        $soap['request'] = $api;
        $soap['secret' ] = $secret;

        return $soap;
    }

    /**
     * 복호화
     * @param $secret
     * @param $ctext
     * @return mixed
     */
    private function decrypt( $secret, $ctext )
    {
        $scl = new NHNAPISCL();


        return $scl->decrypt( $secret, $ctext );
    }

    #########################################################
    ## 1. 주문 관리
    #########################################################
    /**
     * 주문 수집, 발주 처리 (처리 대상 집계)
     */
    public function getOrder_get()
    {
        $sdate  = !empty( $_GET['sdate'] ) ? date( 'YmdH', strtotime( $_GET['sdate']. ' -9 hour' ) ).'0000' : ( date( 'YmdH', strtotime( '-1 day' ) ).'0000');		//시작일
        $edate	= !empty( $_GET['edate'] ) ? date( 'YmdH', strtotime( $_GET['edate']. ' -9 hour' ) ).'5959' : date('YmdHis');										    //종료일

        $cutime     = strtotime( $sdate );
        $endtime    = strtotime( $edate );
        
        // 2시간 단위로 반복 시작
        do{
            $stime  = date( 'Y-m-d\TH:i:s.u', strtotime( '+0 hour', $cutime ) );
            $etime  = date( 'Y-m-d\TH:i:s.u', strtotime( '+2 hour', $cutime ) );

            $cutime += ( 60 * 60 * 2 );

            $this->output( "\n" );
            $this->output( "#############################################################" );
            $this->output( "[ ".date( "Y-m-d H:i:s", strtotime($stime) )." ~ ".date( "Y-m-d H:i:s", strtotime($etime) )." ] 주문수집을 시작합니다." );
            $this->output( "#############################################################" );

            # 주문수집
            $this->getOrder( $stime, $etime );

        }while( $cutime < $endtime ); //2시간 더한 뒤 끝날짜까지 반복

        // $stime  = date( 'Y-m-d\TH:i:s.u', strtotime( '+0 hour', $cutime ) );
        // $etime  = date( 'Y-m-d\TH:i:s.u', strtotime( '+2 hour', $cutime ) );

        // $this->getOrder( $stime, $etime );

        $this->output( "\n\n" );
        $this->output( "#############################################################" );
        $this->output( "주문 수집이 완료됐습니다." );
        $this->output( "#############################################################" );
    }

    /**
     * 주문 수집
     * @param $startTime
     * @param $endTime
     * @return bool
     */
    private function getOrder($startTime, $endTime)
    {
        //$request_url = $this->getUrl( 'ORDER_PRODUCTION' );//운영
        $request_url = $this->getUrl( 'ORDER_SANDBOX' );//개발

        $param = array();
        $delivery_policy = 0;
        $param['InquiryTimeFrom'        ] = $startTime;
        $param['InquiryTimeTo'          ] = $endTime;
        $param['LastChangedStatusCode'  ] = 'PAYED';    //결제완료
        $param['MallID'                 ] = $this->Mall;

        $Naver_pay_lib = new Naver_pay_lib();

        $request     = $Naver_pay_lib->soapXml('GetChangedProductOrderList');
        //var_dump($request);
        $soapRequest = $this->getSoapRequest( 'MallService5', 'GetChangedProductOrderList', $param, $request );        
        //var_dump($soapRequest);

        try{
            //var_dump($request_url.'MallService5');
            //$response = $this->call( 'MallService5#GetChangedProductOrderList', $soapRequest['request'], $request_url.'MallService5' );
            $response = $this->call_curl( 'MallService5#GetChangedProductOrderList', $soapRequest['request'], $request_url.'MallService5' );
            //var_dump($response);            

            if( !$response ){
                $this->output( 'from 네이버페이:'. $this->http_fault );
                return false;
            }
        }catch( Exception $E ){
            $this->output( '자체오류:'. $E->getMessage() );
            return false;
        }

        var_dump("test1");
        $response = $response->soapenvBody->nGetChangedProductOrderListResponse;
        //var_dump($response);

        foreach( $response->nChangedProductOrderInfoList as $curOrder ){
            if( (string)$curOrder->n1LastChangedStatus != 'PAYED' ) continue;

            var_dump("test2");

            $dParam = array();
            $dParam['ProductOrderIDList'] = (string)$curOrder->n1ProductOrderID;

            var_dump("test3");

            $request  = $Naver_pay_lib->soapXml('GetProductOrderInfoList');
            //var_dump($request);
            $mRequest = $this->getSoapRequest( 'MallService5', 'GetProductOrderInfoList', $dParam, $request );
            //var_dump($mRequest);
            $dRequest = $mRequest['request'];
            $secret   = $mRequest['secret' ];

            try{
                $dResponse = $this->call_curl( 'MallService5#GetProductOrderInfoList', $dRequest, $request_url.'MallService5' );
                var_dump("test4");
                //var_dump($dResponse);

                if( !$dResponse ){
                    $this->output( 'from 네이버페이:'. $this->http_fault );
                    continue;
                }
            }catch( Exception $E ){
                $this->output( '자체오류:'. $E->getMessage() );
                continue;
            }

            $dResponse = $dResponse->soapenvBody->nGetProductOrderInfoListResponse->nProductOrderInfoList;
            //var_dump($dResponse);

            $delivery_msg = array();
            foreach( $dResponse as $curRefer ){
                try{
                    //배송지정보가 있는 주문만 처리
                    if( (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1ZipCode == '' ){
                        continue;
                    }
                    var_dump("test5");

                    ##Order##
                    $seller_order_code                  = (string)$curRefer->n1Order->n1OrderID;                 //판매사주문번호
                    //var_dump($seller_order_code);
                    $seller_order_refer_code            = (string)$curRefer->n1ProductOrder->n1ProductOrderID;   //판매사주문상세번호
                    var_dump($seller_order_refer_code);

                    ##Sender##
                    $sender_id                          = $this->decrypt( $secret, (string)$curRefer->n1Order->n1OrdererID   );                                               //주문자ID                    
                    var_dump($sender_id);
                    $sender_name                        = $this->decrypt( $secret, (string)$curRefer->n1Order->n1OrdererName );                           //주문자명
                    $sender_zip_code                    = (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1ZipCode;                                //주문인 우편번호
                    $sender_address1					= $this->decrypt( $secret, (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1BaseAddress ); //주문인주소1
                    $detail_addr                        = (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1DetailedAddress;
                    if($detail_addr) {
                        $sender_address2 = $this->decrypt($secret, (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1DetailedAddress);              //주문인주소2
                    }
                    $sender_phone                       = $this->decrypt( $secret, (string)$curRefer->n1Order->n1OrdererTel1 );                           //주문자전화번호
                    $sender_mobile                      = $curRefer->n1Order->n1OrdererTel2 ? $this->decrypt( $secret, (string)$curRefer->n1Order->n1OrdererTel2 ) : $sender_phone;   //주문자핸드폰번호
                    $sender_email                       = '';                                                                                                                         //주문자이메일주소

                    ##Receiver##
                    $receiver_name                      = $this->decrypt( $secret, (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1Name );   //수취인명
                    $receiver_zip_code                  = $sender_zip_code;                                                                          //수취인 우편번호
                    $receiver_address1                  = $sender_address1;                                                                          //수취인주소1
                    $receiver_address2                  = $sender_address2;                                                                          //수취인주소2
                    $receiver_phone                     = $this->decrypt( $secret, (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1Tel1 );   //수취인전화번호
                    $receiver_mobile                    = $curRefer->n1ProductOrder->n1ShippingAddress->n1Tel2 ? $this->decrypt( $secret, (string)$curRefer->n1ProductOrder->n1ShippingAddress->n1Tel2 ) : $receiver_phone;  //수취인핸드폰번호
                    $receiver_email                     = '';                                                                    //수취인이메일주소
                    $delivery_comment                   = (string)$curRefer->n1ProductOrder->n1ShippingMemo;                     //배송메세지

                    ##Time##
                    $order_time                         = date('Y-m-d H:i:s', strtotime( substr( str_replace( 'T', ' ', (string)$curRefer->n1Order->n1OrderDate   ), 0, 19).' +9 hour' ));   //주문일자
                    $paid_time                          = date('Y-m-d H:i:s', strtotime( substr( str_replace( 'T', ' ', (string)$curRefer->n1Order->n1PaymentDate ), 0, 19).' +9 hour' ));   //결제일자

                    ##Goods, Pay##
                    $goods_code                         = (string)$curRefer->n1ProductOrder->n1ProductID;						 //판매사상품코드
                    $goods_name                         = (string)$curRefer->n1ProductOrder->n1ProductName;                      //상품명
                    $goods_option_code					= (string)$curRefer->n1ProductOrder->n1OptionManageCode;                 //옵션코드
                    $seller_goods_option_code           = (string)$curRefer->n1ProductOrder->n1ItemNo;							 //판매사옵션코드
                    $goods_option_name                  = (string)$curRefer->n1ProductOrder->n1ProductOption;                    //옵션명
                    $order_quantity                     = (string)$curRefer->n1ProductOrder->n1Quantity;                         //주문수량
                    $rcv_unit_selling_price             = (int)$curRefer->n1ProductOrder->n1UnitPrice;                           //판매단가
                    $rcv_unit_selling_add_price         = (int)$curRefer->n1ProductOrder->n1OptionPrice;                         //옵션추가금액
                    $rcv_unit_paid_price                = (int)$curRefer->n1ProductOrder->n1TotalPaymentAmount;					 //총 결제 금액(할인 적용 후 금액)
                    $rcv_unit_general_price             = (int)$curRefer->n1ProductOrder->n1TotalProductAmount;					 //총 주문 금액(할인 적용 전 금액)
                    $rcv_unit_delivery_cost             = (int)$curRefer->n1ProductOrder->n1DeliveryFeeAmount;					 //배송비합계

                    //$order_coupon_cost                  = (int)$curRefer->n1ProductOrder->n1ProductDiscountAmount;               //주문별 할인액
                    $order_sf_coupon_cost               = (int)$curRefer->n1ProductOrder->n1ProductProductDiscountAmount;        //상품별 상품 할인 쿠폰 금액(쿠폰)

                    //$tot_paid_price						= (int)$curRefer->n1Order->n1GeneralPaymentAmount;						 //총 결제 금액(할인 적용 후 실제 주문 합계 결제 금액)
                    $tot_paid_price						= (int)$curRefer->n1Order->n1ChargeAmountPaymentAmount;

                    ##ETC##
                    $Selling_code                       = $curRefer->n1ProductOrder->n1SellingCode;                              //판매코드
                    $InflowPath                         = (string)$curRefer->n1ProductOrder->n1InflowPath;                       //지식쇼핑 유무 체크 (2021-09-28)
                    $individual_custom_cd               = $curRefer->n1ProductOrder->n1IndividualCustomUniqueCode ? $this->decrypt( $secret, (string)$curRefer->n1ProductOrder->n1IndividualCustomUniqueCode) : '';
                    $check_order = $seller_order_code; // 배송비 체크 Flag

                    // 위에 php 변수로 설정 해둔것 그대로 사용 하시면 될것 입니다.

                }catch( Exception $E ){
                    $this->output( '['.(string)$curOrder->n1ProductOrderID.'] 복호화 오류' );
                    continue;
                }
            }


        }

        return true;
    }

    /**
     * 주문 발주
     * @param $order_refer_code
     * @param $seller_order_refer_code
     * @return bool
     */
    public function allowOrder($seller_order_refer_code)
    {        
        if( !$seller_order_refer_code ){
            $this->output( '판매사주문상세번호가 전달되지 않음' ) ;
            return false;
        }

        //$request_url = $this->getUrl( 'ORDER_PRODUCTION' );//운영
        $request_url = $this->getUrl( 'ORDER_SANDBOX' );//개발
        // var_dump($request_url);

        $param = array();
        $param['ProductOrderID'             ] = $seller_order_refer_code;
        $param['CheckReceiverAddressChanged'] = true;

        $Naver_pay_lib = new Naver_pay_lib();

        $request     = $Naver_pay_lib->soapXml('PlaceProductOrder');

        $soapRequest = $this->getSoapRequest( 'MallService5', 'PlaceProductOrder', $param, $request );

        try{
            $response = $this->call_curl( 'MallService5#PlaceProductOrder', $soapRequest['request'], $request_url.'MallService5' );
            var_dump($response);

            if( !$response ){
                $this->output( 'from 네이버페이:'. $this->http_fault );
                return false;
            }
        }catch( Exception $E ){
            $this->output( '자체오류:'. $E->getMessage() );
            return false;
        }

        $response = $response->soapenvBody->nPlaceProductOrderResponse;

        return true;
    }

    /**
     * 송장 연동
     * @param $order_refer_code
     * @param $seller_code
     * @return bool
     */
    public function setDelivery($order_refer_code, $seller_deliv_company_code, $invoice_no)    
    {
        if( !$order_refer_code ){
            $this->output( '주문상세번호 전달되지 않음' );
            return false;
        }

        //$request_url = $this->getUrl( 'ORDER_PRODUCTION' );//운영
        $request_url = $this->getUrl( 'ORDER_SANDBOX' );//개발

        $param = array();
        $param['ProductOrderID'     ] = $order_refer_code;
        $param['DeliveryMethodCode' ] = 'DELIVERY';				//DELIVERY:택배,등기/소포
        $param['DeliveryCompanyCode'] = $seller_deliv_company_code;
        $param['TrackingNumber'     ] = $invoice_no;

        $Naver_pay_lib = new Naver_pay_lib();

        $request     = $Naver_pay_lib->soapXml('ShipProductOrder');

        $param['DispatchDate'] = date( 'Y-m-d\TH:i:s.u', time());

        $soapRequest = $this->getSoapRequest( 'MallService5', 'ShipProductOrder', $param, $request );
        
        try{
            $response = $this->call_curl( 'MallService5#ShipProductOrder', $soapRequest['request'], $request_url.'MallService5' );

            var_dump($response);

            $response = $response->soapenvBody->nShipProductOrderResponse;

            if( !$response ){
                $this->output( 'from 네이버 페이:'. $this->http_fault );
                return false;
            }
        }catch( Exception $E ){
            $this->output( '자체오류:'. $E->getMessage() );
            return false;
        }

        return true;
    }

    /**
     * 취소 수집
     */
    public function getCancel_get()
    {

        $sdate = !empty( $_GET['sdate'] ) ? date( 'YmdH', strtotime( $_GET['sdate']. ' -9 hour' ) ).'0000' : ( date( 'YmdH', strtotime( '-1 day' ) ).'0000');//시작일
        $edate = !empty( $_GET['edate'] ) ? date( 'YmdH', strtotime( $_GET['edate']. ' -9 hour' ) ).'5959' : date('YmdHis');										//종료일

        $cutime  = strtotime( $sdate );
        $endtime = strtotime( $edate );

        //2시간 단위로 반복 시작
        do{
            $stime  = date( 'Y-m-d\TH:i:s.u', strtotime( '+0 hour', $cutime ) );
            $etime  = date( 'Y-m-d\TH:i:s.u', strtotime( '+2 hour', $cutime ) );

            $cutime += ( 60 * 60 * 2 );

            $this->output( "\n" );
            $this->output( "#############################################################" );
            $this->output( "[ ".date( "Y-m-d H:i:s", strtotime($stime) )." ~ ".date( "Y-m-d H:i:s", strtotime($etime) )." ] 취소요청(CANCEL_REQUESTED) 수집을 시작합니다." );
            $this->output( "#############################################################" );

            # 취소주문수집
            $this->getCancelOrder( $stime, $etime, 'CANCEL_REQUESTED' );

        }while( $cutime < $endtime ); //2시간 더한 뒤 끝날짜까지 반복

        $this->output( "\n\n" );
        $this->output( "#############################################################" );
        $this->output( "취소주문 수집이 완료됐습니다." );
        $this->output( "#############################################################" );
    }

    /**
     * 취소 주문 수집
     * @param $startTime
     * @param $endTime
     * @param $mode
     * @return bool
     */
    public function getCancelOrder($startTime, $endTime, $mode)
    {
        //$request_url = $this->getUrl( 'ORDER_PRODUCTION' );//운영
        $request_url = $this->getUrl( 'ORDER_SANDBOX' );//개발

        $param = array();
        $param['InquiryTimeFrom'        ] = $startTime;
        $param['InquiryTimeTo'          ] = $endTime;
        $param['LastChangedStatusCode'  ] = $mode;      //CANCEL_REQUESTED, CANCEL - 취소요청, 취소완료
        $param['MallID'                 ] = $this->Mall;

        $Naver_pay_lib = new Naver_pay_lib();

        $request     = $Naver_pay_lib->soapXml('GetChangedProductOrderList');

        $soapRequest = $this->getSoapRequest( 'MallService5', 'GetChangedProductOrderList', $param, $request );

        try{
            $response = $this->call_curl( 'MallService5#GetChangedProductOrderList', $soapRequest['request'], $request_url.'MallService5' );

            if( !$response ){
                $this->output( 'from 스토어팜:'. $this->http_fault );
                return false;
            }
        }catch( Exception $E ){
            $this->output( '자체오류:'. $E->getMessage() );
            return false;
        }

        $response = $response->soapenvBody->nGetChangedProductOrderListResponse;

        if( count( $response->nChangedProductOrderInfoList ) == 0 ){
            $this->output( '네이버 페이로부터 전달된 취소주문 데이터가 없습니다.' );
            return false;
        }

        foreach( $response->nChangedProductOrderInfoList as $curOrder ){

            if( (string)$curOrder->n1LastChangedStatus != 'CANCEL_REQUESTED' && (string)$curOrder->n1LastChangedStatus != 'CANCELED' )   continue;

            $dParam = array();
            $dParam['ProductOrderIDList'] = (string)$curOrder->n1ProductOrderID;
            $Naver_pay_lib = new Naver_pay_lib();

            $request     = $Naver_pay_lib->soapXml('GetProductOrderInfoList');

            $dRequest = $this->getSoapRequest( 'MallService5', 'GetProductOrderInfoList', $dParam, $request );

            try{
                $dResponse = $this->call_curl( 'MallService5#GetProductOrderInfoList', $dRequest['request'], $request_url.'MallService5' );

                if( !$dResponse ){
                    $this->output( 'from 네이버 페이:'. $this->http_fault );
                    return false;
                }
            }catch( Exception $E ){
                $this->output( '자체오류:'. $E->getMessage() );
                return false;
            }

            $dResponse = $dResponse->soapenvBody->nGetProductOrderInfoListResponse->nProductOrderInfoList;

            foreach( $dResponse as $curCancel ){
                
                switch( (string)$curCancel->n1CancelInfo->n1CancelReason ){
                    case 'PRODUCT_UNSATISFIED'  :   $comment_state = '03';	break;
                    case 'DELAYED_DELIVERY'     :	$comment_state = '02';	break;
                    case 'SOLD_OUT'			    :	$comment_state = '99';	break;
                    case 'INTENT_CHANGED'       :	$comment_state = '01';	break;
                    case 'COLOR_AND_SIZE'       :	$comment_state = '01';	break;
                    case 'WRONG_ORDER'		    :	$comment_state = '01';	break;
                    case 'DROPPED_DELIVERY'		:	$comment_state = '02';	break;
                    case 'BROKEN'		        :	$comment_state = '04';	break;
                    case 'INCORRECT_INFO'		:	$comment_state = '03';	break;
                    case 'WRONG_DELIVERY'		:	$comment_state = '04';	break;
                    case 'WRONG_OPTION'		    :	$comment_state = '04';	break;
                    case 'ETC'	                :	$comment_state = '99';	break;
                    default:						$comment_state = '01';	break;
                }

                $seller_order_refer_code = (string)$curCancel->n1ProductOrder->n1ProductOrderID;//판매자 주문 상세
                $cancel_reason = (string)$curCancel->n1CancelInfo->n1CancelReason;//취소 이유
            }
        }

        return true;
    }

    /**
     * 반품 수집
     */
    public function getReturn_get()
    {

        $sdate = !empty( $_GET['sdate'] ) ? date( 'YmdH', strtotime( $_GET['sdate']. ' -9 hour' ) ).'0000' : ( date( 'YmdH', strtotime( '-1 day' ) ).'0000');		//시작일
        $edate = !empty( $_GET['edate'] ) ? date( 'YmdH', strtotime( $_GET['edate']. ' -9 hour' ) ).'5959' : date('YmdHis');										        //종료일

        $cutime  = strtotime( $sdate );
        $endtime = strtotime( $edate );

        //12시간 단위로 반복 시작
        do{
            $stime = date( 'Y-m-d\TH:i:s.u', strtotime( '+0 hour' , $cutime ) );
            $etime = date( 'Y-m-d\TH:i:s.u', strtotime( '+12 hour', $cutime ) );

            $cutime += ( 60 * 60 * 12 );

            $this->output( "\n" );
            $this->output( "#############################################################" );
            $this->output( "[ ".date( "Y-m-d H:i:s", strtotime($stime) )." ~ ".date( "Y-m-d H:i:s", strtotime($etime) )." ] 반품 주문수집을 시작합니다." );
            $this->output( "#############################################################" );

            # 반품주문수집
            $this->getReturnOrder( $stime, $etime, 'RETURN_REQUESTED' );

        }while( $cutime < $endtime );//12시간 더한 뒤 끝날짜까지 반복

        $this->output( "\n\n" );
        $this->output( "#############################################################" );
        $this->output( "반품주문 수집이 완료됐습니다." );
        $this->output( "#############################################################" );
    }

    /**
     * 반품 주문 수집
     * @param $startTime
     * @param $endTime
     * @param $mode
     * @return bool
     */
    private function getReturnOrder($startTime, $endTime, $mode)
    {
        //$request_url = $this->getUrl('ORDER_PRODUCTION');//운영
        $request_url = $this->getUrl( 'ORDER_SANDBOX' );//개발

        $param = array();
        $param['InquiryTimeFrom'        ] = $startTime;
        $param['InquiryTimeTo'          ] = $endTime;
        $param['LastChangedStatusCode'  ] = $mode;
        $param['MallID'                 ] = $this->Mall;

        $Naver_pay_lib = new Naver_pay_lib();

        $request     = $Naver_pay_lib->soapXml('GetChangedProductOrderList');

        $soapRequest = $this->getSoapRequest( 'MallService5', 'GetChangedProductOrderList', $param, $request );

        try{
            $response = $this->call_curl( 'MallService5#GetChangedProductOrderList', $soapRequest['request'], $request_url.'MallService5' );

            if( !$response ){
                $this->output( 'from 네이버 페이:'. $this->http_fault );
                return false;
            }
        }catch( Exception $E ){
            $this->output( '자체오류:'. $E->getMessage() );
            return false;
        }

        $response = $response->soapenvBody->nGetChangedProductOrderListResponse;

        if( count( $response->nChangedProductOrderInfoList ) == 0 ){
            $this->output( '네이버 페이로부터 전달된 반품주문 데이터가 없습니다.' );
            return false;
        }

        foreach( $response->nChangedProductOrderInfoList as $curOrder ){

            if( (string)$curOrder->n1LastChangedStatus != 'RETURN_REQUESTED' && (string)$curOrder->n1LastChangedStatus != 'RETURNED' )   continue;

            $dParam = array();
            $dParam['ProductOrderIDList'] = (string)$curOrder->n1ProductOrderID;
            $Naver_pay_lib = new Naver_pay_lib();

            $request     = $Naver_pay_lib->soapXml('GetProductOrderInfoList');
            $dRequest = $this->getSoapRequest( 'MallService5', 'GetProductOrderInfoList', $dParam, $request );

            try{
                $dResponse = $this->call_curl( 'MallService5#GetProductOrderInfoList', $dRequest['request'], $request_url.'MallService5' );

                if( !$dResponse ){
                    $this->output( 'from 네이버 페이:'. $this->http_fault );
                    return false;
                }
            }catch( Exception $E ){
                $this->output( '자체오류:'. $E->getMessage() );
                return false;
            }

            $dResponse = $dResponse->soapenvBody->nGetProductOrderInfoListResponse->nProductOrderInfoList;

            foreach( $dResponse as $curRefer ){    
                switch( (string)$curRefer->n1ReturnInfo->n1ReturnReason ){
                    case 'PRODUCT_UNSATISFIED'  :   $comment_state = '03';	break;
                    case 'DELAYED_DELIVERY'     :	$comment_state = '02';	break;
                    case 'SOLD_OUT'			    :	$comment_state = '99';	break;
                    case 'INTENT_CHANGED'       :	$comment_state = '01';	break;
                    case 'COLOR_AND_SIZE'       :	$comment_state = '01';	break;
                    case 'WRONG_ORDER'		    :	$comment_state = '01';	break;
                    case 'DROPPED_DELIVERY'		:	$comment_state = '02';	break;
                    case 'BROKEN'		        :	$comment_state = '04';	break;
                    case 'INCORRECT_INFO'		:	$comment_state = '03';	break;
                    case 'WRONG_DELIVERY'		:	$comment_state = '04';	break;
                    case 'WRONG_OPTION'		    :	$comment_state = '04';	break;
                    case 'ETC'	                :	$comment_state = '99';	break;
                    default:						$comment_state = '01';	break;
                }


                $SELLER_ORDER_REFER_CODE = (string)$curRefer->n1ProductOrder->n1ProductOrderID;//네이버 페이 주문 상세
                $RETURN_DELIV_COST = (int)$curRefer->n1ReturnInfo->n1ClaimDeliveryFeeDemandAmount;//반품 배송비 청구액
                $RETURN_REASON = (string)$curRefer->n1ReturnInfo->n1ReturnReason;//반품 이유


            }
        }

        return true;
    }

    /**
     * output
     * @param $txt
     */
    private function output( $txt )
    {
        $txt = "\r\n".$txt;

        print $txt;
    }
}
?>