<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_notice('news')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
    <!--#siteMain-->
    <section id="siteMain" class="site-main">

        <div class="container">
            <h2 class="form-title"><?=lang_notice('title')?></h2>
            <div class="news-action">
                <div class="form-search">
                    <form method="get" action="<?=route_guest('notice')?>">
                        <input class="form-control" placeholder="title of news or characters" name="title" value="<?=$title?>">
                        <button type="submit" class="btn btn-search"><i class="fas fa-search"></i></button>
                    </form>
                </div>
            </div>

            <ul class="news-list">
                <li class="title">
                    <div class="news_no-number"><?=lang_common('no')?></div>
                    <div class="news_category"><?=lang_common('category')?></div>
                    <div class="news_title"><?=lang_common('title')?></div>
                    <div class="news_id"><?=lang_common('id')?></div>
                    <div class="news_date"><?=lang_common('date')?></div>
                    <div class="news_hit"><?=lang_common('hit')?></div>
                </li>
                <?php foreach ($lists as $key => $item): ?>
                    <li class="news">
                        <div class="news_no-number"><?=show_no_row($key+1, $perPage, $currentPage)?></div>
                        <div class="news_category"><?=$item->category_name?></div>
                        <div class="news_title">
                            <a href="<?=route_guest('notice.detail', $item->id)?>"><?=$item->title?></a>
                        </div>
                        <div class="news_id"><?=$item->full_name?></div>
                        <div class="news_date text-center">
                            <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                        </div>
                        <div class="news_hit">
                            <?=\App\Helpers\NumberHelper::format($item->hit_number, true)?>
                        </div>
                    </li>
                <?php endforeach; ?>
                <?php if(count($lists) == 0): ?>
                    <li class="news">
                        <div><?=lang_common('no_data')?></div>
                    </li>
                <?php endif;?>
            </ul>

            <div class="row">
                <div class="col-12">
                    <?= $pager->links() ?>
                </div>
            </div>

            <div class="col-md-12 mt-5 text-center">
                <a href="<?=route_guest('notice.show_create')?>" class="btn btn-primary btn-lg"><?=lang_common('create')?></a>
            </div>

        </div>
    </section><!--/#siteMain-->
<?= $this->endSection() ?>
