<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">

    <style>
        .news-detail .item .title {
            text-align: center;
            /*text-transform: uppercase;*/
            background-color: #ddd;
            padding: 10px;
        }
        .news-detail .item .content{
            padding: 10px;
        }
        .news-detail div.row.item{
            border: #E6E6E6 1px solid;
            margin: 0 auto;
        }
        .step-news-detail{
            color: #b00020;
        }
        .news-detail div.row.button{
            padding: 10px;
        }
        .content .hit{
            padding-left: 10px;
        }
    </style>
    <div class="container">
        <h6 class="step-news-detail">List <i class="fas fa-angle-right"></i> Detail </h6>
        <div class="news-detail">
            <div class="row item">
                <div class="col-12 content text-sm-right text-center">
                    <span><?=lang_common('date')?> : </span>
                    <span><?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?></span>
                    <span class="hit"><?=lang_common('hit')?> : </span>
                    <span><?=\App\Helpers\NumberHelper::format($item->hit_number, true)?></span>
                </div>
            </div>
            <div class="row item">
                <div class="col-md-2 title">
                    <span><?=lang_common('title')?> </span>
                </div>
                <div class="col-md-10 content">
                    <?=$item->title?>
                </div>
            </div>
            <div class="row item">
                <div class="col-md-2 title">
                    <span><?=lang_common('id')?> </span>
                </div>
                <div class="col-md-10 content">
                    <?=$item->full_name?>
                </div>
            </div>
            <div class="row item">
                <div class="col-md-2 title">
                    <span><?=lang_common('category')?> </span>
                </div>
                <div class="col-md-10 content">
                    <?=$item->category_name?>
                </div>
            </div>
            <div class="row item">
                <div class="col-md-2 title">
                    <span><?=lang_common('file')?> </span>
                </div>
                <div class="col-md-10 content">
                    <?php foreach ($files as $index => $fileItem): ?>
                        <div class="input-group">
                            <label>
                                <a href="<?=route_guest('notice.view_file', $item->id, $fileItem->file_no)?>" target="<?=open_file_browser($fileItem->file_name)?>">
                                    <?=$fileItem->file_name?>
                                </a>
                            </label>
                        </div>
                    <?php endforeach;?>
                </div>
            </div>
            <div class="row item">
                <div class="col-md-2 title content">
                    <span><?=lang_common('content')?> </span>
                </div>
                <div class="col-md-10 content">
                    <p><?php echo escape_output($item->content)?></p>
                </div>
            </div>
            <div class="row button">
                <div class="col-6 text-center">
                    <a href="<?=route_guest('notice')?>" class="btn btn-primary btn-lg"><?=lang_common('list')?></a>
                </div>

                <div class="col-6 text-center">
                    <a href="<?=route_guest('notice.update', $item->id)?>" class="btn btn-primary btn-lg"><?=lang_common('update')?></a>
                </div>
            </div>

        </div>
    </div>
</section>
<?= $this->endSection() ?>
