<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->

<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_one2one('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>" class="active">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->
    <!--/div>
</section-->
<!-- product details top info e -->

<!---------------------------------------------------------------------------------------------------------------->


<?php if ($item->member_code != AuthHelpers::getLoginInfoGuest()->member_code ) {?>
    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {
    
            swal({
                title: "정보오류",
                text: "회원정보가 없거나 일치하지 않습니다.",
                icon: "warning",
                button: "확인",
            })
            .then(function(){
                location.href = "/estimate";
            });
    
        });
    </script>

    <?php } else {?>


<!------------------------------------------------------------------------------------------------------------------->

    <div class="border-light-box">

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_one2one('title')?></div>
            <div class="sub_title"><?=$item->title?></div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_id')?></label>
                    <?=$item->user_name?>
                </div>
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_hit')?></label>
                    <?=\App\Helpers\NumberHelper::format($item->hit_number, true)?>
                </div>
            </div>
            <div class="form-gp">
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_category')?></label>
                    <?=$item->category_name?>
                </div>
                <div class="d-flex g-2">
                    <label for=""><?=lang_contact('news_date')?></label>
                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                </div>
            </div>
            <!--div class="form-gp">                
                <div class="d-flex g-1">
                    <label for=""><?=lang_contact('news_file')?></label>
                    <?php foreach ($files as $index => $fileItem): ?>
                    <a href="<?=route_guest('one2one.view_file', $item->id, $fileItem->file_no)?>" target="<?=open_file_browser($fileItem->file_name)?>">
                        <?=$fileItem->file_name?>
                    </a>
                <?php endforeach;?>
                </div>
            </div-->
        </div>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_common('question')?></div>
            <div class="form-gp">                
                <div class="d-flex g-1">
                    <?php echo htmlspecialchars_decode($item->content)?>
                </div>
            </div>
        </div>
        
        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_common('answer')?></div>
            <div class="form-gp">                
                <div class="d-flex g-1">
                    <?php echo htmlspecialchars_decode($item->answer_content)?>
                </div>
            </div>
        </div>

    </div>

    <div class="order-btn-box btn-box">
        <a href="<?=route_guest('one2one')?>" class="btn font-xsm btn-blue float-r ml-1"><?=lang_contact('news_list')?></a>
        <a href="<?=route_guest('one2one.update', $item->id)?>" class="btn font-xsm btn-blue float-r"><?=lang_common('update')?></a>
    </div>

    <?php } ?>

    </div>
</section>
<!---------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->

<?= $this->endSection() ?>
