<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_orderinfo('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>

    <!--#siteMain-->
    <?php if(AuthHelpers::checkLoginGuest()):?>
<!------------------------------------------------------------------------------------------------------------------->
    <section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_orderinfo('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>" class="active">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

        <!-- 주문 상품정보 s -->
        <div class="border-light-box">
        <div class="sub_title">주문내역</div>

        <div class="order-form">
             <div class="form-gp">
                 <div class="d-flex g-2">
                    <div style="width: 100%;">
                        <form method="get" action="<?=route_guest('orderinfo')?>">
                        <input placeholder="주문서 검색" name="title" value="<?=$title?>" style="width: 80%;">
                        <button type="submit" class="btn font-xsm btn-outline-white float-r">검색</button>
                        </form>
                    </div>
                 </div>
                 <div class="d-flex g-2">
                 </div>
                 <!--a class="btn font-xsm btn-blue float-r" href="<?=route_guest('orderinfo.show_create')?>"><?=lang_common('create')?></a-->
             </div>
        </div>

        <div class="prd-linelist">
        <table>
            <thead>
                <tr>
                    <td class="info1"><?=lang_contact('news_no')?></td>
                    <td class="info2">주문일시</td>
                    <td class="info1"><?=lang_orderinfo('order_code')?></td>
                    <td class="desc"><?=lang_orderinfo('items')?></td>
                    <td class="info2"><?=lang_orderinfo('amount')?></td>
                    <td class="info1"><?=lang_orderinfo('situation')?></td>
                </tr>
                </tr>
            </thead>
            <tbody>

                <?php foreach ($lists as $key => $item): ?>
                    <tr>
                        <td data-label="<?=lang_contact('news_no')?>" class="info1"><?=show_no_row($key+1, $perPage, $currentPage)?></td>
                        <td data-label="주문일시" class="info1"><?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd hh:mm')?></td>
                        <td data-label="<?=lang_orderinfo('order_code')?>" class="desc"><a href="<?=route_guest('orderinfo.detail', $item->info_id)?>"><?=$item->order_code?></a></td>

                        <td data-label="<?=lang_orderinfo('items')?>" class="info2">
                        <?php
                            if ($item->item_counts > 1) {
                                echo $item->part_number." 외 ".$item->item_counts."개 품목";
                            } else {
                                echo $item->part_number;
                            }
                        ?>
                        </td>

                        <td data-label="<?=lang_orderinfo('amount')?>" class="info2"><?=\App\Helpers\NumberHelper::format($item->amount_total, true)?><?=lang_sale('price_unit')?></td>
                        <td data-label="<?=lang_orderinfo('situation')?>" class="info1">
                            <?php foreach ($orderstatus as $order_status): ?>
                                <?php if($order_status->status_code == $item->order_status) echo $order_status->status_info;?>
                            <?php endforeach; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if(count($lists) == 0): ?>
                    <tr>
                        <td colspan="6"><?=lang_common('no_data')?></td>
                    </tr>
                <?php endif;?>
                </tbody>
        </table>
        </div>
<!------------------------------------------------------------------------------------------------------------------->
    </div>
<!---------------------------------------------------------------------------------------------------------------->

        <div class="row">
            <div class="col-12">
                <?= $pager->links() ?>
            </div>
        </div>

</section>

<!------------------------------------------------------------------------------------------------------------------->
        <?php else: ?>
            <section id="siteMain" class="site-main">
                <div class="container">
                    <div class="form-login">
                        <?php if($session->has('message')): ?>
                            <div class="alert alert-success">
                                <?=$session->get('message')?>
                            </div>
                        <?php endif; ?>
                        <?php if($session->has('error_message')): ?>
                            <div class="alert alert-danger">
                                <?=$session->get('error_message')?>
                            </div>
                        <?php endif; ?>
                        <h2 class="form-title"><?=lang_login('title')?></h2>
                        <form id="form" method="post" action="<?=route_guest('login')?>">
                            <?php if(has_error('error_common')): ?>
                                <div class="alert alert-danger">
                                    <span><?=get_error('error_common')?></span>
                                </div>
                            <?php endif?>
                            <div class="form-group">
                                <input id="member_email" type="text" class="form-control" name="member_email" aria-describedby="member_email" value="<?=old('member_email')?>" placeholder="<?=lang_login('user_name')?>"/>
                            </div>
                            <div class="form-group">
                                <input id="password" type="password" class="form-control" name="password" aria-describedby="password" placeholder="<?=lang_login('password')?>"/>
                            </div>
                            <div class="form-group">
                                <div class="form-check">
                                    <input class="form-check-input" name="remember" type="checkbox" <?=!empty(old('remember')) ? 'checked' : '' ?> value="<?=REMEMBER_FLG_ON?>" id="remember">
                                    <label class="form-check-label" for="remember"><?=lang_login('remember')?></label>
                                </div>
                            </div>
                            <div class="form-action">
                                <button type="submit" class="btn btn-block btn-outline-primary w-100 active" name="submit"><?=lang_login('button_login')?></button>
                            </div>
                            </form>

                            <div class="form-link text-center">
                                <a class="link-register" href="<?=route_guest('register')?>"><?=lang_login('link_register')?></a>&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                                <a class="link-register" href="<?=route_guest('forgot_password')?>"><?=lang_login('link_forgot_password')?></a>
                            </div>

                            <?php
                            define('NAVER_CLIENT_ID', 'bS6uqBpR00835BFLFGDa');
                            define('NAVER_CLIENT_SECRET', 'aETxh2Ecip');

                            // define('NAVER_CALLBACK_URL', 'http://localhost/naverapi/naverinfo');
                            // $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);

                            define('NAVER_CALLBACK_URL', 'https://chipdirect.co.kr/naverapi/naverinfo');
                            $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);


                            $REST_API_KEY   = "efbf6f87ffc71fde085dec391453d989"; // 내 애플리케이션 > 앱 설정 > 요약 정보
                            $CLIENT_SECRET  = ""; // 내 애플리케이션 > 제품 설정 > 카카오 로그인 > 보안
                            // $REDIRECT_URI  = urlencode("http://localhost/kakaoapi/kakaoinfo");
                            $REDIRECT_URI  = urlencode("https://chipdirect.co.kr/kakaoapi/kakaoinfo");

                            ?>

                            <div class="form-link text-center">
                                <a class="link-register" href="<?=$naverUrl?>"><img width="150" src="<?=asset_public('images/btnW_naver.png')?>"></a>&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                                <a href="https://kauth.kakao.com/oauth/authorize?client_id=<?=$REST_API_KEY?>&response_type=code&redirect_uri=<?=$REDIRECT_URI?>"><img width="150" src="<?=asset_public('images/btnW_kakao.png')?>"></a>
                            </div>

                            <div class="form-link text-center">
                                &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                            </div>
                            <h2 class="form-title">비회원 주문조회</h2>
                        <form id="form" method="post" action="<?=route_guest('orderinfo.findorder')?>">
                            <?php if(has_error('error_common')): ?>
                                <div class="alert alert-danger">
                                    <span><?=get_error('error_common')?></span>
                                </div>
                            <?php endif?>
                            <div class="form-group">
                                <input id="order_code" type="text" class="form-control" name="order_code" placeholder="주문번호"/>
                            </div>
                            <div class="form-group">
                                <input id="order_email" type="text" class="form-control" name="order_email" placeholder="메일주소"/>
                            </div>
                            <div class="form-action">
                                <button type="submit" class="btn btn-block btn-outline-primary w-100 active" name="submit">주문조회</button>
                            </div>
                        </form>

                    </div>
                </div>

                <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
                <script>
                    $(document).ready(function () {        
                        <?php if(session()->getFlashdata('status')) {?>
                            swal({
                                title: "<?=session()->getFlashdata('status')?>",
                                text: "<?=session()->getFlashdata('status_text')?>",
                                icon: "<?=session()->getFlashdata('status_icon')?>",
                                buttons: "확인",
                            });
                        <?Php } ?>
                    });
                </script>
            </section>
        <?php endif; ?>

    <!---------------------------------------------------------------------------------------------->
    <script>
        $(function () {        
            $('.myMenu ul li').on('mouseenter mouseleave', function () {
                $(this).children('ul').stop(true, false, true).slideToggle(10);
            });
        });

        $(document).ready(function() {
            $('.category-toggle').click(function() {
                $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
                $(this).toggleClass('on');
            });
        });

        /* prd category */    
        $(".prd_cate_item a").click(function(){
            $(".prd_cate_item a").removeClass("active");
            //this는 함수를 실행하게 만든 그 클릭한 요소다!
            $(this).addClass("active");//그 요소에게 효과주고        
        });

        /* 상품 정렬 */
        $(".align-item a").click(function(){
            $(".align-item a").removeClass("active");
            //this는 함수를 실행하게 만든 그 클릭한 요소다!
            $(this).addClass("active");//그 요소에게 효과주고        
        });
        
    </script>
    <!---------------------------------------------------------------------------------------------->

    <!--/#siteMain-->
<?= $this->endSection() ?>
