<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/masterwin') ?>

<?= $this->section('head.title') ?>
    <?=lang_orderinfo('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('orderinfo.js')?>"></script>
    <script src="<?=asset_guest_js('calculator.js')?>"></script>
    <script>
        $("input[type='number']").inputSpinner();
        CartJS.init();
    </script>

    <script>
        function info_chk() {
        frm.action='<?=route_guest('orderinfo.deletepart')?>';
        frm.submit();
        return true;
        }
        function info_chk1(frm) {
        frm.action='<?=route_guest('orderinfo.sheetall')?>';
        frm.submit();
        return true;
        }
        function info_chk2(frm) {
        frm.action='<?=route_guest('orderinfo.sheet')?>';
        frm.submit();
        return true;
        }
        function info_chk3(frm) {
        frm.action='<?=route_guest('sale.estifromorderinfo')?>';
        frm.submit();
        return true;
        }
    </script>
    <script type="text/javascript" src="https://wcs.naver.net/wcslog.js"></script>

    <script type="text/javascript">
        function selectAll(selectAll)  {
        const checkboxes 
            = document.querySelectorAll('input[id="pcheckbox"]');
        checkboxes.forEach((checkbox) => {
            checkbox.checked = selectAll.checked
        })
        }
	</script>

    <link rel="stylesheet" href="<?=asset_guest_css('orderinfo.css')?>">
<?= $this->endSection() ?>
<?= $this->section('body.breadcrumb') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<!------------------------------------------------------------------------------------------------------------------->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">

    <?php if (!$lists) :?>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex">주문내역에 등록된 상품이 없습니다.</div>
            <div class="form-gp">
                <div class="d-flex g-1">
                주문내역에 등록된 상품이 없습니다.
                </div>                
            </div>
            <div class="form-gp">
                <div class="d-flex g-1">
                    <label for=""> </label>
                </div>                
            </div>
        </div>

        <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
            <a href="<?=route_guest('home')?>"><button class="btn btn-lg btn-blue w-20 ml-1">확인</button></a>
        </div>

    <?php else: ?>


        <!-- 거 래 명 세 서 s -->
        <div class="border-light-box">
            <div style="text-align: center; font-size: 40px; margin-bottom:1em;">거 래 명 세 서</div>
            <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('orderinfo.mailorderinfo')?>">
            <div class="form-gp">
            <div class="d-flex g-2">
                    <table class="table_estimate">
                        <tr>
                            <th colspan='2'>공 급 받 는 자</th>
                        </tr>
                        <tr>
                            <th>발행일</th><td>
                            <?=\App\Helpers\DateHelper::toTimeString($orderInfo->created_at,'yyyy-MM-dd')?>
                            </td>
                        </tr>
                        <tr>
                            <th>거래처명</th><td><?=$orderInfo->company_name?></td>
                        </tr>
                        <tr>
                            <th>담당자</th><td><?=$orderInfo->shipping_name?> 귀하</td>
                        </tr>
                        <tr>
                            <th>담당자 연락처</th><td><?=$orderInfo->shipping_phone?></td>
                        </tr>
                        <tr>
                            <th>총 합계</th><td><?=number_format($orderInfo->amount_total)?>원 (VAT, 배송료 포함)</td>
                        </tr>
                    </table>
                </div>
                <div class="d-flex g-2">
                    <table class="table_estimate">
                        <tr>
                            <th colspan='2'>공 급 자</th>
                        </tr>
                        <tr>
                            <th>사업자번호</th><td>215-87-35572</td>
                        </tr>
                        <tr>
                            <th>상호</th><td>주식회사 셀파세미컴</td>
                        </tr>
                        <tr>
                            <th>대표자명</th><td>김현철</td>
                        </tr>
                        <tr>
                            <th>주소</th><td>경기도 남양주시 다산중앙로 19번길 21</td>
                        </tr>
                        <tr>
                            <th>전화번호</th><td>031-556-6153</td>
                        </tr>
                    </table>
                </div>

            </div>

            
        <!-- 주문 상품정보 s -->

            <table class="table_style2 order_list">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>품명</th>
                        <th>수량</th>
                        <th>단가</th>
                        <th>공급가액</th>
                        <th>VAT</th>
                        <th>상품금액합계</th>
                        </tr>
                </thead>
                <tbody>

                <?php $i = 1; ?>

                <?php foreach($lists as $key => $item){?>

                    <tr>
                        <td class="text-center">
                            <?=show_no_row($key+1, $perPage, $currentPage)?>
                        </td>
                        <td>
                            <p class="col-blue font-sm">
                            <?php echo $item->manufacturer_name;?>
                            <label class="badge_blue font-sm">
                                <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                    <?php if($stock_location->location_id == $item->stock_location) echo $stock_location->location_info;?>
                                <?php endforeach; ?>
                            </label>
                            </p>
                            <p class="prd-subject"><?php echo $item->part_number;?></p>
                            <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                        </td>
                        <td><?php echo $item->qty?></td>
                        <td><?=number_format($item->price)?>원</td>
                        <td><?=number_format($item->supply_price)?>원</td>
                        <td><?=number_format($item->vat)?>원</td>
                        <td><?=number_format($item->amount)?>원</td>
                    </tr>

                    <?php
                    $all_qty = $all_qty + $item->qty;
                    $all_amount_price = $all_amount_price + $item->supply_price;
                    $all_price_vat = $all_price_vat + $item->vat;
                    
                    $i++; 

                    }
                    $total_all_price = $all_amount_price + $all_price_vat;
                    ?>
                </tbody>
            </table>

<!-------------------------------------------------------------------------------------------------------------------->


            <table class="table_style2 order_list_footer">
                <tbody>
                    <tr>
                        <td>공급총액: <?=number_format($total_all_price)?>원 (VAT포함)</td>
                        <td>배송료 : <?=number_format($orderInfo->delivery_fee)?>원</td>
                        <td> 합 계 : <?=number_format($orderInfo->amount_total)?>원</td>                        
                    </tr>                    
                </tbody>
            </table>

    </div>
    
    <?php 
        $orderinfoMessage .= "<table width='90%' style='border:2px solid #000;'><tr><td colspan='2'><div style='text-align: center; font-size: 40px; margin-top:1em; margin-bottom:1em;'>거 래 명 세 서</div></td></tr><tr><td width='50%'><table width='100%'>
                    <tr><td colspan='2' style='text-align:center; border: 1px solid #000;'>공 급 받 는 자</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>발행일</td><td style='text-align:left; border: 1px solid #000;'>".\App\Helpers\DateHelper::toTimeString($orderInfo->created_at,'yyyy-MM-dd')."</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>거래처명</td><td style='text-align:left; border: 1px solid #000;'>".$orderInfo->company_name."</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>담당자</td><td style='text-align:left; border: 1px solid #000;'>".$orderInfo->orderer_name." 귀하</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>담당자 연락처</td><td style='text-align:left; border: 1px solid #000;'>".$orderInfo->orderer_phone."</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>총 합계</td><td style='text-align:left; border: 1px solid #000;'>".number_format($orderInfo->amount_total)."원 (VAT, 배송료 포함)</td></tr></table></td>
                    <td width='50%'><table width='100%'><tr><td colspan='2' style='text-align:center; border: 1px solid #000;'>공 급 자</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>사업자번호</td><td style='text-align:left; border: 1px solid #000;'>215-87-35572</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>상호</td><td style='text-align:left; border: 1px solid #000;'>주식회사 셀파세미컴</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>대표자명</td><td style='text-align:left; border: 1px solid #000;'>김현철</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>주소</td><td style='text-align:left; border: 1px solid #000;'>경기도 남양주시 다산중앙로 19번길 21</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>전화번호</td><td style='text-align:left; border: 1px solid #000;'>031-556-6153</td></tr></table></td></tr><tr><td colspan='2'><table width='100%'><thead><tr>
                    <td width='5%' style='text-align:center; border: 1px solid #000;'>No.</td><td width='37%' style='text-align:center; border: 1px solid #000;'>품명</td><td width='10%' style='text-align:center; border: 1px solid #000;'>수량</td><td width='12%' style='text-align:center; border: 1px solid #000;'>단가</td>
                    <td width='12%' style='text-align:center; border: 1px solid #000;'>공급가액</td><td width='12%' style='text-align:center; border: 1px solid #000;'>VAT</td><td width='12%' style='text-align:center; border: 1px solid #000;'>상품금액합계</td></tr></thead><tbody>";

                    $i = 1; 
                    $deliverydays = 0;
                    foreach($lists as $key => $item){

        $orderinfoMessage .= "<tr><td style='text-align:center; border: 1px solid #000;'>".show_no_row($key+1, $perPage, $currentPage)."</td><td style='border: 1px solid #000;'><p>".$item->name;
                            foreach ($stocklocationcategorys as $stock_location): 
                                if($stock_location->location_id == $item->nowinfo['stock_location']) 
        $orderinfoMessage .= " (".$stock_location->location_info.")";
                            endforeach;
        $orderinfoMessage .= "</p><p>".$item->part_number."</p><p>".$item->nowinfo['product_code']."</p></td><td style='text-align:center; border: 1px solid #000;'>".$item->qty."</td><td style='text-align:center; border: 1px solid #000;'>".number_format($item->price)."원</td>
                    <td style='text-align:center; border: 1px solid #000;'>".number_format($item->supply_price)."원</td><td style='text-align:center; border: 1px solid #000;'>".number_format($item->vat)."원</td><td style='text-align:center; border: 1px solid #000;'>".number_format($item->amount)."원</td></tr>";

                    $mailall_qty = $mailall_qty + $item->qty;
                    $mailall_amount_price = $mailall_amount_price + $item->supply_price;
                    $mailall_price_vat = $mailall_price_vat + $item->vat;
                    
                    $i++; 

                    }
                    $total_mailall_price = $mailall_amount_price + $mailall_price_vat;

        $orderinfoMessage .= "</tbody></table><table width='100%' style='border:1px solid #000;'><tbody><tr><td style='text-align:center;'>공급총액: ".number_format($total_mailall_price)."원 (VAT포함)</td><td style='text-align:center;'>배송료: ".number_format($orderInfo->delivery_fee)."원</td>
                    <td style='text-align:center;'> 합 계 : ".number_format($orderInfo->amount_total)."원</td></tr></tbody></table></td></tr></thead>";
    ?>
        <input type="hidden" name="orderer_name" value="<?=$orderInfo->orderer_name?>"/>
        <input type="hidden" name="orderer_email" value="<?=$orderInfo->orderer_email?>"/>
        <input type="hidden" name="orderinfomessage" value="<?=$orderinfoMessage?>"/>

        <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
            <button type="submit" class="btn btn-lg btn-blue w-20 ml-1">확인</button>
        </div>

    </form>

    <?php endif;?>

</section>
<!-- product details top info e -->
        
<!------------------------------------------------------------------------------------------------------------------->
<!------------------------------------------------------------------------------------------------------------------->

<?= $this->endSection() ?>
