<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">

    <style>
        .news-detail .item .title {
            text-align: center;
            /*text-transform: uppercase;*/
            background-color: #ddd;
            padding: 10px;
        }
        .news-detail .item .content{
            padding: 10px;
        }
        .news-detail div.row.item{
            border: #E6E6E6 1px solid;
            margin: 0 auto;
        }
        .step-news-detail{
            color: #b00020;
        }
        .news-detail div.row.button{
            padding: 10px;
        }
        .content .hit{
            padding-left: 10px;
        }
    </style>
    <div class="container">
        <!--h6 class="step-news-detail">List <i class="fas fa-angle-right"></i> Detail </h6-->

    <div class="sub07Wrap">
        <div class="wrap">
            <div class="subWrap01Top">
                <div class="sub_category">
                    <div class="sub_categoryName">
                        <p>HOME > <?=lang_review('title')?>
                    </div>
                    <div class="sub_categoryBtn">
                        <p>서브메뉴 접기 </p>
                        <span><img src="<?=asset_public('images/upbtn.png')?>" alt="접기"></span>
                    </div>
                </div>
                <div class="sub_categoryMenu on">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li class="on"><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>
            </div>


<!---------------------------------------------------------------------------------------------------------------->
<div class="order_ListTdWrap">
 
            <div class="order_List mb40">
                <div class="order_ListTh">
                    <ul> 
                        <li class="order_ListTh01">제품사진</li>
                        <li class="order_ListTh02">주문상품</li>
                        <li class="order_ListTh02">단가</li>
                    </ul>
                </div>

                <div class="subWrap01ContsList">
                    <div class="subWrap01ContsList_line">
                            <div class="subWrap01ContsName01_sub">
                            <?php if(isset($productinfo->image_dir) && $productinfo->image_dir != ''): ?>

                            <?php if(isset($productinfo->api_flg) && $productinfo->api_flg == '1'): ?>
                                <img src="<?=$productinfo->image_dir?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($productinfo->image_dir)?>"/>
                            <?php endif; ?>

                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                            </div>
                            <div class="flex_sb mosubWrap01">
                                <div class="subWrap01ContsName02_sub">
                                    <p class="subWrap01ContsName02_sub01">
                        <?=$productinfo->name?>
                                    </p>
                                    <p class="subWrap01ContsName02_sub02">
                        <a href="<?=route_guest('sale.detail', $productinfo->product_code)?>">
                        <?=$productinfo->part_number?>
                        </a>
                        <input id="name" type="hidden" class="form-control" name="part_number" value="<?=$productinfo->part_number?>" placeholder="<?=lang_cart('part_number')?>" aria-describedby="part_number"/>
                                    </p>
                                    <p class="subWrap01ContsName02_sub03">
                        <?=$productinfo->part_number_sequence?>
                                    </p>
                                    <div class="subWrap01ContsName02_sub04">
                                    <p>
                        <?php
                        echo mb_strimwidth($productinfo->brief_description,'0',60,'...','utf-8');
                        ?>
                        <br>
                        관련 부품 : <?=$productinfo->product_related?>
                                        </p>
                                    </div>
                                </div>
                                <div class="subWrap01ContsName03_sub">
                                    <div class="subWrap01subTag0<?=$productinfo->stock_location?>"><span><?=$productinfo->location_info?></span></div>
                                    <table border="0" width="85%">
                                    <tr>
                                    <td width="50%" height="10" align="left"><font color="red">MOQ :</font></td><td align="right"><font color="red"><?=\App\Helpers\NumberHelper::format($productinfo->moq, true)?></font></td>
                                    </tr>
                                    <tr>
                                    <td width="50%" height="10" align="left"><font color="red">MPQ :</font></td><td align="right"><font color="red"><?=\App\Helpers\NumberHelper::format($productinfo->mpq, true)?></font></td>
                                    </tr>
                                    </table>
                                    <span><?=$productinfo->leadtime_info?></span>
                                    <?=$productinfo->delivery_info?> 배송비
                                </div>
                            
                                <div class="subWrap01ContsName04_sub">
                                    <p class="subWrap01price">
                                        <?=\App\Helpers\NumberHelper::format($productinfo->selling_price1, true)?><?=lang_sale('price_unit')?>
                                    </p>

                                    <div class="subWrap02RInfo4Box">
                                        <ul class="subWrap02RInfo4BoxList">
                                            <li>
                                            <?php 
                                                if($productinfo->unit_mini_quantity1 > 0) {
                                                echo '<p>수량단가1 : '.$productinfo->unit_mini_quantity1.' ~ ';
                                                if($productinfo->unit_mini_quantity2 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity2;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price1, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>    
                                            </li>
                                            <li>
                                            <?php 
                                                if($productinfo->unit_mini_quantity2 > 0) {
                                                echo '<p>수량단가2 : '.$productinfo->unit_mini_quantity2.' ~ ';
                                                if($productinfo->unit_mini_quantity3 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity3;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price2, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>   
                                            </li>
                                            <li>
                                            <?php 
                                                if($productinfo->unit_mini_quantity3 > 0) {
                                                echo '<p>수량단가3 : '.$productinfo->unit_mini_quantity3.' ~ ';
                                                if($productinfo->unit_mini_quantity4 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity4;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price3, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>
                                            </li>
                                        </ul>
                                        <ul class="subWrap02RInfo4BoxList">
                                            <li>
                                            <?php 
                                                if($productinfo->unit_mini_quantity4 > 0) {
                                                echo '<p>수량단가4 : '.$productinfo->unit_mini_quantity4.' ~ ';
                                                if($productinfo->unit_mini_quantity5 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity5;} else {echo '&#8734;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price4, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>    
                                            </li>
                                            <li>
                                            <?php 
                                                if($productinfo->unit_mini_quantity5 > 0) {
                                                echo '<p>수량단가5 : '.$productinfo->unit_mini_quantity5.' ~ ';
                                                if($productinfo->unit_mini_quantity6 > 0) {
                                                echo ''.$productinfo->unit_mini_quantity3;} else {echo '&#8764;';}
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price5, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>   
                                            </li>
                                            <li>
                                            <?php 
                                                if($productinfo->unit_mini_quantity6 > 0) {
                                                echo '<p>수량단가6 : '.$productinfo->unit_mini_quantity6.' ~ ';
                                                echo '&#8734;';
                                                echo lang_sale('quantity_unit').' | '.\App\Helpers\NumberHelper::format($productinfo->selling_price6, true).''.lang_sale('price_unit').'</p>';
                                                }
                                            ?>
                                            </li>
                                        </ul>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>

  <!-------------------------------------------------------------------------------------------------------------------->

            <div class="order_List inquiry mb40 ">
                <div class="order_ListTh inquiry">
                    <ul>
                        <li class="order_ListTh01"><?=lang_review('title')?></li>
                        <li class="order_ListTh01"><?=lang_contact('news_hit')?> : 
                        <span><?=\App\Helpers\NumberHelper::format($item->hit_number, true)?></span></li>                   
                    </ul>
                </div>
            </div>
            
            <div class="inquiry">
                <div class="inquiryT">
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_contact('news_title')?></p>
                        </div>
                        <div class="inquiryText">
                            <?=$item->title?>
                        </div>
                    </div>

                    <!--div class="inquiryT">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p><?=lang_contact('news_file')?></p>
                            </div>
                            <div class="inquiryText">
                                <p>
                                <?php foreach ($files as $index => $fileItem): ?>
                                    <div class="input-group">
                                        <label>
                                            <a href="<?=route_guest('review.view_file', $item->id, $fileItem->file_no)?>" target="<?=open_file_browser($fileItem->file_name)?>">
                                                <?=$fileItem->file_name?>
                                            </a>
                                        </label>
                                    </div>
                                <?php endforeach;?>
                                </p>
                            </div>
                        </div>
                    </div-->

                    <div class="inquiryWrapB">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_contact('news_id')?></p>
                            </div>
                            <div class="inquiryText">
                                <?=$item->user_name?>
                            </div>
                        </div>
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_contact('news_category')?></p>
                            </div>
                            <div class="inquiryText">
                                <?=$item->category_name?>
                            </div>

                        </div>
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_contact('news_date')?></p>
                            </div>
                            <div class="inquiryText">
                                 <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="inquiryWrapD">
                    <div class="inquiryLable100">
                        <p><?=lang_common('content')?></p>
                    </div>
                </div>
                <div class="inquiryContents">
                    <?php echo htmlspecialchars_decode($item->content)?>
                </div>
            </div>

            <div class="inquirybtnList">
                <ul>
                    <!--li><a href="#">이전내용</a></li-->
                    <li class="inquiryList"><a href="<?=route_guest('review')?>"><?=lang_contact('news_list')?></a></li>
                    <li><a href="<?=route_guest('review.update', $item->id)?>"><?=lang_common('update')?></a></li>
                    <!--li><a href="#">다음내용</a></li-->
                </ul>
            </div>

        </div>

        <!--div class="sub04LastBtn">
            <ul>
                <li><button class="sub04payBtn"><span>확인</span></button></li>
                <li><button class="sub04cartBtn"><span>취소</span></button></li>
            </ul>
        </div-->

    </div>

    </div>
</section>  
<?= $this->endSection() ?>
