<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_sale('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('check_all.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>

<?= $this->endSection()?>

<!--
<?= $this->section('body.breadcrumb') ?>

<?= $this->endSection() ?>
-->

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">
<script>
        function info_chk() {
        return true;
        }
        function info_chk2(frm) {
        frm.action='<?=route_guest('sale.estimate')?>';
        frm.submit();
        return true;
        }
        function info_chk3(frm) {
        frm.action='<?=route_guest('cart.buynow')?>';
        frm.submit();
        return true;
        }
</script>

<!------------------------------------------------------------>

<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">

        <?php if (!$keyword) { ?>
        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
                <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
                <?php if($part_category1_name): ?>
                    <?php echo "<li><a href='".route_guest('sale.index')."?part_category=".$part_category1_code."'>"; ?><?=$part_category1_name?></a></li>
                <?php endif; ?> 
                <?php if($part_category2_name): ?>
                    <?php echo "<li><a href='".route_guest('sale.index')."?part_category2=".$part_category2_code."'>"; ?><?=$part_category2_name?></a></li>
                <?php endif; ?>    

            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <?php 
                    if ($part_category1_mlist) {
                        foreach ($part_category1_mlist as $key => $mitem):
                        echo "<option value=''>".$mitem['categorylevel1_name']."</option>";
                        endforeach; 
                    } elseif ($part_category2_mlist) {
                        foreach ($part_category2_mlist as $key => $mitem):
                        echo "<option value=''>".$mitem['categorylevel2_name']."</option>";
                        endforeach; 
                    } else {
                       //  foreach ($part_category1_mlist as $key => $mitem):
                       //  echo "<option value=''>".$mitem['categorylevel1_name']."</option>";
                       //  endforeach; 
                    }
                ?>
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">
                    <?php 
                        if ($part_category1_name) {
                            echo $part_category1_name;
                        } elseif ($part_category2_name) {
                            echo $part_category2_name;
                        } else {
                            echo $part_category1_name;
                        }
                    ?>
                </div>
                <div class="category-box">
                    <ul>
                    <?php 
                        if ($part_category1_mlist) {
                            foreach ($part_category1_mlist as $key => $mitem):
                            echo "<li class='prd_cate_item'>";
                            echo "<a href='".route_guest('sale.index')."?part_category=".$mitem['categorylevel1_code']."' ";
                            if ($part_category==$mitem['categorylevel1_code'] || $search_code == $mitem['categorylevel1_code']){echo "class='active'";}
                            echo ">".$mitem['categorylevel1_name']."</a></li>";
                            endforeach; 
                        } elseif ($part_category2_mlist) {
                            foreach ($part_category2_mlist as $key => $mitem):
                            echo "<li class='prd_cate_item'>";
                            echo "<a href='".route_guest('sale.index')."?part_category2=".$mitem['categorylevel2_code']."' ";
                            if ($part_category2 == $mitem['categorylevel2_code'] ){echo "class='active'";}                        
                            echo ">".$mitem['categorylevel2_name']."</a></li>";
                            endforeach; 
                        } else {
                            // foreach ($part_category1_mlist as $key => $mitem):
                            // echo "<li class='prd_cate_item'><a href='".route_guest('sale.index')."?part_category=".$mitem['categorylevel1_code']."'>".$mitem['categorylevel1_name']."</a></li>";
                            // endforeach; 
                        }
                    ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php } ?>

        <?php
        $this_url = $_SERVER[ "QUERY_STRING" ];
        $this_uri = explode("&sort", $this_url);
        $link_uri = $this_uri[0].'&'; 
        ?>

        <div class="d-flex mt-2 prd-list-title">
            <div class="align-l g-2">
                <h2 class="mb-0 pb-0">검색된 상품 <span class="col-blue"><?=$totalRowStr?></span></h2>
            </div>
            <div class="g-2 align-r">
                <ul class="prd-list-align">
                    <?php if($sort == 'recent'): ?>
                        <li class="align-item"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=recent" class="active">최근 등록순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=recent">최근 등록순</a></li>
                    <?php endif; ?>
                    <?php if($sort == 'hprice'): ?>
                        <li class="on"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=hprice" class="active">높은 가격순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=hprice">높은 가격순</a></li>
                    <?php endif; ?>
                    <?php if($sort == 'lprice'): ?>
                        <li class="align-item"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=lprice" class="active">낮은 가격순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=lprice">낮은 가격순</a></li>
                    <?php endif; ?>

                    <?php if($sort == 'brand'): ?>
                        <li class="align-item"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=brand" class="active">브랜드 순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest('sale.index')?>?<?=$link_uri?>sort=brand">브랜드 순</a></li>
                    <?php endif; ?>
                </ul>

                <select name="" id="" class="prd-align-mo prd-list-align-mo">
                    <option value="">최근 등록순</option>
                    <option value="">높은 가격순</option>
                    <option value="">낮은 가격순</option>
                    <option value="">브랜드 순</option>
                </select>
            </div>
        </div>

<div class="prd-linelist">
    <table>
      <thead>
        <tr>
          <td class="image">Image</td>
          <td class="info1">Mfr.Part#</td>
          <td class="info2">Manufacturer</td>
          <td class="desc">Description</td>
          <td class="info2">Quantity</td>
          <td class="info3">MOQ/MPQ/PKG</td>
          <td class="info4">Priceing</td>
          <td class="info5">Quantity</td>
        </tr>
        </tr>
      </thead>
      <tbody>

      <?php foreach ($lists as $key => $item): ?>
                <form id="form" action="<?=route_guest('sale.inquiry.part')?>" method="post" onsubmit='return info_chk()'>
                <input type="hidden" name="inquiry_code" value="<?=AuthHelpers::getIqrCode()?>"/>
                <input type="hidden" name="member_id" value="<?=AuthHelpers::getLoginInfoGuest()->member_email?>"/>
                <input type="hidden" name="name" value="<?=$item->name?>"/>
                <input type="hidden" name="part_sequence" value="<?=$item->product_code?>"/>
                <input type="hidden" name="category3_code" value="<?=$item->part_category3?>"/>
                <input type="hidden" name="stock_location" value="<?=$item->stock_location?>"/>
                <input type="hidden" name="delivery_code" value="<?=$item->delivery_code?>"/>
                <input type="hidden" name="leadtime" value="<?=$item->leadtime?>"/>
                <input type="hidden" name="api_code" value="<?=$item->api_code?>"/>
                <input type="hidden" name="product_api_id" value="<?=$item->product_api_id?>"/>
                
        <tr>
        <td class="image">
            <a href="<?=route_guest('sale.detail', $item->product_code)?>">
            <?php if(isset($item->image_dir) && $item->image_dir != ''): ?>
                <?php if(isset($item->api_flg) && $item->api_flg == '1'): ?>
                    <img src="<?=$item->image_dir?>"/>
                <?php else : ?>
                    <img src="<?=asset_public($item->image_dir)?>"/>
                <?php endif; ?>
            <?php else : ?>
                <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
            <?php endif; ?>
            </a>
        </td>
        <td data-label="Mfr.Part#" class="info1">
            <div style="text-align: left;">
            <label class="badge_blue font-sm">
                <?php foreach ($stocklocationcategorys as $stock_location): ?>
                    <?php if($stock_location->location_id == $item->stock_location) echo $stock_location->location_info;?>
                <?php endforeach; ?> (<?=$item->api_code?>)
            </label>
                <?php
                    if($item->navershop_chk == 1) echo "<label class='badge_blue font-sm'>EP</label>";
                ?>
            </div>
            <a href="<?=route_guest('sale.detail', $item->product_code)?>">
            <?=$item->part_number?>
            </a>
            <input id="name" type="hidden" class="form-control" name="part_number" value="<?=$item->part_number?>" placeholder="<?=lang_cart('part_number')?>" aria-describedby="part_number"/>
        </td>
        <td data-label="Manufacturer" class="info2"><?=$item->name?></td>
        <?php
            $brief_description = $item->brief_description;
            $prd_description = explode('|^|', $brief_description);
        ?>
        <td data-label="Description" class="desc"><?=$prd_description[0]?>, <?=$prd_description[1]?></td>
        <td data-label="Quantity" class="info2">
        <?php if($item->situation == 1): ?>
            품 절
        <?php else : ?>
            <?php if($item->qty == 0): ?>
                품 절 
            <?php else : ?>
            <?=\App\Helpers\NumberHelper::format($item->qty, true)?>
            <?php endif; ?>
        <?php endif; ?>
        </td>
        <td data-label="MOQ/MPQ/PKG" class="info3">                                    
            <ul>
                <li>MOQ : <?=\App\Helpers\NumberHelper::format($item->moq, true)?></li>
                <li>MPQ : <?=\App\Helpers\NumberHelper::format($item->mpq, true)?></li>
                <li>PKG : <?=$item->packing_name?>(<?=$item->packing_code?>)</li>
            </ul>  
        </td>
        <td data-label="Priceing" class="info4">
            <ul>
                <?php 
                if($item->unit_mini_quantity1 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity1, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price1, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity2 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity2, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price2, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity3 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity3, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price3, true).''.lang_sale('price_unit').'</li>';
                }

                if($item->unit_mini_quantity4 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity4, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price4, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity5 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity5, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price5, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity6 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity6, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price6, true).''.lang_sale('price_unit').'</li>';
                }
                ?>
            </ul> 
        </td>
        <td data-label="Quantity" class="info5">
                <div class="input-box">

                        <?php if($item->situation == 1  || $item->qty == 0 || $item->selling_price1 == 0): ?>
                            <?php if($item->selling_price1 == 0 && $item->qty != 0): ?>
                            <input type="number" name="qty" value="<?=$item->moq?>" min="<?=$item->moq?>" max="10000000" step="<?=$item->mpq?>" dir="rtl"/>
                            <button class="btn btn-estimate" type="button" onclick="return info_chk2(this.form);"></button>
                            <?php else : ?>
                            <input type="number" name="qty" value="<?=$item->moq?>" min="<?=$item->moq?>" max="10000000" step="<?=$item->mpq?>" dir="rtl"/>
                            <button class="btn btn-estimate" type="button" onclick="return info_chk2(this.form);"></button>
                        <?php endif; ?>
                    <?php else : ?>
                        <input type="number" name="qty" value="<?=$item->moq?>" min="<?=$item->moq?>" max="10000000" step="<?=$item->mpq?>" dir="rtl"/>
                        <button class="btn btn-cart" type="submit"></button>
                    <?php endif; ?>

                </div>
        </td>
        </tr>

        </form>
        
        <?php endforeach; ?>
      </tbody>
    </table>

        <div class="col-12">
        <?= $pager->links() ?>
        </div>

    </div>

    </div>
</section>

<!-- product details top info e -->
<script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
<script>
    $(document).ready(function () {        
        <?php if(session()->getFlashdata('status')) {?>
            swal({
                title: "<?=session()->getFlashdata('status')?>",
                text: "<?=session()->getFlashdata('status_text')?>",
                icon: "<?=session()->getFlashdata('status_icon')?>",
                buttons: ["확인", "장바구니 보기"]
            })
            .then(function(result){
                console.log(result);
                
                if(result){
                    location.href = "/cart";
                }
            });
        <?Php } ?>
    });
</script>

<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!------------------------------------------------------------>

<?= $this->endSection() ?>
