<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_sale('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('check_all.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>

<?= $this->endSection()?>

<!--
<?= $this->section('body.breadcrumb') ?>

<?= $this->endSection() ?>
-->

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">
<script>
        function info_chk() {
        return true;
        }
        function info_chk2(frm) {
        frm.action='<?=route_guest('sale.estimate')?>';
        frm.submit();
        return true;
        }
        function info_chk3(frm) {
        frm.action='<?=route_guest('cart.buynow')?>';
        frm.submit();
        return true;
        }
</script>

<!--#siteMain-->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap prd-list-wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <?php
            if ($product_sctype == 'newproduct') {
                $product_url = 'sale.newproduct';
                $product_tit = '신상품';
            } elseif ($product_sctype == 'bestproduct') {
                $product_url = 'sale.bestproduct';
                $product_tit = '베스트상품';
            } elseif ($product_sctype == 'brandproduct') {
                $product_url = 'sale.brandproduct';
                $product_tit = '브랜드상품';
            } elseif ($product_sctype == 'eventproduct') {
                $product_url = 'sale.eventproduct';
                $product_tit = '이벤트상품';
            } elseif ($product_sctype == 'scproduct') {
                $product_url = 'sale.scproduct';
                $product_tit = 'SC상품';
            } else {
                $product_url = 'sale.newproduct';
                $product_tit = '신상품';
            }
            $this_url = $_SERVER[ "QUERY_STRING" ];
            $this_uri = explode("&sort", $this_url);
            $link_uri = $this_uri[0].'&'; 
        ?>

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
                <li><a href="#"><?=$product_tit?></a></li>                
            </ul>            
        </nav>

        <div class="border-light-box order-form">
            <div class="sub_title d-flex"><?=lang_eventinfo('title')?></div>
        </div>

        <div class="d-flex mt-2 prd-list-title">
            <div class="align-l g-2">
                <h2 class="mb-0 pb-0">검색된 상품 <span class="col-blue"><?=$totalRowStr?></span></h2>
            </div>

            <div class="g-2 align-r">
                <ul class="prd-list-align">
                    <?php if($sort == 'recent'): ?>
                        <li class="align-item"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=recent" class="active">최근 등록순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=recent">최근 등록순</a></li>
                    <?php endif; ?>
                    <?php if($sort == 'hprice'): ?>
                        <li class="on"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=hprice" class="active">높은 가격순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=hprice">높은 가격순</a></li>
                    <?php endif; ?>
                    <?php if($sort == 'lprice'): ?>
                        <li class="align-item"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=lprice" class="active">낮은 가격순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=lprice">낮은 가격순</a></li>
                    <?php endif; ?>
                    <?php if($sort == 'brand'): ?>
                        <li class="align-item"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=brand" class="active">브랜드 순</a></li>
                    <?php else : ?>
                        <li class="align-item"><a href="<?=route_guest($product_url)?>?<?=$link_uri?>sort=brand">브랜드 순</a></li>
                    <?php endif; ?>
                </ul>

                <select name="" id="" class="prd-align-mo prd-list-align-mo">
                    <option value="">최근 등록순</option>
                    <option value="">높은 가격순</option>
                    <option value="">낮은 가격순</option>
                    <option value="">브랜드 순</option>
                </select>
            </div>
        </div>


<div class="prd-linelist">
    <table>
      <thead>
        <tr>
          <td class="image">Image</td>
          <td class="info1">Mfr.Part#</td>
          <td class="info2">Manufacturer</td>
          <td class="desc">Description</td>
          <td class="info3">MOQ/MPQ/PKG</td>
          <td class="info4">Priceing</td>
          <td class="info5">Quantity</td>
        </tr>
        </tr>
      </thead>
      <tbody>

      <?php foreach ($lists as $key => $item): ?>
                <form id="form" action="<?=route_guest('sale.inquiry.part')?>" method="post" onsubmit='return info_chk()'>
                <input type="hidden" name="inquiry_code" value="<?=AuthHelpers::getIqrCode()?>"/>
                <input type="hidden" name="member_id" value="<?=AuthHelpers::getLoginInfoGuest()->member_email?>"/>
                <input type="hidden" name="name" value="<?=$item->name?>"/>
                <input type="hidden" name="part_sequence" value="<?=$item->product_code?>"/>
                <input type="hidden" name="category3_code" value="<?=$item->part_category3?>"/>
                <input type="hidden" name="stock_location" value="<?=$item->stock_location?>"/>
                <input type="hidden" name="delivery_code" value="<?=$item->delivery_code?>"/>
                <input type="hidden" name="leadtime" value="<?=$item->leadtime?>"/>
                <input type="hidden" name="api_code" value="<?=$item->api_code?>"/>
                <input type="hidden" name="product_api_id" value="<?=$item->product_api_id?>"/>
                
        <tr>
        <td class="image">
            <a href="<?=route_guest('sale.detail', $item->product_code)?>">
            <?php if(isset($item->image_dir) && $item->image_dir != ''): ?>
                <?php if(isset($item->api_flg) && $item->api_flg == '1'): ?>
                    <img src="<?=$item->image_dir?>"/>
                <?php else : ?>
                    <img src="<?=asset_public($item->image_dir)?>"/>
                <?php endif; ?>
            <?php else : ?>
                <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
            <?php endif; ?>
            </a>
        </td>
        <td data-label="Mfr.Part#" class="info1">
            <div style="text-align: left;"><label class="badge_blue font-sm">
                <?php foreach ($stocklocationcategorys as $stock_location): ?>
                    <?php if($stock_location->location_id == $item->stock_location) echo $stock_location->location_info;?>
                <?php endforeach; ?>
            </label></div>
            <a href="<?=route_guest('sale.detail', $item->product_code)?>">
            <?=$item->part_number?>
            </a>
            <input id="name" type="hidden" class="form-control" name="part_number" value="<?=$item->part_number?>" placeholder="<?=lang_cart('part_number')?>" aria-describedby="part_number"/>
        </td>
        <td data-label="Manufacturer" class="info2"><?=$item->name?></td>
        <td data-label="Description" class="desc"><?=$item->brief_description?></td>
        <td data-label="MOQ/MPQ/PKG" class="info3">                                    
            <ul>
                <li>MOQ : <?=\App\Helpers\NumberHelper::format($item->moq, true)?></li>
                <li>MPQ : <?=\App\Helpers\NumberHelper::format($item->mpq, true)?></li>
                <li>PKG : <?=$item->packing_name?>(<?=$item->packing_code?>)</li>
            </ul>  
        </td>
        <td data-label="Priceing" class="info4">
            <ul>
                <?php 
                if($item->unit_mini_quantity1 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity1, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price1, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity2 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity2, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price2, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity3 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity3, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price3, true).''.lang_sale('price_unit').'</li>';
                }

                if($item->unit_mini_quantity4 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity4, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price4, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity5 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity5, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price5, true).''.lang_sale('price_unit').'</li>';
                }
                if($item->unit_mini_quantity6 > 0) {
                echo '<li style="text-align: right;">'.\App\Helpers\NumberHelper::format($item->unit_mini_quantity6, true).'개 ~';
                echo ' '.\App\Helpers\NumberHelper::format($item->selling_price6, true).''.lang_sale('price_unit').'</li>';
                }


                ?>
            </ul> 
        </td>
        <td data-label="Quantity" class="info5">
                <div class="input-box">
                    <input style="text-align:right; display:block; margin: 0 auto;" type="number" name="qty" value="<?=$item->moq?>" min="<?=$item->moq?>" max="10000000" step="<?=$item->mpq?>"  dir="rtl"/>
                    <?php if($item->situation == 1  || $item->qty == 0 || $item->selling_price1 == 0): ?>
                        <button class="btn btn-estimate" type="button" onclick="return info_chk2(this.form);"></button>
                    <?php else : ?>
                        <button class="btn btn-cart" type="submit"></button>
                    <?php endif; ?>
                </div>
        </td>
        </tr>

        <?php endforeach; ?>
      </tbody>
    </table>

        <div class="col-12">
        <?= $pager->links() ?>
        </div>

    </div>

    </div>
</section>
<!-- product details top info e -->

    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {        
            <?php if(session()->getFlashdata('status')) {?>
                swal({
                    title: "<?=session()->getFlashdata('status')?>",
                    text: "<?=session()->getFlashdata('status_text')?>",
                    icon: "<?=session()->getFlashdata('status_icon')?>",
                    buttons: ["확인", "장바구니 보기"]
                })
                .then(function(result){
                    console.log(result);
                    
                    if(result){
                        location.href = "/cart";
                    }
                });
            <?Php } ?>
        });
    </script>

    <script>
        function count(type) {
            const resultElement = document.getElementById('result');
            let number = resultElement.innerText;
            // 더하기/빼기
            if (type === 'plus') {
                number = parseInt(number) + 1;
            } else if (type === 'minus') {
                number = parseInt(number) - 1;
            }
            // 결과 출력
            resultElement.innerText = number;
        }
    </script>

<?= $this->endSection() ?>
