<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_sale('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('check_all.js')?>"></script>
<?= $this->endSection()?>

<?= $this->section('body.breadcrumb') ?>
    
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">

    <div class="container">
        <h2 class="form-title"><?=lang_sale('list_title')?></h2>


<!--#select start-->
<ul class="search_box">
        <li>
                <div>
                    <div class="form-search">
                        <form action="<?=route_guest('sale.scproduct')?>" method="get">
                            <select class="form-control" name="Manufacturer" id="parent_select"><option>Select a Manufacturer</option></select>
                            <select class="form-control" name="category" id="child_select"></select>
                            <input type="text" name="keyword" class="form-control" minlength="3" placeholder="<?=lang_common('least3char_msg')?>" value="<?=$part_number?>">
                            <button type="submit" class="btn btn-search"><i class="fas fa-search"></i></button>
                        </form>
                    </div>
                </div>
        </li>
</ul>   

<script language="javascript" type="text/javascript">  
var mList = {
	AVENTICS : ['', 'Pneumatic cylinders, drives and grippers', 'Standard cylinders', 'MCU8', 'Valves and valve systems', 'Valves and valve systems according to standard', 'Pressure regulators', 'Flow and check valves', 'Compressed air preparation', 'Vacuum technology', 'Sensor technology', 'Pneumatic Connection Technology', 'Electrical connection technology', 'Smart Pneumatics'],
	ETC :  ['Phone', 'TV', 'LAN']
};

el_parent = document.getElementById("parent_select");
el_child = document.getElementById("child_select");

for (key in mList) {
	el_parent.innerHTML = el_parent.innerHTML + '<option>'+ key +'</option>';
}
el_parent.addEventListener('change', function populate_child(e){
	el_child.innerHTML = '';
	itm = e.target.value;
	if(itm in mList){
			for (i = 0; i < mList[itm].length; i++) {
				el_child.innerHTML = el_child.innerHTML + '<option value="'+ mList[itm][i] +'">'+ mList[itm][i] +'</option>';
			}
	}
});
</script>
<!--#Select end-->

        <ul class="sale-list">
            <li class="title">
                <div class="sale_pdf"><?=lang_sale('pdf')?></div>
                <div class="sale_image"><?=lang_sale('image')?></div>
                <div class="sale_part_number"><?=lang_sale('part_number')?></div>
                <div class="sale_quantity"><?=lang_sale('quantity')?></div>
                <div class="sale_manufacturer"><?=lang_sale('manufacturer')?></div>
                <div class="sale_part_category"><?=lang_sale('part_category')?></div>
                <div class="sale_description"><?=lang_sale('description')?></div>
            </li>
            <?php foreach ($lists as $key => $item): ?>
                <li class="sale">
                    <div class="sale_pdf">
                        <?php if(isset($item->pdf_dir) && $item->pdf_dir != ''): ?>
                            <a href="<?=route_guest('sale.view_pdf',$item->item_id, $item->part_number)?>"  target="_blank">
                                <img src="<?=asset_public('images/pdf.ico')?>"/>
                            </a>
                        <?php endif;?>
                    </div>
                    <div class="sale_image">
                        <?php if(isset($item->image_dir) && $item->image_dir != ''): ?>
                            <img src="<?=asset_public($item->image_dir)?>"/>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                    </div>
                    <div class="sale_part_number">
                        <a href="<?=route_guest('sale.detail', $item->item_id)?>">
                            <?=$item->part_number?>
                        </a>
                    </div>
                    <div class="sale_quantity">
                        <?=\App\Helpers\NumberHelper::format($item->qty, true)?>
                    </div>
                    <div class="sale_manufacturer">
                        <?=$item->name?>
                    </div>
                    <div class="sale_part_category">
                        <?=$item->part_category?>
                    </div>
                    <div class="sale_description">
                        <?=$item->description?>
                    </div>
                </li>
            <?php endforeach; ?>
            <?php if(count($lists) == 0): ?>
                <li class="sale">
                    <div style="font-size: 20px; font-weight: bold; text-align: center; padding-top: 60px;"><?=lang_common('no_product')?></div>
                </li>
            <?php endif;?>
        </ul>

        <div class="row">
            <div class="col-12">
                <?= $pager->links() ?>
            </div>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
