<?php
/***** 주문등록 API 요청 PHP 버전 ******/
// 상품 상세 페이지의 상품 정보 데이터를 가져온다(가맹점에서 작성).
function getProductInfo($productId) {
    return new ProductInfo();
    }

// 상품 상세 페이지의 반송 정보 데이터를 가져온다(가맹점에서 작성).
function getReturnInfo($productId) {
    // 상품 정보당 한 개의 반송 정보를 가져온다.
    return new ReturnInfo();
    }

// 상품 상세 페이지의 배송 정책 데이터를 가져온다(가맹점에서 작성).
function getShippingPolicy($productId) {
    // 상품 정보당 한 개의 배송 정책을 가져온다.
    return new ShippingPolicy();
    }

// 상품 상세 페이지의 연동 정보를 가져온다(가맹점에서 작성).
function getInterfaceInfo() {
    return new InterfaceInfo();
    }

/***** 해당 상품이 조합형 옵션인지 단독형 옵션인지 판단하는 내용가맹점에서 작성) **/
function isCombinationYn($productId) {
    // 해당 옵션이 조합형일 경우 true, 단독형인 경우 false를 반환
    // 조합형: 조합된 옵션으로 코드 관리, 조합된 옵션으로 가격을 가지고 있음. 조합된 옵션별 재고관리
    // 단독형: 하나의 옵션으로 코드 관리, 옵션 개별로 가격이 없음. 옵션별 재고관리 없음(상품별 재고 관리)
    return true;
    }

// 상품 상세 페이지의 선택된 옵션 정보 선택형을 가져온다(가맹점에서 작성).
function getOptionList($productId) {
    // 단독 옵션 전체 정보를 가져온다. 아래는 Mock 데이터로 특정 상품 id에 해당하는 옵션 정보만 준다.
    // 옵션 정보는 상품 번호당 복수건이 들어올 수 있다.
    $arr = array();
    if ($productId == "181") {
    
    $option = new Option();
    $option->optionName = "색상";
    $option->optionContentId = "R";
    $option->optionContent = "빨강";
    $arr[$option->optionName][0]= $option;
    $option = new Option();
    $option->optionName = "색상";
    $option->optionContentId = "B";
    $option->optionContent = "파랑";
    $arr[$option->optionName][1]= $option;
    $option = new Option();
    $option->optionName = "색상";
    $option->optionContentId = "Y";
    $option->optionContent = "노랑";
    $arr[$option->optionName][2]= $option;
    $option = new Option();
    $option->optionName = "사이즈";
    $option->optionContentId = "S";
    $option->optionContent = "Small";
    $arr[$option->optionName][3]= $option;
    $option = new Option();
    $option->optionName = "사이즈";
    $option->optionContentId = "M";
    $option->optionContent = "Medium";
    $arr[$option->optionName][4]= $option;
    $option = new Option();
    $option->optionName = "사이즈";
    $option->optionContentId = "L";
    $option->optionContent = "Large";
    $arr[$option->optionName][5]= $option;
    }
    return $arr;
    }

// 상품 상세 페이지의 선택된 옵션 정보 입력형을 가져온다(가맹점에서 작성).
function getInsertOptionList($productId) {
    $arr = array();
    $option = new Option();
    $option->optionName = "카드메시지";
    $option->optionType = "INPUT";
    $option->optionContent = "당신과 100일을 함께해서 행복했어요.";
    $arr[$option->optionName][0]= $option;
    return $arr;
    }

// 상품 상세 페이지에의 선택된 조합 옵션 정보를 가져온다(가맹점에서 작성).
function getCombinationOptionList($productId) {
    // 조합 옵션은 조합의 순서도 중요함(매핑 데이터를 가지고 있어야 하기 때문에).
    $arr = array();
        if ($productId == "181") {
        $combination = new CombinationOption();
        $arr[$combination->combinationOptionContentId] = $combination;
        $combination = new CombinationOption();
    
        $combination->combinationOptionContentId = "R_S";
        $combination->combinationOptionPrice = 1000;
        $arr[$combination->combinationOptionContentId] = $combination;
        $combination = new CombinationOption();
        $combination->combinationOptionContentId = "B_M";
        $combination->combinationOptionPrice = 0;
        $arr[$combination->combinationOptionContentId] = $combination;
        }
    return $arr;
    }

// 상품 상세 페이지에서 선택된 추가 상품 정보를 가져온다(가맹점에서 작성).
function getSupplement($productId) {
    // 추가 상품 정보를 가져온다. 아래는 Mock 데이터로 특정 상품 id에 해당하는 추가 상품 정보만 준다.
    $arr = array();
        if ($productId == "181") {
            for ($i = 0; $i < 2; $i++) {
            $supplement = new Supplement();
            $arr[$i] = $supplement;
            }
        }
    return $arr;
    }


// 상품정보
Class ProductInfo
{ var $id;
var $merchantProductId;
var $ecMallProductId;
var $name;
var $basePrice;
var $taxType;
var $infoUrl;
var $imageUrl;
var $giftName;
var $stockQuantity;
var $status;
var $supplmentSupport;
var $optionSupport;
    function ProductInfo() {
    // 상품 기본 정보로 id 단위로 구성된다. 아래는 Mock 데이터
    $this->id = "181";
    $this->merchantProductId = "181";
    $this->ecMallProductId = "181";
    $this->name = "티셔츠";
    $this->basePrice = 10000;
    $this->taxType = "TAX";
    $this->infoUrl = "http://가맹점상품URL";
    $this->imageUrl = "http://가맹점이미지URL";
    $this->giftName = "사은품";
    $this->stockQuantity = 100;
    $this->status = "ON_SALE";
    $this->supplmentSupport = false;
    $this->optionSupport = false;
    }
};

// 반송 정보
Class ReturnInfo
{ var
$productId; var
$zipcode; var
$address1; var
$address2; var
$sellername; var
$contact1; var
$contact2;
// Test용 Mock 데이터
    function ReturnInfo() {
    $this->productId = "181";
    $this->zipcode = "13591";
    $this->address1 = "경기도 성남시 분당구 서현동";
    $this->address2 = "266-1";
    $this->sellername = "테스트가맹점명";
    $this->contact1 = "01099999999";
    $this->contact2 = "01099999999";
    }
};


// 배송 정책
Class ShippingPolicy
{ var $groupId;
var $method;
var $feeType;
var $feePayType;
var $feePrice;
var $conditionFreeDeliveryPrice;
var $chargeByQuantityType;
var $chargeByQuantityRepeatQuantity;
var $chargeByQuantityRangeType;
var $chargeByQuantityRange2From;
var $chargeByQuantityRange2FeePrice;
var $chargeByQuantityRange3From;
var $chargeByQuantityRange3FeePrice;
var $areaChargeApiSupport;
var $areaChargeSplitUnit;
var $areaCharge2Price;
var $areaCharge3Price;
    function ShippingPolicy() {
    $this->groupId = "10000";
    $this->method = "DELIVERY";
    $this->feeType = "CHARGE";
    $this->feePayType = "PREPAYED";
    $this->feePrice = 2500;
    $this->areaChargeApiSupport = "false";
    $this->areaCharge2Price = 0;
    $this->areaCharge3Price = 0;
    }
};

// 추가 상품
Class Supplement
{
var $productId;
var $supplementId;
var $supplementName;
var $supplementPrice;
var $supplementStockQuantity;
var $supplementStatus;
    function Supplement() {
    $this->productId = "181";
    $this->supplementId = "1";
    $this->supplementName = "추가상품";
    $this->supplementPrice = 1000;
    $this->supplementStockQuantity = 20;
    $this->supplementStatus = "true";
    }
};

// 일반 옵션(선택형/입력형)
Class Option {
var $productId;
var $optionId;
var $optionName;
var $optionType;
var $optionContent;
var $optionContentId;
var $optionPrice;
var $optionQuantity;
var $optionYn;

    function Option() {
    $this->productId = "181";
    $this->optionid = "1";
    $this->optionName = "색상";
    $this->optionType = "SELECT";
    $this->optionContent = "빨강";
    $this->optionContentId = "R";
    $this->optionQuantity = "10";
    $this->optionYn = "true";
    }
};

// 조합 옵션
Class CombinationOption
{
var $productId;
var $combinationOptionId;
var $combinationOptionName;
var $combinationOptionContent;
var $combinationOptionContentId;
var $combinationOptionPrice;
var $combinationOptionQuantity;
var $combinationOptionYn;

    function CombinationOption() {
    $this->productId = "181";
    $this->combinationOptionId = "1";
    $this->combinationOptionName = "색상_사이즈";
    $this->combinationOptionContent = "빨강_Large";
    $this->combinationOptionContentId = "R_L";
    $this->combinationOptionPrice = "1000";
    $this->combinationOptionQuantity = "10";
    $this->combinationOptionYn = "true";
    }
};

// 연동 정보 정보
Class InterfaceInfo
{ var $salesCode;
var $cpaInflowCode;
var $naverInflowCode;
var $saClickId;
    function InterfaceInfo() {
        $this->salesCode = "1111";
    $this->cpaInflowCode = "aaa";
    $this->naverInflowCode = "ccc";
    $this->saClickId = "dddd";
    }
};


// 가맹점 상품 상세 페이지에서 네이버페이 [구매하기] 버튼을 눌렀을 경우,
// 주문 등록을 위한 API 요청을 네이버페이로 수행
// 주문 등록 API 정보는 상품 정보 API와 유사하나 일부 요소의 명칭이나 필수 항목이 다르기 때문에 유의해야함.

$productIdList = array(0 => "181"); // Mock productId정보(장바구니에서 주문 등록 요청 시에는 복수 건일 수 있으므로 배열로 저장.)
$merchantId = "np_cfldp870284";
$certiKey = "D1BC0B48-5AD5-4AFC-8A29-AB10DEAC6CE9";
$backUrl = "http://localhost";
$interfaceInfo = getInterfaceInfo();

header('Content-Type: application/xml;charset=utf-8');
$data = '<?xml version="1.0" encoding="utf-8"?>';
$data .= '<order>';
$data .= '<merchantId>' . $merchantId . '</merchantId>';
$data .= '<certiKey>' . $certiKey . '</certiKey>';
$data .= '<backUrl><![CDATA[' . $backUrl.']]></backUrl>';

if ($interfaceInfo != null) {
$data .= '<interface>';
$data .= '<salesCode>' .$interfaceInfo->salesCode. '</salesCode>';
$data .= '<cpaInflowCode>'. $interfaceInfo->cpaInflowCode. '</cpaInflowCode>';
$data .= '<naverInflowCode>'. $interfaceInfo->naverInflowCode. '</naverInflowCode>';
$data .= '<saClickId>'. $interfaceInfo->saClickId. '</saClickId>';
$data .= '</interface>';
}

foreach ($productIdList as $productId) {
    // productId를 이용하여 상품 상세페이지나 가맹점 장바구니의 상품정보를 가져온다.
    $product = getProductInfo($productId);
    $returnInfo = getReturnInfo($productId);
    $shippingPolicy = getShippingPolicy($productId);
    $optionList = getOptionList($productId);
    $insertOptionList = getInsertOptionList($productId);
    $combinationOptionList = getCombinationOptionList($productId);
    $supplements = getSupplement($productId);
    // 파라미터 정보를 이용하여 가맹점 데이터를 가지고 온 후 XML로 구성

    $data .= '<product>';
    $data .= '<id>' .$productId. '</id>';
    $data .= '<merchantProductId>' .$product->merchantProductId. '</merchantProductId>';
    $data .= '<ecMallProductId>' .$product->ecMallProductId. '</ecMallProductId>';
    $data .= '<name><![CDATA[' .$product->name. ']]></name>';
    $data .= '<basePrice>' .$product->basePrice. '</basePrice>';
    $data .= '<taxType>' .$product->taxType. '</taxType>';
    $data .= '<infoUrl><![CDATA[' .$product->infoUrl. ']]></infoUrl>';
    $data .= '<imageUrl><![CDATA[' .$product->imageUrl. ']]></imageUrl>';
    $data .= '<giftName><![CDATA[' .$product->giftName. ']]></giftName>';

    // 옵션 정보가 없는 본상품 주문일 경우는 <single> 요소가 반드시 들어가야 한다.
    if ($optionList == null && $insertOptionList == null && $combinationOptionList == null ) {
    $data .= '<single>';
    $data .= '<quantity>' .$product->stockQuantity. '</quantity>';
    $data .= '</single>';
    }


    if ($shippingPolicy != null) { // 배송 정책 정보
    $data .= '<shippingPolicy>';
    $data .= '<groupId>' .$shippingPolicy->groupId. '</groupId>';
    $data .= '<method>' .$shippingPolicy->method. '</method>';
    $data .= '<feePayType>' .$shippingPolicy->feePayType. '</feePayType>';
    $data .= '<feeType>' .$shippingPolicy->feeType. '</feeType>';
    $data .= '<feePrice>' .$shippingPolicy->feePrice. '</feePrice>';


        if ( $shippingPolicy->feeType == "CONDITIONAL_FREE") {

        $data .= '<conditionalFree>';
        $data .= '<basePrice>' .$shippingPolicy->conditionFreeDeliveryPrice.'</basePrice>';
        $data .= '</conditionalFree>';

        } else if ($shippingPolicy->feeType == "CHARGE_BY_QUANTITY") {

        $data .= '<chargeByQuantity>';
        $data .= '<type>' .$shippingPolicy->chargeByQuantityType. '</type>';

        if ($shippingPolicy->chargeByQuantityType == "REPEAT") {
        $data .= '<repeatQuantity>' .$shippingPolicy->chargeByQuantityRepeatQuantity. '</repeatQuantity>';

        } else if ($shippingPolicy->chargeByQuantityType == "RANGE") {
        $data .= '<range>';
        $data .= '<type>' .$shippingPolicy->chargeByQuantityRangeType. '</type>';
        if ($shippingPolicy->chargeByQuantityRangeType == "2") {
        $data .= '<range2From>' .$shippingPolicy->chargeByQuantityRange2From.'</range2From>';
        $data .= '<range2FeePrice>' .$shippingPolicy->chargeByQuantityRange2FeePrice. '</range2FeePrice>';
        } else if ($shippingPolicy->chargeByQuantityRangeType == "3") {
        $data .= '<range3From>' .$shippingPolicy->chargeByQuantityRange3From.'</range3From>';
        $data .= '<range3FeePrice>' .$shippingPolicy->chargeByQuantityRange3FeePrice. '</range3FeePrice>';
        }
        $data .= '</range>';
        }
        $data .= '</chargeByQuantity>';
        }

        if ($shippingPolicy->areaChargeSplitUnit != null) {
        $data .= '<surchargeByArea>';
        $data .= '<apiSupport>' .$shippingPolicy->areaChargeApiSupport. '</apiSupport>';
        $data .= '<splitUnit>' .$shippingPolicy->areaChargeSplitUnit. '</splitUnit>';
        $data .= '<area2Price>' .$shippingPolicy->areaCharge2Price. '</area2Price>';
        $data .= '<area3Price>' .$shippingPolicy->areaCharge3Price. '</area3Price>';
        $data .= '</surchargeByArea>';
        }
    $data .= '</shippingPolicy>';
    }


    // 상품 상세에서 선택된 옵션 정보가 있을 경우 옵션요소를 구성한다. 상품 상세에서 선택되는 옵션은단독형, 조합형 관계없이 조합형 형태로 보여진다.
    // 단, 단독형 옵션일 경우 옵션 자체에서 관리코드(<manageCode>)나 가격(<price>)을 관리하지 않으므로요소에서 제외된다.

    if ($optionList != null || $insertOptionList != null || $combinationOptionList != null) {
    $optionListKeys = array_keys($combinationOptionList);

        if ($combinationOptionList != null && count($combinationOptionList) > 1) { 
            for ($i=0 ; $i < count($combinationOptionList); $i++) {
            
            $data .= '<option>';

            // 해당 상품이 조합형 옵션일 경우 로직 수행
            if (isCombinationYn($productId)) {
            $data .= '<price>' .$combinationOptionList[$optionListKeys[$i]]->combinationOptionPrice. '</price>';
            $data .= '<manageCode><![CDATA[' .$combinationOptionList[$optionListKeys[$i]]->combinationOptionContentId. ']]></manageCode>';
            }

            $data .= '<quantity>' .$combinationOptionList[$optionListKeys[$i]]->combinationOptionQuantity. '</quantity>';
            $count = 0;

                foreach (explode("_", $combinationOptionList[$optionListKeys[$i]]->combinationOptionName) as $combinationName) {
                $contentIdList = explode("_",$combinationOptionList[$optionListKeys[$i]]->combinationOptionContentId);
                $contentList = explode("_", $combinationOptionList[$optionListKeys[$i]]->combinationOptionContent);

                $data .= '<selectedItem>';
                $data .= '<type>SELECT</type>';
                $data .= '<name><![CDATA[' .$combinationName. ']]></name>';
                $data .= '<value>';
                $data .= '<id>' .$contentIdList[$count]. '</id>';
                $data .= '<text><![CDATA[' .$contentList[$count]. ']]></text>';
                $data .= '</value>';
                $data .= '</selectedItem>';
                $count++;

                }

            $data .= '</option>';
            }
        }
    }

    foreach ($supplements as $supplement) {
        $data .= '<supplement>';
        $data .= '<id>' .$supplement->supplementId. '</id>';
        $data .= '<name><![CDATA[' .$supplement->supplementName. ']]></name>';
        $data .= '<price>' .$supplement->supplementPrice. '</price>';
        $data .= '<quantity>' .$supplement->supplementStockQuantity. '</quantity>';
        $data .= '</supplement>';
    }

    $data .= '</product>';

}

//end while;
$data .= '</order>';


echo($data);


// 주문 등록 API 호출
$url = "https://test-api.pay.naver.com/o/customer/api/order/v20/register";
$ci = curl_init();
$headers = array('Content-Type: application/xml; charset=utf-8');

curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, FALSE);
curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, FALSE);
curl_setopt($ci, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ci, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
curl_setopt($ci, CURLOPT_URL, $url);
curl_setopt($ci, CURLOPT_POST, TRUE);
curl_setopt($ci, CURLOPT_TIMEOUT, 10);
curl_setopt($ci, CURLOPT_POSTFIELDS, $data);

// 주문 등록 후 결과값 확인
$response = curl_exec($ci);
curl_close ($ci);
$param = explode(':', $response);

echo($param);

/*
if ($param[0] == "SUCCESS") { // 성공일 경우
$requestParam = "/".$param[1]."/".$param[2];
}

// 주문서 URL 재전송(redirect)
$redirectUrl = "https://test-order.pay.naver.com/customer/buy".$requestParam;
header("Location:".$redirectUrl);

exit();
*/

?>