jQuery.validator.addMethod("string", function(value, element) {
    return this.optional( element ) || /^\d+$/.test( value );
}, "Please specify the correct domain for your documents");

jQuery.validator.addMethod("is_unique",function(value, element, param) {
    let data = "param1="+value+"&param2="+param;
    let url = $('input[name=url_validation_is_unique]').val();
    let result = false;
    let previous = this.previousValue( element, 'is_unique' );
    if ( previous.old === value ) {
        return previous.valid;
    }
    previous.old = value;
    let params = {
        type: 'get',
        url: url,
        data: data,
        async: false,
        dataType: 'json',
        success: function(data) {
            result = data.status;
        },
        error: function(XMLHttpRequest, textStatus) {
        },
    };
    jQuery.ajax(params);
    previous.valid = result;
    return result;
}, "The field must contain a unique value");

jQuery.validator.addMethod("contain_alpha_and_numeric", function(value, element) {
    return this.optional( element ) || (/\d/.test( value ) && /[a-zA-Z]/.test( value ));
}, "Field must contain both alphanumeric and special character");
