if ((typeof QuoteJS) === 'undefined') { QuoteJS = {}; }

var checkBoxAll = $('input[name=check_all]');
var buttonDelete = $('a.delete');
var buttonAccept = $('a.btn-accept');
var buttonNotAccept = $('a.btn-not-accept');

QuoteJS.init = function(){
    $(document).ready(function() {
        checkBoxAll.on('change',function () {
            QuoteJS.checkAll(this);
        });
        $('input[name=check_box]').on('change',function () {
            QuoteJS.checkItem(this);
        });
        buttonDelete.addClass('disabled');
        buttonDelete.on('click',function () {
            QuoteJS.deleteQuoteAction();
        });

        buttonAccept.addClass('disabled');
        buttonAccept.on('click',function () {
            QuoteJS.acceptAction();
        });
        buttonNotAccept.addClass('disabled');
        buttonNotAccept.on('click',function () {
            QuoteJS.notAcceptAction();
        });
    });
}

QuoteJS.checkAll = function (item) {
    var checked = $(item).is(":checked");
    $(item).closest('table').find('input[name=check_box]').prop('checked',checked);
    QuoteJS.checkEnableDeleteButton();
}

QuoteJS.checkItem = function (item){
    var checked = $(item).is(":checked");
    if(!checked && checkBoxAll.is(":checked")) checkBoxAll.prop('checked',false);
    QuoteJS.checkEnableDeleteButton();
}

QuoteJS.checkEnableDeleteButton = function(){
    var isCheck = false;
    checkBoxAll.closest('table').find('input[name=check_box]').each(function () {
        if($(this).is(":checked")){
            isCheck = true;
        }
    });
    if(!isCheck) {
        buttonDelete.addClass('disabled');
        buttonAccept.addClass('disabled');
        buttonNotAccept.addClass('disabled');
    }
    else {
        buttonDelete.removeClass('disabled');
        buttonAccept.removeClass('disabled');
        buttonNotAccept.removeClass('disabled');
    }
}

QuoteJS.deleteQuoteAction = function(){
    var quoteIds = [];
    checkBoxAll.closest('table').find('input[name=check_box]').each(function () {
        if($(this).is(":checked")){
            quoteIds.push($(this).val());
        }
    });
    if(quoteIds.length > 0){
        var strIds = quoteIds.join(',');
        var dataUrlOrigin = buttonDelete.attr('data-url-origin');
        buttonDelete.attr('data-url',dataUrlOrigin + strIds);
    }
}

QuoteJS.acceptAction = function(){
    var quoteIds = [];
    checkBoxAll.closest('table').find('input[name=check_box]').each(function () {
        if($(this).is(":checked")){
            quoteIds.push($(this).val());
        }
    });
    if(quoteIds.length > 0){
        var strIds = quoteIds.join(',');
        var dataUrlOrigin = buttonAccept.attr('data-url-origin');
        var currentPage = $('input[name=current_page]').val();
        if(currentPage != undefined && currentPage != '' && Number.isInteger(parseInt(currentPage))){
            buttonAccept.attr('data-url',dataUrlOrigin + strIds + '?page=' + currentPage);
        }else{
            buttonAccept.attr('data-url',dataUrlOrigin + strIds);
        }
    }
}

QuoteJS.notAcceptAction = function(){
    var quoteIds = [];
    checkBoxAll.closest('table').find('input[name=check_box]').each(function () {
        if($(this).is(":checked")){
            quoteIds.push($(this).val());
        }
    });
    if(quoteIds.length > 0){
        var strIds = quoteIds.join(',');
        var dataUrlOrigin = buttonNotAccept.attr('data-url-origin');
        var currentPage = $('input[name=current_page]').val();
        if(currentPage != undefined && currentPage != '' && Number.isInteger(parseInt(currentPage))){
            buttonNotAccept.attr('data-url',dataUrlOrigin + strIds + '?page=' + currentPage);
        }else{
            buttonNotAccept.attr('data-url',dataUrlOrigin + strIds);
        }
    }
}

QuoteJS.init();