<?php

//--------------------------------------------------------------------
// App Namespace
//--------------------------------------------------------------------
// This defines the default Namespace that is used throughout
// CodeIgniter to refer to the Application directory. Change
// this constant to change the namespace that all application
// classes should use.
//
// NOTE: changing this will require manually modifying the
// existing namespaces of App\* namespaced-classes.
//
defined('APP_NAMESPACE') || define('APP_NAMESPACE', 'App');

/*
|--------------------------------------------------------------------------
| Composer Path
|--------------------------------------------------------------------------
|
| The path that Composer's autoload file is expected to live. By default,
| the vendor folder is in the Root directory, but you can customize that here.
*/
defined('COMPOSER_PATH') || define('COMPOSER_PATH', ROOTPATH . 'vendor/autoload.php');

/*
|--------------------------------------------------------------------------
| Timing Constants
|--------------------------------------------------------------------------
|
| Provide simple ways to work with the myriad of PHP functions that
| require information to be in seconds.
*/
defined('SECOND') || define('SECOND', 1);
defined('MINUTE') || define('MINUTE', 60);
defined('HOUR')   || define('HOUR', 3600);
defined('DAY')    || define('DAY', 86400);
defined('WEEK')   || define('WEEK', 604800);
defined('MONTH')  || define('MONTH', 2592000);
defined('YEAR')   || define('YEAR', 31536000);
defined('DECADE') || define('DECADE', 315360000);

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        || define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          || define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         || define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   || define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  || define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') || define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     || define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       || define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      || define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      || define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code


defined('PUBLIC_PATH') || define('PUBLIC_PATH', ROOTPATH . 'public/');

defined('PUBLIC_FLG_ON')      || define('PUBLIC_FLG_ON', 1);//Public On
defined('PUBLIC_FLG_OFF')      || define('PUBLIC_FLG_OFF', 0);//Public Off

defined('DELETE_FLG_ON')      || define('DELETE_FLG_ON', 1);//Delete flg On
defined('DELETE_FLG_OFF')      || define('DELETE_FLG_OFF', 0);///Delete flg Off


defined('EXCEL_UPLOAD_TYPE_OVERWRITE')      || define('EXCEL_UPLOAD_TYPE_OVERWRITE', 1);//Upload type overwrite
defined('EXCEL_UPLOAD_TYPE_ADDING')      || define('EXCEL_UPLOAD_TYPE_ADDING', 2);//Upload type adding

defined('MEMBER_ACCEPT_ON')      || define('MEMBER_ACCEPT_ON', 1);//Member Accept On
defined('MEMBER_ACCEPT_OFF')      || define('MEMBER_ACCEPT_OFF', 0);//Member Accept Off

defined('MEMBER_CATEGORY_PERSON')      || define('MEMBER_CATEGORY_PERSON', 1);
defined('MEMBER_CATEGORY_COMPANY')      || define('MEMBER_CATEGORY_COMPANY', 2);
defined('MEMBER_CATEGORY_DEALER')      || define('MEMBER_CATEGORY_DEALER', 3);

defined('REMEMBER_FLG_ON')      || define('REMEMBER_FLG_ON', 1);//Remember flag on

defined('CART_TYPE_CHECK_QUOTE')      || define('CART_TYPE_CHECK_QUOTE', 1);//Remember flag on
defined('CART_TYPE_ALL_QUOTE')      || define('CART_TYPE_ALL_QUOTE', 2);//Remember flag on

defined('SALE_CATEGORY_CASH')      || define('SALE_CATEGORY_CASH', 1);
defined('SALE_CATEGORY_CARD')      || define('SALE_CATEGORY_CARD', 2);
defined('SALE_CATEGORY_TRANSFER')      || define('SALE_CATEGORY_TRANSFER', 3);

defined('DISPLAY_CATEGORY_GRID')      || define('DISPLAY_CATEGORY_GRID', 1);
defined('DISPLAY_CATEGORY_LIST')      || define('DISPLAY_CATEGORY_LIST', 2);

defined('DISPLAY_STATUS_ON')      || define('DISPLAY_STATUS_ON', 1);
defined('DISPLAY_STATUS_OFF')      || define('DISPLAY_STATUS_OFF', 2);

defined('DISPLAY_PRODUCT_NEW')      || define('DISPLAY_PRODUCT_NEW', 1);
defined('DISPLAY_PRODUCT_BEST')      || define('DISPLAY_PRODUCT_BEST', 2);
defined('DISPLAY_PRODUCT_BRAND')      || define('DISPLAY_PRODUCT_BRAND', 3);
defined('DISPLAY_PRODUCT_RECOM')      || define('DISPLAY_PRODUCT_RECOM', 4);