<?php namespace Config;

use App\Helpers\ValidatorHelper;
use App\Libraries\Excel\Excel;
use CodeIgniter\Config\Services as CoreServices;
use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Validation\Validation;

require_once SYSTEMPATH . 'Config/Services.php';

/**
 * Services Configuration file.
 *
 * Services are simply other classes/libraries that the system uses
 * to do its job. This is used by CodeIgniter to allow the core of the
 * framework to be swapped out easily without affecting the usage within
 * the rest of your application.
 *
 * This file holds any application-specific services, or service overrides
 * that you might need. An example has been included with the general
 * method format you should use for your service methods. For more examples,
 * see the core Services file at system/Config/Services.php.
 */
class Services extends CoreServices
{

	//    public static function example($getShared = true)
	//    {
	//        if ($getShared)
	//        {
	//            return static::getSharedInstance('example');
	//        }
	//
	//        return new \CodeIgniter\Example();
	//    }

    public static function breadcrumb($isConfigAdmin = true) : \App\Libraries\BreadCrumb\BreadCrumb{
        return new \App\Libraries\BreadCrumb\BreadCrumb($isConfigAdmin);
    }

    /**
     * Libary excel
     * @return App\Libraries\Excel\Excel
     */
    public static function excel(){
        return new Excel();
    }

    /**
     * The Validation class provides tools for validating input data.
     *
     * @param \Config\Validation $config
     * @param boolean            $getShared
     *
     * @return \CodeIgniter\Validation\Validation
     */
    public static function validation(\Config\Validation $config = null, bool $getShared = true)
    {
        if ($getShared)
        {
            return static::getSharedInstance('validation', $config);
        }

        if (is_null($config))
        {
            $config = config('Validation');
        }

        return new ValidatorHelper($config, static::renderer());
    }

}
