<?php namespace App\Controllers\Admin;


use App\Helpers\AuthHelpers;
use App\Helpers\FileHelper;
use App\Models\AccountManagerModel;
use App\Models\AccountManagerSubModel;

class AccountManagerController extends BaseController
{
    protected $accountModel;
    public function __construct()
    {
        $this->accountModel = new AccountManagerModel();
        $this->accountSubModel = new AccountManagerSubModel();
    }

    protected function validationMapFieldLabels()
    {
        return [
            'full_name' => 'Name',
            'email' => 'Email',
            'old_password' => 'Old Password',
            'new_password' => 'New Password',
            'pass_confirm' => 'Password Confirm',
        ];
    }

    public function index()
    {
        $account = AuthHelpers::getLoginInfoAdmin();
        $account = $this->accountModel->find($account->account_id);
        $data['account'] = $account;

        $accountSub = $this->accountSubModel->findAccountId($account->account_id);
        //var_dump($accountSub);
        //exit;

        $data['account_sub'] = $accountSub;

        $this->rules = $this->accountModel->getValidationRules(
            [
                'except_rule' => [
                    'email' => 'is_unique'
                ]
            ]
        );
        $this->rules['email'] = $this->rules['email'].'|is_unique[account_managers.email,account_id,'.$account->account_id.']';
        return $this->viewAdmin('account/index',$data);
    }

    public function update(){
        $this->rules = $this->accountModel->getValidationRules(
            [
                'only' => ['full_name', 'email'],
                'except_rule' => [
                    'email' => 'is_unique'
                ]
            ]
        );
        $accountId = AuthHelpers::getLoginInfoAdmin()->account_id;

        $info = $this->accountModel->find($accountId);
        $info_old = $this->accountModel->find($accountId);
        $infoSub = $this->accountSubModel->findAccountId($accountId);
        $infoSub_old = $this->accountSubModel->findAccountId($accountId);

        $inputs = $this->request->getPost();

        if(isset($info)){
            $this->rules['email'] = $this->rules['email'].'|is_unique[account_managers.email,account_id,'.$accountId.']';
            $info->full_name = $this->request->getPost('full_name');
            $info->account_name = $this->request->getPost('account_name');
            $info->email = $this->request->getPost('email');

            $infoSub->com_name = $this->request->getPost('com_name');
            $infoSub->ceo_name = $this->request->getPost('ceo_name');
            $infoSub->ceo_email = $this->request->getPost('ceo_email');
            $infoSub->sectors = $this->request->getPost('sectors');
            $infoSub->condition = $this->request->getPost('condition');
            $infoSub->com_zipcode = $this->request->getPost('com_zipcode');
            $infoSub->com_address1 = $this->request->getPost('com_address1');
            $infoSub->com_address2 = $this->request->getPost('com_address2');
            $infoSub->com_phone = $this->request->getPost('com_phone');
            $infoSub->com_fax = $this->request->getPost('com_fax');
            $infoSub->biz_number = $this->request->getPost('biz_number');
            $infoSub->onlinesales_number = $this->request->getPost('onlinesales_number');
            $infoSub->mall_name = $this->request->getPost('mall_name');
            $infoSub->mall_name_eng = $this->request->getPost('mall_name_eng');
            $infoSub->mall_domain = $this->request->getPost('mall_domain');

            if($this->checkValidation($inputs)){
                $fileImage = $this->request->getFile('avatar_dir');
                if(isset($fileImage) && !empty($fileImage->getClientName())){
                    FileHelper::deleteFile($info->avatar_dir);
                    $fileImagePath = FileHelper::saveFile($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_ACCOUNT, $accountId);
                    $info->avatar_dir = $fileImagePath;
                }

                if ($info_old != $info) {
                    $this->accountModel->save($info);
                }
                
                if ($infoSub_old != $infoSub) {
                $this->accountSubModel->save($infoSub);
                }

                AuthHelpers::setLoginAdmin($info->toSession());
                return redirect()->route('admin.my.edit_info')->with('message', '정보 업데이트 성공');
            }else{
                return redirect()->route('admin.my.edit_info')->withInput();
            }
        }
        return redirect()->route('admin.my.edit_info')->with('error_message', 'Account do not exit.');
    }

    public function showChangePass(){
        $this->rules = $this->accountModel->getValidationRules(
            [
                'only' => ['password', 'pass_confirm'],
            ]
        );
        $this->rules['old_password'] = 'required';
        return $this->viewAdmin('account/change_pass');
    }

    public function changePass(){
        $this->rules = $this->accountModel->getValidationRules(
            [
                'only' => ['password', 'pass_confirm'],
            ]
        );
        $this->rules['old_password'] = 'required';
        $accountId = AuthHelpers::getLoginInfoAdmin()->account_id;
        $info = $this->accountModel->find($accountId);
        $inputs = $this->request->getPost();
        if(isset($info)){
            if($this->checkValidation($inputs)){
                if($info->password != md5($inputs['old_password'])){
                    return redirect()->route('admin.my.change_pass')->with('error_message', 'Incorrect Old Password.');
                }
                $info->password = md5($inputs['password']);
                $this->accountModel->save($info);
                return redirect()->route('admin.my.edit_info')->with('message', 'Change Password Success');
            }
        }
        return redirect()->route('admin.my.change_pass')->with('error_message', 'Account do not exit.');
    }

}
