<?php namespace App\Controllers\Admin;

use App\Entities\ApiDatalogs;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;

use App\Models\ApiDatalogsModel;
use App\Services\ApiDatalogsService;


class ApiDatalogsController extends BaseController
{
    protected $apiDatalogsModel;
    protected $apiDatalogsService;

    
    public function __construct()
    {
        $this->apiDatalogsModel = new ApiDatalogsModel();
        $this->apiDatalogsService = new ApiDatalogsService();

    }

    protected function validationMapFieldLabels(){
        return [
            'product_api_id' => 'product_api_id'
        ];
    }

    public function index()
    {
        //echo "There is a Test.";
        // var_dump ($data['lists']);
        //exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['from_date']) || isset($searchInput['to_date'])) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->apiDatalogsModel->getSearch($searchInput,$perPage);

        $data['TotalCount'] = $this->apiDatalogsModel->getTotalCount();

        $data['type1'] = $this->apiDatalogsModel->getApiLogsCount("1");
        $data['type2'] = $this->apiDatalogsModel->getApiLogsCount("2");
        $data['type3'] = $this->apiDatalogsModel->getApiLogsCount("3");
        $data['type4'] = $this->apiDatalogsModel->getApiLogsCount("4");

        return $this->viewAdmin('apidatalogs/index',array_merge($data,$searchInput));
    }

    public function showCreate(){
        $this->rules = $this->apiDatalogsModel->getValidationRules();
        return $this->viewAdmin('apidatalogs/create',$data);
    }

    public function create(){
        $this->rules = $this->apiDatalogsModel->getValidationRules();

        if($this->checkValidation()){
            //var_dump ($this->request);
            //exit;
            $this->apiDatalogsService->saveApiDatalogs($this->request);
            $message = 'Create mallinfo success.';
            return redirect()->route('admin.apidatalogs.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('apidatalogs/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->apiDatalogsModel->getValidationRules();
        $mallinfoItem = $this->apiDatalogsModel->find($id);

        $data['item'] = $mallinfoItem;

        return $this->viewAdmin('apidatalogs/update', $data);
    }

    public function update($id){
        $this->rules = $this->apiDatalogsModel->getValidationRules();
        if($this->checkValidation()){
            $this->apiDatalogsService->updateApiDatalogs($id,$this->request);
            $message = "Update mallinfo success";
            return redirect()->route('admin.apidatalogs.index')->with('message',$message);
        }else{
            return view('admin/mallinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->apiDatalogsService->deleteApiDatalogs($ids);
            if($result) $message = "Delete mallinfo success";
        }
        return redirect()->route('admin.apidatalogs.index')->with('message',$message);
    }

}
