<?php namespace App\Controllers\Admin;

use App\Entities\ApiProductdetail;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\ApiProductdetailModel;
use App\Services\ApiProductdetailService;
use App\Models\ExchangeInfoModel;

class ApiProductdetailController extends BaseController
{
    protected $apiProductinfoModel;
    protected $apiProductinfoService;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->apiProductinfoModel = new ApiProductdetailModel();
        $this->apiProductinfoService = new ApiProductdetailService();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index()
    {
        // echo "Api Product Detail";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['api_partnumber']) && $searchInput['api_partnumber'] != '') $searchInput['is_search'] = true;
        $data = $this->apiProductinfoModel->getAdmin($searchInput,$perPage);

        return $this->viewAdmin('apiproductdetail/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'api_partnumber' => lang_common('api_partnumber')
        ];
    }


    public function standardInfo(){
        $count_tmp = $this->apiProductinfoModel->insertPndata();

        $message = 'Pndata update success.';
        return redirect()->route('admin.apiproductdetail.index')->with('message' , $message);

    }

    public function toProducts(){

        // $count_tmp = $this->apiProductinfoModel->updateProducts();
        $this->apiProductinfoModel->updateProducts();
        $this->apiProductinfoModel->truncate();

        $message = 'Products update success.';
        return redirect()->route('admin.apiproductdetail.index')->with('message' , $message);

    }


    public function showCreate(){
        $this->rules = $this->apiProductinfoModel->getValidationRules();

        return $this->viewAdmin('apiproductdetail/create',$data);
    }


    public function create(){
        $this->rules = $this->apiProductinfoModel->getValidationRules();
        if($this->checkValidation()){
            $this->apiProductinfoService->saveApiProductdetail($this->request,$accountManger->account_id);
            $message = 'Create ApiProductdetail success.';
            return redirect()->route('admin.apiproductdetail.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('apiproductdetail/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->apiProductinfoModel->getValidationRules();
        $apiProductinfoItem = $this->apiProductinfoModel->find($id);

        $data['item'] = $apiProductinfoItem;
        return $this->viewAdmin('apiproductdetail/update', $data);
    }

    public function update($id){
        $this->rules = $this->apiProductinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->apiProductinfoService->updateApiProductdetail($id,$this->request);

            $message = "Update apiProductinfo success";
            return redirect()->route('admin.apiproductdetail.index')->with('message',$message);
        }else{
            return view('admin/apiProductinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->apiProductinfoService->deleteApiProductdetail($ids);
            if($result) $message = "Delete apiProductinfo success";
        }
        return redirect()->route('admin.apiproductdetail.index')->with('message',$message);
    }

}
