<?php namespace App\Controllers\Admin;

use App\Entities\ApiProductinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\ApiProductinfoModel;
use App\Models\ApiPndataModel;
use App\Services\ApiProductinfoService;
use App\Models\ExchangeInfoModel;

class ApiProductinfoController extends BaseController
{
    protected $apiProductinfoModel;
    protected $apiPndataModel;
    protected $apiProductinfoService;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->apiProductinfoModel = new ApiProductinfoModel();
        $this->apiPndataModel = new ApiPndataModel();
        $this->apiProductinfoService = new ApiProductinfoService();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index()
    {

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['api_partnumber']) && $searchInput['api_partnumber'] != '') $searchInput['is_search'] = true;
        $data = $this->apiProductinfoModel->getAdmin($searchInput,$perPage);

        // var_dump(count($data['lists']));
        // exit;

        $apiPnStatus = $this->apiPndataModel->getPnStatus();
        $data['apipnstatus_count'] = count($apiPnStatus);

        return $this->viewAdmin('apiproductinfo/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'api_partnumber' => lang_common('api_partnumber')
        ];
    }


    public function standardInfo(){
        $count_tmp = $this->apiProductinfoModel->insertPndata();
        // echo $standard_amount;
        // exit;

        $message = 'Pndata update success.';
        return redirect()->route('admin.apiproductinfo.index')->with('message' , $message);
    }

    public function toProducts(){
        $this->apiProductinfoModel->updateProducts();
        $this->apiProductinfoModel->truncate();

        $message = 'Products update success.';
        return redirect()->route('admin.apiproductinfo.index')->with('message' , $message);

    }


    public function showCreate(){
        $this->rules = $this->apiProductinfoModel->getValidationRules();

        return $this->viewAdmin('apiproductinfo/create',$data);
    }


    public function create(){
        $this->rules = $this->apiProductinfoModel->getValidationRules();
        if($this->checkValidation()){
            $this->apiProductinfoService->saveApiProductinfo($this->request,$accountManger->account_id);
            $message = 'Create ApiProductinfo success.';
            return redirect()->route('admin.apiproductinfo.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('apiproductinfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->apiProductinfoModel->getValidationRules();
        $apiProductinfoItem = $this->apiProductinfoModel->find($id);

        $data['item'] = $apiProductinfoItem;
        return $this->viewAdmin('apiproductinfo/update', $data);
    }

    public function update($id){
        //var_dump($this->request);
        //exit;
        $this->rules = $this->apiProductinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->apiProductinfoService->updateApiProductinfo($id,$this->request);

            $message = "Update apiProductinfo success";
            return redirect()->route('admin.apiproductinfo.index')->with('message',$message);
        }else{
            return view('admin/apiProductinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->apiProductinfoService->deleteApiProductinfo($ids);
            if($result) $message = "Delete apiProductinfo success";
        }
        return redirect()->route('admin.apiproductinfo.index')->with('message',$message);
    }

}
