<?php namespace App\Controllers\Admin;

use App\Entities\Apiinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\ApiinfoModel;
use App\Services\ApiinfoService;

class ApiinfoController extends BaseController
{
    protected $apiinfoModel;
    protected $apiinfoService;

    public function __construct()
    {
        $this->apiinfoModel = new ApiinfoModel();
        $this->apiinfoService = new ApiinfoService();
    }

    public function index()
    {
        // echo "Packaging Unit.";
        // exit;
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['provider_name']) && $searchInput['provider_name'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->apiinfoModel->getSearch($searchInput,$perPage);
        //exit;
        return $this->viewAdmin('apiinfo/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'provider_name' => lang_common('provider_name'),
            'api_code' => lang_common('api_code')
        ];
    }

    public function showCreate(){
        // echo "Packaging Unit.";
        // exit;
        $this->rules = $this->apiinfoModel->getValidationRules();
        return $this->viewAdmin('apiinfo/create',$data);
    }

    public function create(){
        $this->rules = $this->apiinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->apiinfoService->saveApiinfo($this->request);
            $message = 'Create shippingCompany success.';
            return redirect()->route('admin.apiinfos.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('apiinfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->apiinfoModel->getValidationRules();
        $shippingCompanyItem = $this->apiinfoModel->find($id);
        $data['item'] = $shippingCompanyItem;
        return $this->viewAdmin('apiinfo/update', $data);
    }

    public function update($id){
        $this->rules = $this->apiinfoModel->getValidationRules();
        if($this->checkValidation()){
            $this->apiinfoService->updateApiinfo($id,$this->request);
            $message = "Update shippingCompany success";
            return redirect()->route('admin.apiinfos.index')->with('message',$message);
        }else{
            return view('admin/apiinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->apiinfoService->deleteApiinfo($ids);
            if($result) $message = "Delete shippingCompany success";
        }
        return redirect()->route('admin.apiinfos.index')->with('message',$message);
    }

}
